
package Paws::SSMIncidents::ListReplicationSets;
  use Moose;
  has MaxResults => (is => 'ro', isa => 'Int', traits => ['NameInRequest'], request_name => 'maxResults');
  has NextToken => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'nextToken');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'ListReplicationSets');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/listReplicationSets');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'POST');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::SSMIncidents::ListReplicationSetsOutput');
1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMIncidents::ListReplicationSets - Arguments for method ListReplicationSets on L<Paws::SSMIncidents>

=head1 DESCRIPTION

This class represents the parameters used for calling the method ListReplicationSets on the
L<AWS Systems Manager Incident Manager|Paws::SSMIncidents> service. Use the attributes of this class
as arguments to method ListReplicationSets.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to ListReplicationSets.

=head1 SYNOPSIS

    my $ssm-incidents = Paws->service('SSMIncidents');
    my $ListReplicationSetsOutput = $ssm -incidents->ListReplicationSets(
      MaxResults => 1,                # OPTIONAL
      NextToken  => 'MyNextToken',    # OPTIONAL
    );

    # Results:
    my $NextToken          = $ListReplicationSetsOutput->NextToken;
    my $ReplicationSetArns = $ListReplicationSetsOutput->ReplicationSetArns;

    # Returns a L<Paws::SSMIncidents::ListReplicationSetsOutput> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents/ListReplicationSets>

=head1 ATTRIBUTES


=head2 MaxResults => Int

The maximum number of results per page.



=head2 NextToken => Str

The pagination token to continue to the next page of results.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method ListReplicationSets in L<Paws::SSMIncidents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

