# Generated by default/object.tt
package Paws::Macie2::S3Destination;
  use Moose;
  has BucketName => (is => 'ro', isa => 'Str', request_name => 'bucketName', traits => ['NameInRequest'], required => 1);
  has KeyPrefix => (is => 'ro', isa => 'Str', request_name => 'keyPrefix', traits => ['NameInRequest']);
  has KmsKeyArn => (is => 'ro', isa => 'Str', request_name => 'kmsKeyArn', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::S3Destination

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::S3Destination object:

  $service_obj->Method(Att1 => { BucketName => $value, ..., KmsKeyArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::S3Destination object:

  $result = $service_obj->Method(...);
  $result->Att1->BucketName

=head1 DESCRIPTION

Specifies an S3 bucket to store data classification results in, and the
encryption settings to use when storing results in that bucket.

=head1 ATTRIBUTES


=head2 B<REQUIRED> BucketName => Str

The name of the bucket.


=head2 KeyPrefix => Str

The path prefix to use in the path to the location in the bucket. This
prefix specifies where to store classification results in the bucket.


=head2 B<REQUIRED> KmsKeyArn => Str

The Amazon Resource Name (ARN) of the Key Management Service (KMS)
customer master key (CMK) to use for encryption of the results. This
must be the ARN of an existing CMK that's in the same Amazon Web
Services Region as the bucket.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

