# Generated by default/object.tt
package Paws::LookoutMetrics::MetricLevelImpact;
  use Moose;
  has ContributionMatrix => (is => 'ro', isa => 'Paws::LookoutMetrics::ContributionMatrix');
  has MetricName => (is => 'ro', isa => 'Str');
  has NumTimeSeries => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::MetricLevelImpact

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::MetricLevelImpact object:

  $service_obj->Method(Att1 => { ContributionMatrix => $value, ..., NumTimeSeries => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::MetricLevelImpact object:

  $result = $service_obj->Method(...);
  $result->Att1->ContributionMatrix

=head1 DESCRIPTION

Details about a measure affected by an anomaly.

=head1 ATTRIBUTES


=head2 ContributionMatrix => L<Paws::LookoutMetrics::ContributionMatrix>

Details about the dimensions that contributed to the anomaly.


=head2 MetricName => Str

The name of the measure.


=head2 NumTimeSeries => Int

The number of anomalous metrics for the measure.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

