# Generated by default/object.tt
package Paws::FMS::ViolationDetail;
  use Moose;
  has MemberAccount => (is => 'ro', isa => 'Str', required => 1);
  has PolicyId => (is => 'ro', isa => 'Str', required => 1);
  has ResourceDescription => (is => 'ro', isa => 'Str');
  has ResourceId => (is => 'ro', isa => 'Str', required => 1);
  has ResourceTags => (is => 'ro', isa => 'ArrayRef[Paws::FMS::Tag]');
  has ResourceType => (is => 'ro', isa => 'Str', required => 1);
  has ResourceViolations => (is => 'ro', isa => 'ArrayRef[Paws::FMS::ResourceViolation]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FMS::ViolationDetail

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FMS::ViolationDetail object:

  $service_obj->Method(Att1 => { MemberAccount => $value, ..., ResourceViolations => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FMS::ViolationDetail object:

  $result = $service_obj->Method(...);
  $result->Att1->MemberAccount

=head1 DESCRIPTION

Violations for a resource based on the specified AWS Firewall Manager
policy and AWS account.

=head1 ATTRIBUTES


=head2 B<REQUIRED> MemberAccount => Str

The AWS account that the violation details were requested for.


=head2 B<REQUIRED> PolicyId => Str

The ID of the AWS Firewall Manager policy that the violation details
were requested for.


=head2 ResourceDescription => Str

Brief description for the requested resource.


=head2 B<REQUIRED> ResourceId => Str

The resource ID that the violation details were requested for.


=head2 ResourceTags => ArrayRef[L<Paws::FMS::Tag>]

The C<ResourceTag> objects associated with the resource.


=head2 B<REQUIRED> ResourceType => Str

The resource type that the violation details were requested for.


=head2 B<REQUIRED> ResourceViolations => ArrayRef[L<Paws::FMS::ResourceViolation>]

List of violations for the requested resource.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

