# Generated by default/object.tt
package Paws::Braket::DeviceSummary;
  use Moose;
  has DeviceArn => (is => 'ro', isa => 'Str', request_name => 'deviceArn', traits => ['NameInRequest'], required => 1);
  has DeviceName => (is => 'ro', isa => 'Str', request_name => 'deviceName', traits => ['NameInRequest'], required => 1);
  has DeviceStatus => (is => 'ro', isa => 'Str', request_name => 'deviceStatus', traits => ['NameInRequest'], required => 1);
  has DeviceType => (is => 'ro', isa => 'Str', request_name => 'deviceType', traits => ['NameInRequest'], required => 1);
  has ProviderName => (is => 'ro', isa => 'Str', request_name => 'providerName', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Braket::DeviceSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Braket::DeviceSummary object:

  $service_obj->Method(Att1 => { DeviceArn => $value, ..., ProviderName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Braket::DeviceSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->DeviceArn

=head1 DESCRIPTION

Includes information about the device.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DeviceArn => Str

The ARN of the device.


=head2 B<REQUIRED> DeviceName => Str

The name of the device.


=head2 B<REQUIRED> DeviceStatus => Str

The status of the device.


=head2 B<REQUIRED> DeviceType => Str

The type of the device.


=head2 B<REQUIRED> ProviderName => Str

The provider of the device.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Braket>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

