# Generated by default/object.tt
package Paws::Athena::EngineVersion;
  use Moose;
  has EffectiveEngineVersion => (is => 'ro', isa => 'Str');
  has SelectedEngineVersion => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Athena::EngineVersion

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Athena::EngineVersion object:

  $service_obj->Method(Att1 => { EffectiveEngineVersion => $value, ..., SelectedEngineVersion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Athena::EngineVersion object:

  $result = $service_obj->Method(...);
  $result->Att1->EffectiveEngineVersion

=head1 DESCRIPTION

The Athena engine version for running queries.

=head1 ATTRIBUTES


=head2 EffectiveEngineVersion => Str

Read only. The engine version on which the query runs. If the user
requests a valid engine version other than Auto, the effective engine
version is the same as the engine version that the user requested. If
the user requests Auto, the effective engine version is chosen by
Athena. When a request to update the engine version is made by a
C<CreateWorkGroup> or C<UpdateWorkGroup> operation, the
C<EffectiveEngineVersion> field is ignored.


=head2 SelectedEngineVersion => Str

The engine version requested by the user. Possible values are
determined by the output of C<ListEngineVersions>, including Auto. The
default is Auto.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Athena>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

