# -*- mode: perl; -*-

use strict;
use warnings;

use Test::More tests => 784;

use Math::BigInt;

while (<DATA>) {
    s/#.*$//;                   # remove comments
    s/\s+$//;                   # remove trailing whitespace
    next unless length;         # skip empty lines

    my ($x_str, $int_str, $frc_str) = split /:/;

    note(qq|\n\$x = Math::BigInt -> new("$x_str");|,
         qq| (\$i, \$f) = \$x -> dparts();\n\n|);

    {
        my $x = Math::BigInt -> new($x_str);
        my ($int_got, $frc_got) = $x -> dparts();

        isa_ok($int_got, "Math::BigInt");
        isa_ok($frc_got, "Math::BigInt");

        is($int_got, $int_str, "value of integer part");
        is($frc_got, $frc_str, "value of fraction part");
        is($x,       $x_str,   "input is unmodified");
    }

    note(qq|\n\$x = Math::BigInt -> new("$x_str");|,
         qq| \$i = \$x -> dparts();\n\n|);

    {
        my $x = Math::BigInt -> new($x_str);
        my $int_got = $x -> dparts();

        isa_ok($int_got, "Math::BigInt");

        is($int_got, $int_str, "value of integer part");
        is($x,       $x_str,   "input is unmodified");
    }

}

__DATA__

NaN:NaN:0

inf:inf:0
-inf:-inf:0

0:0:0

# positive numbers

1:1:0
10:10:0
100:100:0
1000:1000:0
10000:10000:0
100000:100000:0
1000000:1000000:0
10000000:10000000:0
100000000:100000000:0
1000000000:1000000000:0
10000000000:10000000000:0
100000000000:100000000000:0
1000000000000:1000000000000:0

12:12:0
120:120:0
1200:1200:0
12000:12000:0
120000:120000:0
1200000:1200000:0
12000000:12000000:0
120000000:120000000:0
1200000000:1200000000:0
12000000000:12000000000:0
120000000000:120000000000:0
1200000000000:1200000000000:0

123:123:0
1230:1230:0
12300:12300:0
123000:123000:0
1230000:1230000:0
12300000:12300000:0
123000000:123000000:0
1230000000:1230000000:0
12300000000:12300000000:0
123000000000:123000000000:0
1230000000000:1230000000000:0

1234:1234:0
12340:12340:0
123400:123400:0
1234000:1234000:0
12340000:12340000:0
123400000:123400000:0
1234000000:1234000000:0
12340000000:12340000000:0
123400000000:123400000000:0
1234000000000:1234000000000:0

3141592:3141592:0

# negative numbers

-1:-1:0
-10:-10:0
-100:-100:0
-1000:-1000:0
-10000:-10000:0
-100000:-100000:0
-1000000:-1000000:0
-10000000:-10000000:0
-100000000:-100000000:0
-1000000000:-1000000000:0
-10000000000:-10000000000:0
-100000000000:-100000000000:0
-1000000000000:-1000000000000:0

-12:-12:0
-120:-120:0
-1200:-1200:0
-12000:-12000:0
-120000:-120000:0
-1200000:-1200000:0
-12000000:-12000000:0
-120000000:-120000000:0
-1200000000:-1200000000:0
-12000000000:-12000000000:0
-120000000000:-120000000000:0
-1200000000000:-1200000000000:0

-123:-123:0
-1230:-1230:0
-12300:-12300:0
-123000:-123000:0
-1230000:-1230000:0
-12300000:-12300000:0
-123000000:-123000000:0
-1230000000:-1230000000:0
-12300000000:-12300000000:0
-123000000000:-123000000000:0
-1230000000000:-1230000000000:0

-1234:-1234:0
-12340:-12340:0
-123400:-123400:0
-1234000:-1234000:0
-12340000:-12340000:0
-123400000:-123400000:0
-1234000000:-1234000000:0
-12340000000:-12340000000:0
-123400000000:-123400000000:0
-1234000000000:-1234000000000:0

-3141592:-3141592:0
