#!/bin/sh

#THIS SCRIPT CHECKS FOR QUOTA USAGE OF VARIOUS GROUPS DEFINED IN ./group_list FILE. SCRIPT SENDS MAILS TO ADMINISTRATOR OF THE COMPANY FOR WHICH GROUP QUOTA IS EITHER 80%, 90%, OR 100% FULL.


#DELETE TEMP FILES
#rm -f /scripts/quota/groupquotausage

# DEFINE VARIABLES
MAILFILE=/scripts/quota/mails/groupquotausage.`date +%Y_%m_%d_%H:%M`
GRPLIST=/scripts/quota/group_list
MAIL100=/scripts/quota/mails/100_usage
MAIL90=/scripts/quota/mails/90_usage
MAIL80=/scripts/quota/mails/80_usage


#GET GROUP NAMES AND THEIR ADMIN EMAIL IDS FROM FILE ./group_list




echo "Dear ISGCS, " >> $MAILFILE
echo >> $MAILFILE
echo "This is the sample mail that will be send to isgcs whhen group quota script is run. Your comments are welcomed!!! " >> $MAILFILE
echo  >> $MAILFILE

for GRP in `cat $GRPLIST`
do

#CALCUTLATE VARIABLE VALUES
GRPNAME=`echo $GRP|cut -d ":" -f 1`
ADMIN=`echo $GRP|cut -d ":" -f 2`
HARDLIMIT=`quota -g $GRPNAME |tail -n 1|tr -s " " |cut -d " " -f 4`
USED=`quota -g $GRPNAME | tail -n 1|tr -s " " |cut -d " " -f 3|tr "*" " " `
PERCENT=`expr $USED \* 100 / $HARDLIMIT`

echo Company Name :- $GRPNAME  >> $MAILFILE
echo Admin e-mail id:- $ADMIN >> $MAILFILE
echo Space Used :- $USED Space Allocated :- $HARDLIMIT >> $MAILFILE
echo Percentage of disk quota used :- $PERCENT >> $MAILFILE
echo ............................................. >> $MAILFILE
echo >> $MAILFILE
done

#SEND WARNING MAIL TO ADMINISTRATOR OF THE COMPANY, BELOW LINES LOOKS FOR 80%, 90%, AND 100% UTILIZATION AND SENDS APPROPRIATE MAIL

if [ $PERCENT -ge 100 ]; then
	mail -s "Your Group $GRPNAME Quota is Full" $ADMIN < $MAIL100
else
if [ $PERCENT -ge 90 ]; then
	mail -s "Your Group $GRPNAME quota has reached 90% usage" $ADMIN < $MAIL90
else 
if [ $PERCENT -ge 80 ]; then
	mail -s "Your Group $GRPNAME Quota has reachhed 80% usage" $ADMIN < $MAIL80
fi
fi
fi

		

#THE BELOW LINE DISPLAYS THE FINAL MAIL THAT WILL BE SEND TO ISGCS ACCOUNT
clear
cat $MAILFILE

#mail -s "Group quota Usage Report for `date`" mgulati@hughes-ecomm.com < $MAILFILE
