/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ge1.h"
#ifdef USETINPUTPTRTO
void usetinputptrto_() {
  register cont  *rq = q;
  char           *rc = c;
register AFFIX A_0 = (rq + 0)->a;
register AFFIX IP = (rq + -1)->a;
  {
    A_0->t = ip;
    if ((IP->r == nil) && (IP->l == nil)) {
      ip = IP->t;
    } else {
      sprinta(IP);
      ip = rc;
      *c++ = '\0';
    }
    q = rq + -3;
    (*(rq + -2)->q) ();
    rq = q - -2;
    ip = A_0->t;
    c = rc;
  if (rc > cstore_top ) cstore_overflow();
  }
  (rq - 1)->a = IP;
  (rq + 0)->a = A_0;
  (rq + 1)->q = usetinputptrto_;
  q = rq + 1;
}
#endif

#ifdef URESETINPUTPTR
void uresetinputptr_() {
  register cont  *rq = q;
  register char  *a;
register AFFIX A_0 = (rq + 0)->a;
  {
    if (*ip != '\0')
      goto done;
    a = ip;
    ip = A_0->t;
    q = rq + -2;
    (*(rq + -1)->q) ();
    rq = q - -1;
    ip = a;
  }
done:
  (rq + 0)->a = A_0;
  (rq + 1)->q = uresetinputptr_;
  q = rq + 1;
}
#endif

#ifdef UNESTARALT
void unestaralt_() {
  register cont  *rq = q;
register AFFIX A_0 = (rq - 1)->a;
register AFFIX A_1 = (rq + 0)->a;
  register char  *sip = ip;
  {
    A_0->t = sip;
    A_0->r = nil;
    A_0->l = nil;
    ip = A_1->t;
    q = rq + -3;
    (*(rq + -2)->q) ();
    rq = q - -2;
  }
  ip = sip;
  (rq - 1)->a = A_0;
  (rq + 0)->a = A_1;
  (rq + 1)->q = unestaralt_;
  q = rq + 1;
}
#endif

#ifdef UNESTARSET
void unestarset() {
  register char  *csave = c, *sip = ip;
register AFFIX A_0 = (q--)->a;
  {
 
    A_0->t = csave;
    A_0->r = nil;
    A_0->l = nil;
    do {
      register char *rip = ip, *rc=c, special;
      if (*ip ==  '\001' || *ip == '\002') { 
        special = *ip;
         *c++ = '\0';
        q -= 1;
        (*(*(q + 1)).q) ();
        rc[0] = special;
        rc[1] = rip [1];
        rc[2] = rip [2];
        rc[3] = rip [3];
        rc[4] = rip [4];
        rc[5] = special;
        ip += 5;
        c  += 5;
     } else {
         *c++ = '\0';
         q -= 1;
         (*(*(q + 1)).q) ();
         *(c - 1) = *ip;
     }
  }
  while (*ip++ != '\0');
  }
    ip = sip;
    c = csave;
    (++q)->a = A_0;
    (++q)->q = unestarset;
}
#endif

#ifdef UMETATERMINAL
void umetaterminal() {
  register char  *sp, *term, *rip = ip, *rc = c;
  AFFIX   A_0 = q->a;
  term = A_0->t;
  sp = rip;
  if (((A_0->r) == nil) && ((A_0->l) == nil));
  else {
    term = c;
    sprinta(A_0);
    *c++ = '\0';
  }
  for (; *term != '\0'; rip++)
    if (*term++ != *rip) {
      (++q)->q = umetaterminal;
      return;
    }
  q -= 2;
  ip = rip;
  (*(*(q + 1)).q) ();
  (++q)->a = A_0;
  (++q)->q = umetaterminal;
  ip = sp;
  c = rc;
  if (rc > cstore_top ) cstore_overflow();
}
#endif

#ifdef DSETINPUTPTRTO
int dsetinputptrto_(IP,A_0)
register AFFIX A_0;
register AFFIX IP;
{
  A_0->t = ip;
  if ((IP->r == nil) && (IP->l == nil)) {
    ip = IP->t;
  } else {
    ip = c;
    sprinta(IP);
    *c++ = '\0';
  }
  return true;
}
#endif

#ifdef DRESETINPUTPTR
int dresetinputptr_(A_0)
register AFFIX A_0;
{
  if (*ip != '\0')
    return false;
  ip = A_0->t;
  return true;
}
#endif

#ifdef DNESTARALT
int dnestaralt_(A_0,A_1)
register AFFIX A_0;
register AFFIX A_1;
{
  A_0->t = ip;
  A_0->r = nil;
  A_0->l = nil;
  ip = A_1->t;
  return true;
}
#endif

#ifdef DMETATERMINAL
int dmetaterminal(A_0)
register AFFIX A_0;
{
  register char  *term, *rip = ip;
  term = A_0->t;
  if (((A_0->r) == nil) && ((A_0->l) == nil));
  else {
    term = c;
    sprinta(A_0);
    *c++ = '\0';
  }
  for (; *term != '\0'; rip++)
    if (*term++ != *rip) {
      return false;
    }
  ip = rip;
  return true;
}
#endif

