/*
   File: Filter.c
   Author: K.R. Sloan,
           James Painter
   Last Modified: 28 September 1988
   Purpose: Pass a WFF format image file from stdin to stdout
            This is a template, from which most simple image filtering
            programs can be derived.
 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s\n",
           RoutineName);
 }

static void
Pass(fdIn,fdOut)
 FILE *fdIn, *fdOut;
 {
  FrameBufferType *FBin, *FBout;
  int Bottom, Left, Top, Right;
  char Name[NameLength], Value[ValueLength];
  int x,y,n, bands, width;
  unsigned short *Pixels;  
  int passed = 0;
  
  FBin  = (FrameBufferType *)0;
  FBout = (FrameBufferType *)0;
  if (FAILURE == OpenFB(&FBin))           {                        return; }
  if (FAILURE == PassImageIn(fdIn, FBin)) { (void)CloseFB(&FBin);  return; }
  if (FAILURE == OpenFB(&FBout))          { (void)CloseFB(&FBin);  return; }
 

  /*  Copy over existing NV pairs - watch for "X-PassedBy" */
  for (n=0;;n++)
   {
    GetDescriptorN(FBin, n, Name, Value);
    if (Name[0] == '\0') break;
    if (0 == strcmp(Name,"X-PassedBy"))
     {
      if ( (strlen(Value)+strlen(RoutineName)+3) > ValueLength)
       strcpy(Value,"...");
      strcat(Value,", "); strcat(Value,RoutineName);
      passed = 1;
     }
    SetDescriptor(FBout, Name, Value);
   }

  /*  if necessary, add "X-PassedBy" */
  if (0 == passed)
   {
    strcpy(Name,"X-PassedBy");
    strcpy(Value,RoutineName);
    SetDescriptor(FBout, Name, Value);
   }

  /* Header operations over, now we can start the output stream */
  if (FAILURE == PassImageOut(fdOut, FBout))
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  /* Finally, pass the pixels */
  if (FAILURE == GetBounds(FBin, &Bottom, &Left, &Top, &Right)) 
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }


  width = Right-Left+1;
  bands = FBin->BandsPerPixel;
  Pixels = (unsigned short *) malloc( (unsigned) (width * bands * sizeof(*Pixels) ) );
  if (Pixels == NULL)
    {
      fprintf( stderr, "%s: No memory for scanline buffer!\n", RoutineName );
      exit(1);
    }

  for (y=Bottom;y<=Top;y++)
   {
     if (FAILURE == NextNPixelsIn(FBin, width, Pixels))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
      /*
         this would be a good place to modify the Pixels in the scanline
       */
     if (FAILURE == NextNPixelsOut( FBout, width, Pixels ) ) 
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

    wffFlush(FBout);    /* so that the message below is accurate */
    fprintf(stderr,"Finished scanline %d\n",y);
   }

  (void)CloseFB(&FBin);
  (void)CloseFB(&FBout);

 }

main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
 
  RoutineName = argv[ArgsParsed++];
  if (ArgsParsed < argc)  { usage(); exit (-1); }	

  Pass(stdin,stdout);

  fprintf(stderr,"\n                -30-\n");
  exit (0);
}

