/*
  File: wff2UBC.c
  Author: K.R. Sloan
  Last Modified: 1 February 1990
  Purpose: convert a .wff image to the format used in Alain Fournier's lab
 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>
char *calloc();

static char *RoutineName;
static void
usage()
 {
  fprintf(stderr,"Usage is\n\t%s\n", RoutineName);
 }

static void 
OutputUBCPixel(UBC, Pixel, BandsPerPixel, BitsPerBand)
 FILE *UBC;
 unsigned short *Pixel;
 int BandsPerPixel, BitsPerBand;
 {
  int b;

  for (b=0; b<BandsPerPixel; b++)
   fputc((unsigned char)(Pixel[b] << (16-BitsPerBand) >> 8),UBC);
 }

static int
Pass(wff,UBC)
 FILE *wff, *UBC;
 {
  FrameBufferType *FrameBuffer;
  int Bottom, Left, Top, Right, BitsPerBand, BandsPerPixel;
  char WhatBands[ValueLength], Name[NameLength], Value[ValueLength];
  int x, y;
  unsigned short *Pixel;

  FrameBuffer = (FrameBufferType *)0;
  if (FAILURE == OpenFB(&FrameBuffer))
   {
    fprintf(stderr,"%s: cannot open FrameBuffer\n",RoutineName);
    return(FAILURE);
   }

  if (FAILURE == PassImageIn(wff, FrameBuffer)) 
   {
    fprintf(stderr,"%s: cannot PassImageIn\n",RoutineName);   
    return(FAILURE);
   }

  (void)GetBounds(FrameBuffer, &Bottom, &Left, &Top, &Right);
  (void)GetColorSystem(FrameBuffer, WhatBands, &BitsPerBand);
  BandsPerPixel = strlen(WhatBands);  /* usually right! */
  if (4 < BandsPerPixel)
   {
    fprintf(stderr,"%s: UBC cannot handle %d BandsPerPixel\n",
                        RoutineName,BandsPerPixel);   
    (void)CloseFB(&FrameBuffer);
    return(FAILURE);
   }

  if ((unsigned short *)0
      ==(Pixel
         =(unsigned short *)calloc(BandsPerPixel,sizeof(unsigned short))
        )
     )
   {
    fprintf(stderr,"%s: cannot allocate Pixel\n",
                        RoutineName,BandsPerPixel);   
    (void)CloseFB(&FrameBuffer);
    return(FAILURE);
   }

  for (y=Bottom;y<=Top;y++)
   {
    for (x=Left;x<=Right;x++)
     {
      if (FAILURE == NextPixelIn(FrameBuffer,Pixel))
       { (void)CloseFB(&FrameBuffer); return(FAILURE); }
      OutputUBCPixel(UBC, Pixel, BandsPerPixel, BitsPerBand);
     }
   }
  (void)CloseFB(&FrameBuffer);
  return(SUCCESS);
 }

int main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;

  RoutineName = argv[ArgsParsed++];
  while (ArgsParsed < argc)
   {
    if ('-' != argv[ArgsParsed][0]) { usage(); exit (-1); }
    switch (argv[ArgsParsed++][1])
     {
      default:
      case 'h': { usage(); exit (-1); }
     }
   }

  if (FAILURE == Pass(stdin,stdout)) exit(-1);

  exit (0);
 }

