/*
  File: UBC22wff.c
  Authors: ???,
           Steve Mann,
           K.R. Sloan
  Last Modified: 6 February 1990
  Purpose: translate images from Alain Fornier's group to .wff
           THIS VERSION ACCEPTS 16 bit VALUES - modified from UBC2wff.c
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <strings.h>
#include "wff.h"
char *calloc();

typedef struct
         {
          unsigned short redC, greenC, blueC, alphaC;
         } ColChar;

#define TRUE  (-1)
#define FALSE (0)
#define OK    (0)
#define ERROR (-1)

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"usage:\n\t%s [-x x][-y y][-z z][-f filename]\n",
                 RoutineName);
 }

static int
GetScanLine(xRes, zRes, scanline, fileP)
 int xRes, zRes;
 FILE *fileP;
 ColChar scanline[];
 {
  register int i, val;

  switch(zRes)
   {
    case 1: for(i=0;i<xRes;i++)
             {
              scanline[i].redC   = val = (int) fgetc(fileP) |
                                        (((int) fgetc(fileP)) << 8);
                                      
             }  
            break;
    case 2: for(i=0;i<xRes;i++)
             {
              scanline[i].redC         = (int) fgetc(fileP) |
                                        ((int) fgetc(fileP) << 8);
              scanline[i].greenC = val =  (int) fgetc(fileP) |
                                        ((int) fgetc(fileP) << 8);
             }
            break;
    case 3: for(i=0;i<xRes;i++)
             {
              scanline[i].redC         = (int) fgetc(fileP) |
                                        ((int) fgetc(fileP) << 8);
              scanline[i].greenC = val =  (int) fgetc(fileP) |
                                        ((int) fgetc(fileP) << 8);
              scanline[i].blueC  = val = (int) fgetc(fileP) |
                                        ((int) fgetc(fileP) << 8);
             }
            break;
    case 4: for(i=0;i<xRes;i++)
             {
              scanline[i].redC         = (int) fgetc(fileP) |
                                        ((int) fgetc(fileP) << 8);
              scanline[i].greenC = val =  (int) fgetc(fileP) |
                                        ((int) fgetc(fileP) << 8);
              scanline[i].blueC  = val = (int) fgetc(fileP) |
                                        ((int) fgetc(fileP) << 8);
              scanline[i].alphaC = val = (int) fgetc(fileP) |
                                        ((int) fgetc(fileP) << 8);
             }
            break;
    default: fprintf(stderr, "GetScanLine: 'zRes' must be 1, 2, 3, or 4\n");
             return(ERROR);
             break;
   }
  return (EOF != val);
 }

long
FileSize(name)
 char *name;
 {
  struct stat buf;

  if (stat(name, &buf) == -1) return(-1);
  return(buf.st_size);
 }

int
GetFileSize(x,y,size,FileName)
 int *x,*y,*size;
 char *FileName;
  {
   int fileSize, square, i;
   double pix;

   if ((char *)0 == FileName)
    if (*x && *y && *size) return(OK); else return(ERROR);

   if (-1 == (fileSize = FileSize(FileName))) return(ERROR);

   if (fileSize % 2) {fprintf(stderr,"not 16 bits\n"); return(ERROR);}
   fileSize << 1;
   if (*x)
    {
     if (*size)
      {
       if (*y) return(OK);
       *y = fileSize/(*x * *size);
       return(OK);
      }
     else if (*y)
      {
       pix = ((double) fileSize)/(*x * *y);
       if ((3. == pix) || (1. == pix))
        {
         *size= pix;
         return(OK);
        }
       else return(ERROR);
      }
    }

   if (fileSize % 3)
    {
     /* check if bytesize is one */
     square = fileSize;
     for (i=0;i*i < square; i++) /* twiddle */ ;
     if (i*i != square) return(ERROR);
     *size = 1;
     *x = i;
     *y = i;
    }
   else
    {
     /* check if bytesize is three */
     square = fileSize/3;
     for (i=0; i*i < square; i++) /* twiddle */	;
     if (i*i != square) return(ERROR);
     *size = 3;
     *x = i;
     *y = i;
    }
   return(OK);
  }

static int
Pass(FileName,xRes,yRes,zRes,lbf,wff)
 char *FileName;
 int xRes,yRes,zRes;
 FILE *lbf, *wff;
 {
  int fileXStart, xStart, xSize;
  ColChar *Scanline;

  FrameBufferType *FrameBuffer;
  char Name[NameLength], Value[ValueLength];
  char WhatBands[ValueLength];
  int BitsPerBand;
  int Left, Bottom, Right, Top, x, y;
  unsigned short *Pixel;

  if (ERROR == GetFileSize(&xRes, &yRes, &zRes, FileName))
   {
    fprintf(stderr,"%s: error in GetFileSize\n",RoutineName);
    return(ERROR);
   }

  Left = 0; Bottom = 0; Right = xRes-1; Top = yRes-1;
  BitsPerBand = 10;      /* ********** yuck **************** */

  switch (zRes)
   {
    case 1: strcpy(WhatBands,"I"); break;
    case 2: strcpy(WhatBands,"IA"); break;
    case 3: strcpy(WhatBands,"RGB"); break;
    case 4: strcpy(WhatBands,"RGBA"); break;
    default: fprintf(stderr,"%s: cannot handle zRes = %d\n",
                             RoutineName, zRes);
             return(ERROR);
   }

  if ((ColChar *)0
      == (Scanline = (ColChar *)calloc(xRes,sizeof (ColChar))))
   {
    fprintf(stderr,"%s: cannot allocate Scanline\n",RoutineName);
    return(ERROR);
   }

  if ((unsigned short *)0
      == (Pixel = (unsigned short *)calloc(zRes,sizeof (unsigned short))))
   {
    fprintf(stderr,"%s: cannot allocate Pixel\n",RoutineName);
    free(Scanline);
    return(ERROR);
   }

  FrameBuffer = (FrameBufferType *)0;
  if (FAILURE == OpenFB(&FrameBuffer))
   {
    fprintf(stderr, "%s: cannot open FrameBuffer\n", RoutineName);
    free(Scanline); free(Pixel);       
    return (ERROR);
   }

  (void)SetColorSystem(FrameBuffer, WhatBands, BitsPerBand);

  (void)SetBounds(FrameBuffer, Bottom, Left, Top, Right);

  if (FAILURE == PassImageOut(wff, FrameBuffer))
   {
    fprintf(stderr, "%s: cannot PassImageOut\n", RoutineName);
    free(Scanline); free(Pixel);       
    (void) CloseFB(&FrameBuffer);
    return (ERROR); 
   }

  for(y = 0; y < yRes; y++)
   {
    if (FALSE == GetScanLine(xRes, zRes, Scanline, lbf))
     {
      fprintf(stderr, "%s: GetScanLine fails\n", RoutineName);
      free(Scanline); free(Pixel);       
      CloseFB(&FrameBuffer);
      return (ERROR);
     }
    for(x = 0; x < xRes; x++)
     {
      Pixel[0] = Scanline[x].redC;
      Pixel[1] = Scanline[x].greenC;
      Pixel[2] = Scanline[x].blueC;
      Pixel[3] = Scanline[x].alphaC;
      if (FAILURE == NextPixelOut(FrameBuffer, Pixel))
       {
        fprintf(stderr, "%s: NextPixelOut fails\n", RoutineName);
        free(Scanline); free(Pixel);       
        CloseFB(&FrameBuffer);
        return (ERROR);
       }
     }
   }
  free(Scanline); free(Pixel);
  CloseFB(&FrameBuffer);
  return(OK);
 }

int
main (argc, argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  int xRes = 0, yRes = 0, zRes = 0;
  char *FileName = (char *)0;
  FILE *lbf = (FILE *)0;

  RoutineName = argv[ArgsParsed++];
  while (ArgsParsed < argc)
   {
    if ('-' != argv[ArgsParsed][0]) { usage(); exit(ERROR); }
    switch (argv[ArgsParsed++][1])
     {
      case 'x': if (ArgsParsed >= argc) { usage(); exit(ERROR); }
                xRes = atoi(argv[ArgsParsed++]);
                break;
      case 'y': if (ArgsParsed >= argc) { usage(); exit(ERROR); }
                yRes = atoi(argv[ArgsParsed++]);
                break;
      case 'z': if (ArgsParsed >= argc) { usage(); exit(ERROR); }
                zRes = atoi(argv[ArgsParsed++]);
                break;
      case 'f': if (ArgsParsed >= argc) { usage(); exit(ERROR); }
                FileName = argv[ArgsParsed++];
                break;
      default: 
      case 'h':  { usage(); exit(ERROR); }
     }
   }

  if ((char *)0 != FileName)
   {
    if ((FILE *)0 == (lbf = fopen(FileName,"r")))
     {
      fprintf(stderr,"%s: cannot open %s\n", RoutineName, FileName);
      exit(ERROR);
     }
   }
  else lbf = stdin;

  Pass(FileName, xRes, yRes, zRes, lbf, stdout);

  exit(OK);
 }

