/*
   File: Flip.c
   Author: K.R. Sloan  
   Last Modified: 11 September 1990
   Purpose: Flip an image to one of the 8 possible orientations
 */
#include <stdio.h>
#include <strings.h>
#include <wff.h>

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,
          "Usage:\n\t%s [-x][-y][-z]\n",
          RoutineName);

 }

static void
Pass(fdIn,fdOut,x,y,z)
 FILE *fdIn, *fdOut;
 int x,y,z;
 {
  FrameBufferType *FBin, *FBout;
  int oldBottom, oldLeft, oldTop, oldRight, oldX, oldY;
  int newBottom, newLeft, newTop, newRight, newX, newY;
  char Name[NameLength], Value[ValueLength];
  int xv,yv,n;
  unsigned short Pixel[99];  /* that ought to be enough... */
  int passed = 0;

  FBin = (FrameBufferType *) 0;
  FBout= (FrameBufferType *) 0;

  if (FAILURE == OpenFB(&FBin))           {                        exit(-1); }
  if (FAILURE == ReadImage(fdIn, FBin))   { (void)CloseFB(&FBin);  exit(-1); }
  if (FAILURE == OpenFB(&FBout))          { (void)CloseFB(&FBin);  exit(-1); }
 

  /*  Copy over existing NV pairs - watch for "X-PassedBy" */
  passed = 0;
  for (n=0;;n++)
   {
    GetDescriptorN(FBin, n, Name, Value);
    if ('\0' == Name[0]) break;
    if (0 == strcmp(Name,"X-PassedBy"))
     {
      if ( (strlen(Value)+strlen(RoutineName)+3) > ValueLength)
       strcpy(Value,"...");
      strcat(Value,", "); strcat(Value,RoutineName);
      passed = 1;
     }
    SetDescriptor(FBout, Name, Value);
   }

  /*  if necessary, add "X-PassedBy" */
  if (0 == passed)
   {
    strcpy(Name,"X-PassedBy");
    strcpy(Value,RoutineName);
    SetDescriptor(FBout, Name, Value);
   }

  (void) GetBounds(FBin, &oldBottom, &oldLeft, &oldTop, &oldRight);
  newBottom = oldBottom; newTop   = oldTop;
  newLeft   = oldLeft;   newRight = oldRight;
  
  if (z)
   {
    register int t;
    
    t = newBottom; newBottom = newLeft;  newLeft  = t;
    t = newTop;    newTop    = newRight; newRight = t;
   }

  (void) SetBounds(FBout, newBottom, newLeft, newTop, newRight);

  /* Header operations over, now we can start the output stream */
  if (FAILURE == PassImageOut(fdOut, FBout))
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); exit(-1); }


  for(newY=newBottom;newY<=newTop;newY++)
   {
    if (z)
     {
      if (x) oldX = (newTop-newY)+oldLeft; else oldX = newY;
     } 
    else
     {
      if (y) oldY = (newTop-newY)+oldBottom; else oldY = newY;
     }
    for(newX=newLeft;newX<=newRight;newX++)
     {
      if (z)
       {
        if (y) oldY = (newRight-newX)+oldBottom; else oldY = newX;
       } 
      else
       {
        if (x) oldX = (newRight-newX)+oldLeft; else oldX = newX;
       }
      GetPixel(FBin,oldX,oldY,Pixel);
      NextPixelOut(FBout,Pixel);
     }

    wffFlush(FBout);
   }

  (void)CloseFB(&FBin);
  (void)CloseFB(&FBout);

 }

int main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  int x=0,y=0,z=0;
 
  RoutineName = argv[ArgsParsed++];
  
  while (ArgsParsed < argc)
   {
    if ('-' != argv[ArgsParsed][0]) {usage(); exit(-1);}
    switch (argv[ArgsParsed++][1])
     {
      case 'x': x = -1; break; 
      case 'y': y = -1; break; 
      case 'z': z = -1; break; 
      default:
      case 'h': usage();exit(-1);
     }
   }

  Pass(stdin,stdout,x,y,z);

  exit(0);
}

