#ifndef lint
static char *RCSid = "$Header: move.c,v 1.11 89/09/28 01:32:29 mr-frog Exp $";
#endif

/*
 * move.c
 *
 * Move something somewhere.  Has a weight,
 * returns move cost, and fills a result parameter
 * with the destination sector.
 *
 *
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "file.h"
#include "deity.h"
#include "xy.h"
#include "path.h"
#include "nat.h"

int
move_ground(what, start, end, mobility, weight, path, map, exploring)
	char	*what;
	struct	sctstr *start;
	struct	sctstr *end;	/* RESULT */
	double	mobility;
	double	weight;
	char	*path;
	int	(*map)();
	int	exploring;
{
	struct	sctstr sect;
	struct	sctstr next;
	int	vec[I_MAX+1];
	coord	curx, cury;
	coord	tmpx, tmpy;
	char	*movstr;
	double	sect_mcost;
	double	total_mcost;
	int	mcost;
	int	dir;
	int	intcost;

	movstr = path;
	tmpx = start->sct_x;
	curx = tmpx;
	tmpy = start->sct_y;
	cury = tmpy;
	total_mcost = 0.0;
	if (getsect(curx, cury, &sect) < 0) {
		logerror("move_path: getsect %d,%d", curx, cury);
		return -1;
	}
	for (;;) {
		tmpx = curx;
		tmpy = cury;
		if (movstr == 0 || *movstr == 0) {
			if (exploring)
				map(what, curx, cury, (char *)0);
			movstr = getstring(fmt("<%.1f: %c %s> ", mobility,
				dchr[sect.sct_type].d_mnem,
				xyas(sect.sct_x, sect.sct_y, cnum)));
		}
		if (movstr == 0 || *movstr == 0)
			movstr = dirch;
		if ((dir = chkdir(*movstr, DIR_STOP, DIR_MAP)) < 0) {
			pr(fmt("\"%c\" is not legal...", *movstr));
			direrr("'%c' to stop ", "'%c' to view ",
				"& '%c' to map\n");
			*movstr = 0;
			continue;
		}
		movstr++;
		if (dir == DIR_MAP) {
			if (!exploring)
				map(what, curx, cury, movstr+1);
			*movstr = 0;
			continue;
		} else if (dir == DIR_STOP)
			break;
		else if (dir == DIR_VIEW) {
			pr(fmt("%d%% %s with %d civilians.\n", sect.sct_effic,
				dchr[sect.sct_type].d_name,
				getvar(V_CIVIL, (char *)&sect, EF_SECTOR)));
			continue;
		}
		/*
		 * now see if we can move into the
		 * next sector.  Mobility, terrain,
		 * or ownership may prevent us.
		 */
		tmpx += diroff[dir][0];
		tmpy += diroff[dir][1];
		if (getsect(tmpx, tmpy, &next) < 0) {
			pr("You can't go there...\n");
			*movstr = 0;
			continue;
		}
		if (!god) {
			if ((next.sct_type == SCT_SANCT) &&
						       (next.sct_own != cnum)) {
				pr("Converts, huh?\n");
				*end = next;
				return total_mcost;
			}
			getvec(VT_ITEM, vec, (char *)&next, EF_SECTOR);
			mcost = dchr[next.sct_type].d_mcst;
			if ((!owner && (!exploring || 
			    (vec[I_MILIT] || vec[I_CIVIL]))) ||
			    mcost == 0) {
				/* already-owned, or prohibited terrain */
				pr("You can't go there...\n");
				*movstr = 0;
				continue;
			}
			sect_mcost = (mcost * 100 - next.sct_effic) / 500.0;
			sect_mcost *= weight;
			if (sect_mcost > mobility) {
				pr("Not enough mobility.  ");
				pr("You can't go there...\n");
				*movstr = 0;
				continue;
			}
			mobility -= sect_mcost;
			total_mcost += sect_mcost;
		}
		curx = tmpx;
		cury = tmpy;
		sect = next;
	}
	*end = sect;
	intcost = (int) total_mcost;
	if (intcost < 0)
		return -1;
	if (chance(total_mcost - intcost))
		intcost++;
	return intcost;
}
