#ifndef lint
static char *RCSid = "$Header: /u/dhay/bemp/src3/player/subs/RCS/snxtsct.c,v 1.1 91/01/11 00:30:36 dhay Exp Locker: dhay $";
#endif

/*
 * snxtsct.c
 *
 * arrange sector selection using either
 * distance or area.
 *
 * XXX we can *almost* treat sectors as items, but not quite.
 * Items are retrieved using id's, and sectors still use x,y.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "file.h"
#include "com.h"

struct	range wr = {
	-WORLD_X/2, -WORLD_Y/2, WORLD_X/2, WORLD_Y/2, 0, 0
};

/*
 * setup the nstr_sect structure for sector selection.
 * can select on either NS_ALL, NS_AREA, or NS_RANGE
 * iterate thru the "condarg" string looking
 * for arguments to compile into the nstr.
 */
int
snxtsct(np, str)
	register struct nstr_sect *np;
	s_char	*str;
{
	register s_char *cp;
	struct	range range;
	coord	cx, cy;
	int	dist;

	if (str == 0 || *str == 0) {
		if ((str = getstring("(sects)? ")) == 0)
			return 0;
	}
	switch (sarg_type(str)) {
	case NS_AREA:
		if (!sarg_area(str, &range))
			return 0;
		snxtsct_area(np, &range);
		break;
	case NS_DIST:
		if (!sarg_range(str, &cx, &cy, &dist))
			return 0;
		snxtsct_dist(np, cx, cy, dist);
		break;
	case NS_ALL:
		/* fake "all" by doing a world-sized area query */
		snxtsct_area(np, &wr);
		break;
	default:
		return 0;
	}
	if (condarg == 0)
		return 1;
	cp = condarg;
	while ((cp = nstr_comp(np->cond, &np->ncond, EF_SECTOR, cp)) && *cp)
		;
	if (cp == 0)
		return 0;
	return 1;
}
/*
 * The rest of these (snxtsct_all, snxtsct_area, etc, have been moved
 * into the common lib, since they don't use condargs, and are useful
 * elsewhere (update, chiefly). ---ts
 *
 */
