#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/SUBS/RCS/land.c,v 1.7 89/06/27 01:38:27 griffith Exp $";
#endif

/*
 * land.c
 *
 * land unit post-read and pre-write
 *
 */

#include "misc.h"
#include "var.h"
#include "file.h"
#include "land.h"
#include "ship.h"
#include "xy.h"
#include "nat.h"
#include "deity.h"
#include "nsc.h"
#include "plane.h"

int
lnd_postread(n, ptr)
	int	n;
	s_char	*ptr;
{
	struct	lndstr *pp = (struct lndstr *) ptr;
	struct	shpstr theship;
	s_char	*p;

	if (n != pp->lnd_uid){
		logerror("%s #%d doesn't match %d, old owner %d effic %d\n",
			lchr[pp->lnd_type].l_name, pp->lnd_uid, n,
			pp->lnd_own, pp->lnd_effic);
	}
	if (pp->lnd_ship >= 0 && pp->lnd_own && pp->lnd_effic >= LAND_MINEFF) {
		if (!getship(pp->lnd_ship, &theship) ||
		    (theship.shp_effic < SHIP_MINEFF) || 
		    (theship.shp_own != pp->lnd_own)){
			p = fmt("%s #%d sunk!\n", lchr[pp->lnd_type].l_name,
				n);
			if ((pp->lnd_own == cnum) || god)
				pr(p);
			/* yes, sunk */
			if (pp->lnd_own && (pp->lnd_own != cnum))
				wu(0, pp->lnd_own, p);
			pp->lnd_own = 0;
			(void) ef_nbwrite(EF_LAND, n, ptr);
		} else {
			/* wooof!  Carriers are a pain */
			if (pp->lnd_mission){
				/*
				 *  If the unit is on a mission centered
				 *  on it's loc, the op-area travels with
				 *  the unit.
				 */
				if ((pp->lnd_opx == pp->lnd_x) &&
					(pp->lnd_opy == pp->lnd_y)){
					pp->lnd_opx = theship.shp_x;
					pp->lnd_opy = theship.shp_y;
				}
			}
			pp->lnd_x = theship.shp_x;
			pp->lnd_y = theship.shp_y;
		}
	}
	owner = (god || pp->lnd_own == cnum);
	return 1;
}

/*ARGSUSED*/
int
lnd_prewrite(n, ptr)
	int	n;
	s_char	*ptr;
{
	struct	lndstr *lp = (struct lndstr *) ptr;

	if (lp->lnd_effic < LAND_MINEFF){
		lp->lnd_own = 0;
	}

	return 1;
}
