static char *RCSid = "$Header: empmod.c,v 1.1 89/12/14 13:26:37 jay Exp $";

/*
 * empmod.c
 *
 * Command/function mapping for empire.  Named empmod for historical
 * reasons -- empire used to be broken into seven modules
 * on the venerable pdp 11 so it could fit in 64k I/D space.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "com.h"
#include "nat.h"
#include "tm.h"
#include "file.h"

extern	int  add();
extern	int assa();
extern	int atta();
extern	int boar();
extern	int bomb();
extern	int buil();
extern	int chan();
extern	int coas();
extern	int coll();
extern	int comm();
extern	int cons();
extern	int coun();
extern	int decl();
extern	int deli();
extern	int show();
extern	int desi();
extern	int diss();
extern	int drop();
extern	int enli();
extern	int fire();
extern	int flee();
extern	int  fly();
extern	int force();
extern	int info();
extern	int ledg();
extern	int load();
extern	int look();
extern	int  map();
extern	int mine();
extern  int move();
extern	int nati();
extern	int navi();
extern  int head(), news();
extern	int nuke();
extern	int offe();
extern	int offs();
extern	int para();
extern	int path();
#ifdef TRADESHIPS
extern	int payo();
#endif /* TRADESHIPS */
extern	int powe();
extern	int rada();
extern	int  rea();
extern	int real();
extern	int reco();
extern	int repa();
extern	int rout();
extern	int sona();

extern	int  spy();
extern	int tele();
extern	int tend();
extern	int torp();
extern	int trad();
extern  int tran();
extern	int trea();
extern	int turn();
extern	int vers();
/*
 * new commands
 */
extern	int buy();
extern	int mult();
extern	int repo();
extern	int fina();
extern	int laun();
extern	int new();
extern	int shoo();
extern	int thre();
extern	int dist();
extern	int sct();
extern	int plan();
extern	int arm();
extern	int hard();
extern	int upgr();
extern	int surv();
extern	int capi();
extern	int orig();
extern	int mark();
extern	int conv();
extern  int leve();
extern	int cuto();
extern	int prod();
extern	int  wai();
extern	int carg();
extern	int terr();
extern	int sate();
extern	int give();
extern	int edit();
extern	int wipe();
extern	int dump();
extern	int expl();
extern	int reso();
extern	int scra();
extern	int rela();
extern	int brea();
extern	int upda();
extern	int hidd();
#if	defined(BMAP) || defined(AUTONAV)
extern	int bdes();
extern	int bmap();
#endif
#ifdef	AUTONAV
extern	int orde();
extern	int qorde();
#endif	AUTONAV
#ifdef	REJECTS
extern	int reje();
extern	int acce();
#endif	REJECTS
#ifdef	SCUTTLE
extern	int scut();
#endif	SCUTTLE
#ifdef	GRIND
extern	int grin();
#endif	GRIND
#ifdef	SAIL
extern	int sail();	/* Forsman's hacks */
extern	int foll();	/**/
extern	int mobq();	/**/
#endif	SAIL
#ifdef	SHIPNAMES
extern	int name();
#endif	SHIPNAMES
#ifdef	RANGEEDIT
extern	int range();
#endif	RANGEEDIT
#ifdef	DEMANDUPDATE
extern	int zdon();
#endif	/* DEMANDUPDATE */
#ifdef	FUEL
extern	int fuel();
#endif	/* FUEL */
extern	int multifire();
#ifdef	RETREAT
extern	int retr();
#endif	/* RETREAT */
extern	int budg();
#ifdef	WIRE
extern	int wire();
#endif	/* WIRE */
#ifdef STOP
extern	int stop();
extern	int start();
#endif /* STOP */

extern	int land();
extern	int supp();
extern	int lcarg();
extern	int lload();
extern	int army();
extern	int lrange();
extern	int morale();
extern	int lretr();
extern	int landmine();
extern	int fort();
extern	int march();
extern	int llook();
extern	int mission();
extern	int lrada();
extern	int work();
extern	int ltend();
extern	int cede();
extern	int best();
extern	int newe();
extern	int starve();

extern	int setres();
extern	int setsector();
extern	int mail();

extern	int disa();
extern	int enab();

/*
 * Undeclared functions
 */
extern	int quit();
extern	int cens();
extern	int demo();
extern	int sell();
extern	int shi();
extern	int wing();
extern	int execute();
extern	int explain();
extern	int  set();

#define	SCT	bit(EF_SECTOR)
#define SHP	bit(EF_SHIP)
#define PLN	bit(EF_PLANE)
#define LND	bit(EF_LAND)

struct  comstr  coms[]  = {
/* command form                       cost lck    addr  permit */
#ifdef	REJECTS
"accept  [as-COUNTRY]",			0, 0,	 acce,	NORM,
#endif	REJECTS
"add <NAT> <NAME> <REP> <STATUS> <c|w|i>",0,SCT, add,	GOD,
"announce {message}",                   0, 0,    tele,  NORM,
"arm <PLANE> <NUKETYPE> <NUMBER>",      3, SCT,   arm,  NORM+MONEY+CAP,
"army <ARMY> <UNITS>",                  0, LND,  army,  NORM,
"assault <to-SECT> <from-SHIP> <NUMBER> [<forts?> <ships?> <arty?> <planes?>]",3,SCT|SHP,assa,NORM+MONEY+CAP,
"attack <SECT> [<forts?> <ships?> <arty?> <planes?>]",3, SCT,  atta,  NORM+MONEY+CAP,
#if	defined(BMAP) || defined(AUTONAV)
"bdes <SECTS> <type>",                  0, 0,    bdes,  SANCT,
"bestpath <SECTS> <SECTS>",             0, 0,    best,  SANCT,
"bestdistpath <SECTS> <SECTS>",         0, 0,    best,  SANCT,
"bmap <SECTS>",                         0, 0,    bmap,  SANCT,
#endif
"board <to-SHIP> <from-SHIP>",          3, SHP,  boar,  NORM+MONEY+CAP,
"bomb <bomber-PLANES> <fighter-PLANES> <pin|strat|nuke> <ap-SECT> <PATH|DESTINATION>",2,SCT|SHP,bomb,NORM+MONEY+CAP,
"break {sanctuary}",                    1, 0,    brea,  SANCT,
"budget [<sector type|P|S|L|A|M|N|C> <PRIORITY|~>]",1,0,budg,NORM,
"build <s|n|b|p> <SECTS> <type|dir> <tech>",1,SHP|SCT,buil,NORM+MONEY+CAP,
"buy <COMM> [<NAT> <NUM> <SECT>]",      1,SCT,    buy,  GOD,
"bye {log-off}",                        0, 0,    quit,  VIS,
"capitol <SECT>",                       0, 0,    capi,  NORM,
"cargo <SHIPS>",                        0, 0,    carg,  NORM,
"cede <SECTS|SHIPS> <COUNTRY>",         1,SCT|SHP, cede,  NORM+MONEY+CAP,
"census <SECTS>",                       0, 0,    cens,  SANCT,
"change <country|representative> <NAME>",0,0,    chan,  SANCT,
"coastwatch <SECTS>",                   1, 0,    coas,  NORM+CAP,
"collect <LOAN> <SECT>",                2, 0,    coll,  GOD,
"commodity <SECTS>",                    0, 0,    comm,  SANCT,
"consider <loan|treaty> <LOAN/TREATY> <acc|decl|post>",1,0,cons,GOD,
"convert <SECTS> <NUM>",                2, 0,    conv,  NORM+MONEY+CAP,
"country <NATS>",                       0, 0,    coun,  NORM,
"cutoff <SECTS>",                       0, 0,    cuto,  NORM,
"declare <all|neut|hos|war> <NAT>",     2, 0,    decl,  NORM+CAP,
"deliver <COMM> <SECTS> <DIR> <[+|-]thresh>",1,SCT,deli,NORM,
"demobilize <SECTS> <NUM> <active-reserve?>",1,SCT,demo,NORM+MONEY+CAP,
"designate <SECTS> <type>",             1, SCT,  desi,  NORM,
"disable",                              0, 0,    disa,  GOD,
"dissolve <really dissove?>",           0, SCT|SHP,diss,GOD,
"distribute <SECTS> <DISTSECT|.|h>",	1, SCT,  dist,  NORM,
"drop <cargo-PLANES> <fighter-PLANES> <ap-SECT> <PATH|DESTINATION> <COMM>",1,SCT,drop,NORM+MONEY+CAP,
"dump <SECTS>",	                        0, 0,    dump,  SANCT,
"edit <country|unit|ship|plane|nuke>",	0, 0,	 edit,  GOD,
"enable",                               0, 0,    enab,  GOD,
"enlist <SECTS> <NUM>",                 2, SCT,  enli,  NORM+MONEY+CAP,
"execute <INPUT FILE>",                 0, 0,   execute,SANCT,
"explore <c|m> <SECT> <NUM> <PATH|DESTINATION>",    1, SCT,  expl,  NORM+MONEY+CAP,
"financial",                            0, 0,    fina,  GOD,
"fire <land, ship or sect> <from-SECTS | SHIPS | UNITS> [TO-SECT | SHIP]",1,SCT|SHP,multifire,NORM+MONEY+CAP,
"fleetadd <FLEET> <SHIPS>",             0, SHP,  flee,  NORM,
"fly <cargo-PLANES> <fighter-PLANES> <ap-SECT> <PATH|DESTINATION> <COM>",2,SCT|SHP,fly,NORM+MONEY+CAP,
#ifdef	SAIL
"follow <leader> <SHIPS>",		1, SHP,  foll,  NORM+MONEY+CAP,
#endif	SAIL
"force <delay time> <# ETU> <notify>",  0, 0,    force, GOD,
"fort <UNITS> <MOB>",                   1, LND,  fort,  NORM,
#ifdef FUEL
"fuel <SHIPS|UNITS> <AMOUNT> [TENDER]",	1, SHP|SCT|LND,fuel,NORM,
#endif /* FUEL */
"give <COMM> <SECT> <NUM>",	        0, 0,	 give,  GOD,
#ifdef	GRIND
"grind <SECT> <NUM>",			1, 0,	 grin,	NORM+MONEY+CAP,
#endif	GRIND
"harden <PLANES> <NUM>",                2, SCT,  hard,  NORM+MONEY+CAP,
"headlines [days]",                     0, 0,    head,  VIS,
"hidden <SECTS>",	                0, 0,    hidd,  GOD,
"info <topic>",                         0, 0,    info,  VIS,
"land <UNITS>",				0, 0,    land,  NORM,
"launch <PLANES>",                      3, SCT|SHP,laun,NORM+MONEY+CAP,
"lcargo <UNITS>",                       0, 0,    lcarg, NORM,
"ledger <LOANS>",                       0, 0,    ledg,  GOD,
"level <SECTS>",                        0, 0,    leve,  NORM,
"list of commands",                     0, 0,    explain,VIS,
#ifdef XLIGHT
"lload <UNIT> <NUM|PLANE> <COMM|\"plane\">",1, LND|SCT,lload,NORM+MONEY+CAP,
#else
"lload <UNIT> <NUM> <COMM>",            1, LND|SCT,lload,NORM+MONEY+CAP,
#endif /* XLIGHT */
"llookout <UNITS>",                     1, 0,   llook,  NORM+MONEY+CAP,
"lmap <SECTS|UNIT>",                    0, 0,     map,  SANCT,
"lmine <UNITS>",                        2, SCT|LND,landmine,NORM+MONEY+CAP,
"load <SHIPS> <NUM|UNIT|PLANE> <COMM|\"unit\"|\"plane\">",1, SHP|SCT,load,NORM+MONEY+CAP,
"lookout <SHIPS>",                      1, 0,    look,  NORM+MONEY+CAP,
"lradar <UNITS | SECTS>",               1, 0,   lrada,  NORM+MONEY+CAP,
"lrange <UNITS> <range>",		1, 0,  lrange,  NORM+MONEY+CAP,
"lretreat <UNITS|ARMY> <PATH> [i|h|b|c]", 1, LND, lretr, NORM+MONEY+CAP,
"ltend <tender-SHIPS> <COMM> <NUM> <UNITS>",1,SHP|LND,ltend,NORM+MONEY+CAP,
#ifdef XLIGHT
"lunload <UNITS> <NUM|PLANE> <COMM|\"plane\">",1, LND|SCT,lload,NORM+MONEY+CAP,
#else
"lunload <UNITS> <NUM> <COMM>",         1, LND|SCT,lload,NORM+MONEY+CAP,
#endif /* XLIGHT */
"mail",					0, 0,    mail,  VIS,
"market [COMM]",                        0, 0,    mark,  GOD,
"map <SECTS|SHIP>",                     0, 0,    map,   SANCT,
"march <UNITS> <PATH|DESTINATION>",     1, LND,  march,  NORM+MONEY+CAP,
"mine <SHIPS>",                         2, SCT|SHP,mine,NORM+MONEY+CAP,
"miss <type> <PLANES|SHIPS|UNITS> <mission type> <op sect> [<radius>]", 2, SCT|SHP|LND|PLN,mission,NORM+MONEY+CAP,
"morale <UNITS> <retreat%>",		1, 0,  morale,  NORM+MONEY+CAP,
"move <c|m|s|g|p|i|o|b|f|r|u> <SECT> <NUM> <PATH|DESTINATION>",1,SCT,move,NORM+CAP,
#ifdef	SAIL
"mquota <SHIPS> <value>",		2, SHP,  mobq,  NORM+MONEY+CAP,
#endif	SAIL
"mult [COUNTRY]",                       1, 0,    mult,  NORM,
#ifdef	SHIPNAMES
"name <SHIPS> <NAME>",			0, SHP,	 name,	NORM,
#endif	SHIPNAMES
"nation",                               0, 0,    nati,  SANCT,
"navigate <SHIPS> <PATH|DESTINATION>",  1, SHP,  navi,  NORM+MONEY+CAP,
"newcap <NAT>",                         0, SCT,   new,  GOD,
"neweff <SECTS>",                       0, SCT,  newe,  NORM,
"newspaper [days]",                     0, 0,    news,  VIS,
"nuke <NUKES>",                         0, 0,    nuke,  NORM,
"offer <loan|treaty> <NAT> [<NUM> <DAYS> <IRATE>]",1,0,offe,GOD,
"offset <SECT|NAT>",                    0, 0,    offs,  GOD,
#ifdef	AUTONAV
"order <SHIPS> [<c|s|r|d|SECT> [<COMM> [<SECT> [<COMM>]]]]",1,SHP,orde,NORM+MONEY+CAP,
#endif	AUTONAV
"origin <SECT>",                        1, 0,    orig,  NORM,
"paradrop <cargo-PLANES> <fighter-PLANES> <ap-SECT> <PATH|DESTINATION>",3,SCT,para,NORM+MONEY+CAP,
"path <SECT>",                          0, 0,    path,  NORM,
#ifdef TRADESHIPS
"payoff <SHIPS>",                       0, 0,    payo,  NORM,
#endif /* TRADESHIPS */
"plane <SECTS>",                        0, 0,    plan,  NORM,
"pmap <SECTS|UNIT>",                    0, 0,    map,   SANCT,
"power [\"new\"]",                      0, 0,    powe,  VIS,
"production <SECTS>",                   0, 0,    prod,  NORM,
#ifdef	AUTONAV
"qorder <SHIPS>",			0, 0,   qorde,	NORM+MONEY+CAP,
#endif	AUTONAV
#ifdef	SAIL
"qsail <SHIPS>",			0, 0,    sail,  NORM+MONEY+CAP,
#endif	SAIL
"quit",                                 0, 0,    quit,  VIS,
"radar <SHIPS | SECTS>",                1, 0,    rada,  NORM+MONEY+CAP,
#ifdef	RANGEEDIT
"range <PLANES> <range>",		1, 0,   range,  NORM+MONEY+CAP,
#endif	RANGEEDIT
"read",                                 0, 0,    rea,   VIS,
"realm <number> [<SECTS>]",             0, 0,    real,  SANCT,
"recon <spy-PLANES> <fighter-PLANES> <ap-SECT> <PATH|DESTINATION>",3,0,reco,NORM+MONEY+CAP,
#ifdef RETREAT
"retreat <SHIPS|FLEET> <PATH> [i|t|s|h|b|d|c]", 1, SHP, retr, NORM+MONEY+CAP,
#endif /* RETREAT */
"relations  [as-COUNTRY]",		0, 0,	 rela,	SANCT,
#ifdef	REJECTS
"reject <reject|accept> <announcements|mail|treaties|loans> <NAT>",2,0,reje,NORM,
#endif	REJECTS
"repay <LOAN> <NUM>",                   1, 0,    repa,  GOD,
"report <NATS>",                        0, 0,    repo,  VIS,
"resource <SECTS>",                     0, 0,    reso,  SANCT,
"route <COMM> <SECTS>",                 1, 0,    rout,  NORM,
#ifdef	SAIL
"sail <SHIPS> <PATH>",			1,SHP,	 sail,  NORM+MONEY+CAP,
#endif	SAIL
"satellite <SECTS>",                    1, 0,    sate,  NORM+MONEY+CAP,
"scrap <TYPE> <SHIPS|PLANES>",          2,SHP,   scra,  NORM+MONEY+CAP,
#ifdef	SCUTTLE
"scuttle <TYPE> <SHIPS|PLANES>",	5,SHP|PLN,scut,	NORM+CAP,
#endif	SCUTTLE
"sect <SECTS>",                         0, 0,    sct,   NORM,
"sell <COMM> <SECTS> <NUM> <NUM>",      1, SCT,  sell,  GOD,
"set <TYPE> <LIST> <PRICE>",            1,SHP,   set,   GOD,
"setsector <TYPE> <SECTS> <amt>",	0, SCT,  setsector,    GOD,
"setresource <TYPE> <SECTS> <AMT>",	0, SCT,  setres, GOD,
"ship <SHIPS>",                         0, 0,    shi,   NORM,
"shoot <SECTS> <CIVS|UWS> <NUMBER>",    3, SCT,  shoo,  NORM+MONEY+CAP,
"show <TYPE> <\"build\"|\"stats\"|\"cap\">",	0, 0,	 show,	VIS,
"smap <SECTS|UNIT>",                    0, 0,    map,   SANCT,
"sonar <SHIPS>",		        1, 0,    sona,  NORM+MONEY+CAP,
"spy <SECTS>",				1, SCT,  spy,   NORM+MONEY+CAP,
"start <SECTS>", 			1, SCT,  start,	NORM+CAP,
"starvation <SECTS>",                   0, 0,    starve,  SANCT,
"stop <SECTS>", 			1, SCT,  stop,	NORM+CAP,
"supply <LAND UNITS>",                  1, LND|SHP|SCT,  supp,  NORM+MONEY+CAP,
"survey <COMM|VAR> <SECTS>",            0, 0,    surv,  NORM+CAP,
"sweep <sweep-PLANES> <fighter-PLANES> <ap-SECT> <PATH|DESTINATION>",3,0,reco,NORM+MONEY+CAP,
"telegram <NAT>",                       0, 0,    tele,  NORM,
"tend <tender-SHIPS> <COMM> <NUM> <dest-SHIPS>",1,SHP,tend,NORM+MONEY+CAP,
"territory <SECTS> <NUMBER>",		0, SCT,  terr,  NORM,
"test <c|m|s|g|p|i|o|b|f|r|u> <SECT> <NUM> <PATH|DESTINATION>",1,SCT,move,NORM+CAP,
"threshold <COMM> <SECTS> <THRESH>",    1, SCT,  thre,  NORM,
"torpedo <submarine-SHIP> <target-SHIP>",3,SHP,  torp,  NORM+MONEY+CAP,
"trade",                                1, SHP,  trad,  GOD,
"transport <\"nuke\"|\"plane\"> <NUKES|PLANES> [nuketype] <PATH|DESTINATION>",1,SCT|SHP,tran,NORM+MONEY+CAP,
"treaty <TREATIES>",                    0, 0,    trea,  NORM+MONEY+CAP,
"turn <\"on\"|\"off\"|\"mess\">",          0, 0,    turn,  GOD,
"unit <UNITS>",                         0, 0,    land,  NORM,
"unload <SHIPS> <NUM|UNIT|PLANE> <COMM|\"unit\"|\"plane\">",1, SHP|SCT,load,NORM+MONEY+CAP,
#ifdef	SAIL
"unsail <SHIPS>",			1, SHP,  sail,  NORM+MONEY+CAP,
#endif	SAIL
"update",                               0, 0,    upda,  VIS,
"upgrade <SHIPS>",                      1, SHP,  upgr,  NORM+MONEY+CAP,
"version",                              0, 0,    vers,  VIS,
"wait",                                 0, 0,     wai,  SANCT,
"wingadd <WING> <PLANES>",              1, PLN,  wing,  NORM,
"wipe <SECTS>",				1, SCT,  wipe,  NORM,
#ifdef WIRE
"wire <yes|no>",                        0, 0,    rea,   VIS,
"wmail",				0, 0,    mail,  VIS,
#endif
"work <LAND UNITS> <AMOUNT>",		1, LND|SCT, work, NORM+MONEY+CAP,
#ifdef	DEMANDUPDATE
"zdone <y|n|c>",			0, 0,    zdon,	GOD,
#endif	DEMANDUPDATE
0,					0, 0,       0,  0,
};
