/*
 * land.h
 *
 * things having to do with land units
 *
 */

#include "queue.h"

/* Types of combat for use by casualty routines */
#define	ATTACKING	1
#define	ASSAULTING	2
#define	PARATROOPING	3

#ifdef RETREAT
#ifndef RET_LEN
#define RET_LEN 10
#endif /* RET_LEN */
#endif /* RETREAT */

#define LAND_MINEFF	10
#define MAXLNDV		12

struct	lndstr {
	coord	lnd_x;		/* x location in abs coords */
	coord	lnd_y;		/* y location in abs coords */
	natid	lnd_own;	/* owner's country num */
	s_char	lnd_type;	/* ship type */
	s_char	lnd_effic;	/* 0% to 100% */
	s_char	lnd_mobil;	/* mobility units made int for RS/6000 */
	short	lnd_sell;	/* pointer to trade file */
	short	lnd_tech;	/* tech level ship was built at */
	short	lnd_uid;	/* unit id (land unit) */
	s_char	lnd_army;	/* group membership */
	coord	lnd_opx,lnd_opy;/* Op sector coords */
	short	lnd_mission;	/* mission code */
	short	lnd_radius;	/* mission radius */
	s_char	lnd_spare;	/* extra space */
	short	lnd_ship;	/* pointer to transporting ship */
        s_char	lnd_harden;	/* for missiles */
        short	lnd_retreat;	/* retreat percentage */
#ifdef FUEL
	u_char	lnd_fuel;	/* How much fuel do we have */
#endif /* FUEL */
#ifdef XLIGHT
	u_char	lnd_nxlight;	/* How many xlight planes on board? */
#endif /* XLIGHT */
#ifdef RETREAT
	int	lnd_rflags;	/* When do I retreat? */
	s_char	lnd_rpath[RET_LEN];	/* retreat path */
#endif /* RETREAT */
#ifdef  RANGEEDIT
	u_char	lnd_rad_max;	/* max radius for this unit */
#endif  RANGEEDIT
	s_char    lnd_nv;		/* current number of variables */
	u_char	lnd_vtype[MAXLNDV];
	u_short	lnd_vamt[MAXLNDV];
};

#define	MAXLCHV 12

struct	lchrstr {
	s_char	*l_name;	/* full name of type of land unit */
	int	l_lcm;		/* units of lcm to build */
	int	l_hcm;		/* units of hcm to build */
	int	l_mil;		/* how many mil it takes to build */
	int	l_gun;		/* how many guns it takes to build */
	int	l_shell;	/* how many shells it takes to build */
	int	l_tech;		/* tech required to build */
	int	l_cost;		/* how much it costs to build */
	float	l_att;		/* attack multiplier */
	float	l_def;		/* defense multiplier */
	int	l_vul;		/* vulnerability (0-100) */
	int	l_spd;		/* speed */
	int	l_vis;		/* visibility */
	int	l_spy;		/* Seeing distance */
	int	l_rad;		/* reaction radius */
	int	l_frg;		/* firing range */
	int	l_acc;		/* firing accuracy */
	int	l_dam;		/* firing damage */
	int	l_ammo;		/* firing ammu used per shot */
	int	l_aaf;		/* aa fire */
#ifdef FUEL
	u_char	l_fuelc;	/* fuel capacity */
	u_char	l_fuelu;	/* fuel used per 10 mob */
#endif /* FUEL */
#ifdef XLIGHT
	u_char	l_nxlight;	/* maximum number of xlight planes */
#endif /* XLIGHT */
	long	l_flags;	/* what special things can this unit do */
	u_char	l_nv;		/* number of variables it can hold */
	u_char	l_vtype[MAXLCHV];
	u_short	l_vamt[MAXLCHV];
};

/* Land unit ability flags */
#define	L_XLIGHT	bit(0)	/* Hold xlight planes */
#define	L_ENGINEER	bit(1)	/* Do engineering things */
#define	L_SUPPLY	bit(2)	/* supply other units/sects */
#define	L_SECURITY	bit(3)	/* anti-terrorist troops */
#define	L_LIGHT		bit(4)	/* can go on ships */
#define	L_MARINE	bit(5)	/* marine units, good at assaulting */
#define	L_RECON		bit(6)	/* recon units, good at spying */
#define L_RADAR		bit(7)	/* radar unit */
#define L_ASSAULT	bit(8)	/* can assault */
#define L_FLAK		bit(9)	/* flak unit */

#define getland(n, p) \
	ef_nbread(EF_LAND, n, (caddr_t)p)
#define putland(n, p) \
	ef_nbwrite(EF_LAND, n, (caddr_t)p)
#define getlandp(n) \
	(struct lndstr *) ef_ptr(EF_LAND, n)

extern  struct lchrstr lchr[];
extern	int lnd_maxno;

struct llist {
	struct qelem queue;	/* list of units */
	int state;		/* state of units */
	int x,y;		/* x,y it came from */
	struct lchrstr *lcp;	/* pointer to desc of land unit */
	struct lndstr land;	/* struct land unit */
};

#define	LL_DEAD		0
#define	LL_RETREATED	1
#define	LL_UNSUPPLIED	2
#define	LL_OK		3
