#ifndef lint
static char *RCSid = "$Header: lndsub.c,v 1.1 89/12/14 08:19:14 jay Exp $";
#endif /* not lint */

/*
 * lndsub.c
 *
 * land unit subroutines
 *
 */

#include <math.h>
#include "misc.h"
#include "file.h"
#include "var.h"
#include "sect.h"
#include "path.h"
#include "news.h"
#include "treaty.h"
#include "nat.h"
#include "xy.h"
#include "land.h"
#include "nsc.h"

attack_val(lp)
struct	lndstr *lp;
{
	int	men;
	int	value;
	struct	lchrstr *lcp;

	if (((int)lp->lnd_effic) < LAND_MINEFF){
		lp->lnd_own=0;
		putland(lp->lnd_uid,lp);
		return 0;
	}

	lcp = &lchr[lp->lnd_type];

	men = total_mil(lp);

	value = ldround(((double)men*(double)lcp->l_att),1);

	return value;
}

defense_val(lp)
struct	lndstr *lp;
{
	int	men;
	int	value;
	struct	lchrstr *lcp;

	if (((int)lp->lnd_effic) < LAND_MINEFF){
		lp->lnd_own=0;
		putland(lp->lnd_uid,lp);
		return 0;
	}

	lcp = &lchr[lp->lnd_type];

	men = total_mil(lp);

	value = ldround(((double)men*(double)lcp->l_def),1);

	return value;
}

total_mil(lp)
struct lndstr *lp;
{
	struct	lchrstr *lcp;
	double	men;

	lcp = &lchr[lp->lnd_type];

	men = lcp->l_mil;
	men *= ((double)lp->lnd_effic)/100.0;

	return ldround(men,1);
}

take_casualty(llp, cas, state, taken, combat_mode, own)
struct	llist *llp;
int	cas;		/* number of casualties to take */
int	*taken;		/* number of casualties actually taken */
int	state;		/* state we're in now */
int	combat_mode;	/* attacking or assaulting or paratrooping? */
natid	own;		/* owner of unit */
{
	int	eff_eq, ret_x, ret_y, n, bx, by, biggest, civs, nowned;
	struct	natstr *np;
	struct	sctstr sect;
	double	sqrt(), ret_chance;

	eff_eq = ldround((((double)cas*100.0) /
		(double)lchr[llp->land.lnd_type].l_mil),1);

	llp->land.lnd_effic -= eff_eq;

	if (llp->land.lnd_effic < LAND_MINEFF){
		if (own != cnum){
			if (own)
				wu(0,own,fmt("%s #%d dies defending %s!\n",
					lchr[llp->land.lnd_type].l_name, 
					llp->land.lnd_uid,
					xyas(llp->land.lnd_x,llp->land.lnd_y,
					own)));
		}else{
			pr(fmt("\n\t%s #%d dies attacking %s!\n",
				lchr[llp->land.lnd_type].l_name, 
				llp->land.lnd_uid,
				xyas(llp->land.lnd_x,llp->land.lnd_y,
				own)));
		}
		llp->land.lnd_own = 0;
		*taken = (((double)llp->land.lnd_effic/100.0)*
			(double)lchr[llp->land.lnd_type].l_mil);
	}else
		*taken = cas;

	putland(llp->land.lnd_uid,&llp->land);

	if (llp->land.lnd_effic < LAND_MINEFF)
		return LL_DEAD;

	if (llp->land.lnd_effic > llp->land.lnd_retreat)
		return state; /* no change */

	/* Have to make a retreat check */

	ret_chance=sqrt((double)(100-llp->land.lnd_effic))/100.0;
	if (chance(ret_chance)){
		llp->land.lnd_mission = 0;
		llp->land.lnd_harden = 0;
		if ((combat_mode) && (combat_mode != ATTACKING)){
			/* nowhere to go.. take more casualties */
			llp->land.lnd_effic -= 10;
			if (llp->land.lnd_effic < LAND_MINEFF){
				if (own == cnum)
					pr(fmt("\n\t%s %d has nowhere to retreat, and dies!\n",
						llp->lcp->l_name,
						llp->land.lnd_uid));
				else
					wu(0,own, fmt("\t%s %d has nowhere to retreat, and dies!\n",
						llp->lcp->l_name,
						llp->land.lnd_uid));
				
				llp->land.lnd_own = 0;
			}else{
				if (own == cnum)
					pr(fmt("\n\t%s %d has nowhere to retreat, and takes extra losses!\n",
						llp->lcp->l_name,
						llp->land.lnd_uid));
				else
					wu(0,own,fmt("\t%s %d has nowhere to retreat, and takes extra losses!\n",
						llp->lcp->l_name,
						llp->land.lnd_uid));
			}
			putland(llp->land.lnd_uid,&llp->land);
			return state; /* keep fighting */
		}

		if (own == cnum)
			pr(fmt("\n\t%s %d fails morale check!\n",
				llp->lcp->l_name,
				llp->land.lnd_uid));
		else
			wu(0,own,fmt("\t%s %d fails morale check!\n",
				llp->lcp->l_name,
				llp->land.lnd_uid));

		if (combat_mode){
			struct sctstr back;
			/* attacking unit.. send it back where it came from */
			getsect(llp->x,llp->y,&back);
			if (back.sct_own != llp->land.lnd_own){
				/* while we were attacking, someone captured */
				/* the sector we came from.. in this case,   */
				/* take extra damage and keep fighting...    */

				if (own == cnum)
					pr(fmt("\n\t%s %d can't retreat back to start sector!\n",
						llp->lcp->l_name,
						llp->land.lnd_uid));
				else
					wu(0,own,fmt("\t%s %d can't retreat back to start sector!\n",
						llp->lcp->l_name,
						llp->land.lnd_uid));
				/* nowhere to go.. take more casualties */
				llp->land.lnd_effic -= 10;
				if (llp->land.lnd_effic < LAND_MINEFF){
					if (own == cnum)
						pr(fmt("\n\t%s %d has nowhere to retreat, and dies!\n",
							llp->lcp->l_name,
							llp->land.lnd_uid));
					else
						wu(0,own, fmt("\t%s %d has nowhere to retreat, and dies!\n",
							llp->lcp->l_name,
							llp->land.lnd_uid));
					
					llp->land.lnd_own = 0;
				}else{
					if (own == cnum)
						pr(fmt("\n\t%s %d has nowhere to retreat, and takes extra losses!\n",
							llp->lcp->l_name,
							llp->land.lnd_uid));
					else
						wu(0,own,fmt("\t%s %d has nowhere to retreat, and takes extra losses!\n",
							llp->lcp->l_name,
							llp->land.lnd_uid));
				}
				putland(llp->land.lnd_uid,&llp->land);
				return state; /* keep fighting */
			}
			llp->land.lnd_x = llp->x;
			llp->land.lnd_y = llp->y;
			putland(llp->land.lnd_uid,&llp->land);
			if (own == cnum)
				pr(fmt("\n\t%s #%d retreats at %d%% efficiency to %s!\n",
					lchr[llp->land.lnd_type].l_name,
					llp->land.lnd_uid, llp->land.lnd_effic,
					xyas(llp->x,llp->y,own)));
			else
				wu(0,own,
				fmt("\t%s #%d retreats at %d%% efficiency to %s!\n",
					lchr[llp->land.lnd_type].l_name,
					llp->land.lnd_uid, llp->land.lnd_effic,
					xyas(llp->x,llp->y,own)));
		}else{
			/*
			 * defending unit.. find a place to send it
			 * strategy: look for the most-populated 
			 * adjacent sector that is owned by the unit
			 * owner. Charge mob..
			 */
			nowned=0;
			biggest=0;
			for(n=1;n<=6;n++){
				ret_x = llp->land.lnd_x + diroff[n][0];
				ret_y = llp->land.lnd_y + diroff[n][1];
				getsect(ret_x,ret_y,&sect);

				if (sect.sct_own != own)
					continue;
				if (sect.sct_type == SCT_MOUNT)
					continue;
				nowned++;
				civs=getvar(V_CIVIL, (s_char *)&sect, EF_SECTOR);
				if (civs >= biggest){
					biggest = civs;
					bx = sect.sct_x;
					by = sect.sct_y;
				}
			}

			if (nowned == 0){
				/* nowhere to go.. take more casualties */
				llp->land.lnd_effic -= 10;
				if (llp->land.lnd_effic < LAND_MINEFF){
					if (own == cnum)
						pr(fmt("\t%s %d has nowhere to retreat, and dies!\n",
							llp->lcp->l_name,
							llp->land.lnd_uid));
					else
						wu(0,own,fmt("\t%s %d has nowhere to retreat, and dies!\n",
							llp->lcp->l_name,
							llp->land.lnd_uid));
					
					llp->land.lnd_own = 0;
					putland(llp->land.lnd_uid,&llp->land);
					return LL_DEAD;
				}else{
					if (own == cnum)
						pr(fmt("\t%s %d has nowhere to retreat, and takes extra losses!\n",
							llp->lcp->l_name,
							llp->land.lnd_uid));
					else
						wu(0,own,fmt("\t%s %d has nowhere to retreat, and takes extra losses!\n",
							llp->lcp->l_name,
							llp->land.lnd_uid));
					putland(llp->land.lnd_uid,&llp->land);
					return LL_OK;
				}
			}else{
				struct sctstr rsect;
				double	mc=0.0, d=0.0;
				int	mob;

				/* retreat to bx,by */
				llp->land.lnd_x = bx;
				llp->land.lnd_y = by;
                        	getsect(bx,by,&rsect);
                        	mc = ((double)llp->land.lnd_effic)*0.01*
					(double)lchr[llp->land.lnd_type].l_spd;
				if (mc < 0.01)
					mc = 0.01;
				d = (mc+techfact(llp->land.lnd_tech,mc));
				mc = 480.0 / d;
				d=sector_mcost(rsect.sct_type,rsect.sct_effic);
				mc *= (d * 5.0);
				mob = llp->land.lnd_mobil-(int)mc;
				if (mob < -127)
					mob = -127;
				llp->land.lnd_mobil = (s_char)mob;
				if (own == cnum)
					pr(fmt("\n\t%s #%d retreats at %d%% efficiency to %s!\n",
						lchr[llp->land.lnd_type].l_name,
						llp->land.lnd_uid,
						llp->land.lnd_effic,
						xyas(bx,by,own)));
				else
					wu(0,own,
						fmt("\t%s #%d retreats at %d%% efficiency to %s!\n",
						lchr[llp->land.lnd_type].l_name,
						llp->land.lnd_uid,
						llp->land.lnd_effic,
						xyas(bx,by,own)));
			}
		}
		putland(llp->land.lnd_uid,&llp->land);
		return LL_RETREATED;
	}

	return state; /* no change, we passed the check */
}

spyval(lp)
struct lndstr *lp;
{
	if (lchr[lp->lnd_type].l_flags & L_RECON)
		return (lchr[lp->lnd_type].l_spy * (lp->lnd_effic/100.0))+2;
	else
		return (lchr[lp->lnd_type].l_spy * (lp->lnd_effic/100.0));
}

intelligence_report(destination,lp,spy,mess)
struct	lndstr *lp;
int	spy;
s_char	*mess;
{
	struct	lchrstr *lcp;
	s_char	buf1[80],buf2[80],buf3[80];

	if (destination == 0)
		return;

	if (lp->lnd_own == 0)
		return;

	lcp = &lchr[lp->lnd_type];

	bzero(buf1,80);
	bzero(buf2,80);
	bzero(buf3,80);
	if (chance((double)(spy+lcp->l_vis)/10.0)){
		if (destination == cnum)
			pr(fmt("%s %s #%d", mess, lcp->l_name, lp->lnd_uid));
		else
			sprintf(buf1,"%s %s #%d", mess,lcp->l_name,lp->lnd_uid);

		if (chance((double)(spy+lcp->l_vis)/20.0)){

			if (destination == cnum)
				pr(fmt(" (efficiency %d",lp->lnd_effic));
			else
				sprintf(buf2," (efficiency %d",lp->lnd_effic);

			if (chance((double)(spy+lcp->l_vis)/20.0)){
				int	t;
				t = lp->lnd_tech - 20 + roll(40);
				t = max(t,0);
				if (destination == cnum)
					pr(fmt(", tech %d)\n",t));
				else
					sprintf(buf3,", tech %d)\n",t);
			}else{
				if (destination == cnum)
					pr(fmt(")\n"));
				else
					sprintf(buf3,")\n");
			}
		}else{
			if (destination == cnum)
				pr("\n");
			else
				sprintf(buf2,"\n");
		}	
	}

	if (destination != cnum){
		wu(0,destination,fmt("%s%s%s",buf1,buf2,buf3));
	}
}
