#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/SUBS/RCS/getele.c,v 1.2 89/05/26 02:10:56 mr-frog Exp $";
#endif

/*
 * getele.c
 *
 * read a telegram from a file or stdin and send
 * it to the target country
 *
 * from PSL Empire, 1985
 */

#include <ctype.h>
#include "misc.h"
#include "tel.h"

int
getele(nation, buf)
	s_char *nation;
	s_char *buf;
{
	extern	int aborted;
	register s_char *bp;
	register int len;
	register int c;
	s_char	buffer[MAXTELSIZE+1];
	s_char	*left;

	pr(fmt("Enter telegram for %s; end with ^D or .\n", nation));
	bp = buf;
	while (!aborted) {
		left = fmt("%4d left: ", buf + MAXTELSIZE - bp);
		*buffer = 0;
		if (prmptrd(left, buffer, MAXTELSIZE-2) <= 0)
			break;
		if (buffer[0] == '.' && buffer[1] == 0)
			break;
		len = strlen(buffer);
		buffer[len++] = '\n';
		buffer[len] = 0;
		if (len + (bp - buf) > MAXTELSIZE)
			pr("Too long.  Try that last line again...\n");
		else {
			if (buffer[0] == '>')		/* forgery attempt? */
				buffer[0] = '?';	/* foil it */
			(void) strcpy(bp, buffer);
			bp += len;
		}
	}
	if (aborted)
		return -1;
	len = bp - buf;
	buf[len] = 0;
	/*
	** Get rid of non-ASCII and control characters.
	*/
	for (bp = buf; c = *bp; bp++) {
		if (isascii(c) && (isprint(c) || isspace(c)))
			continue;
		*bp = '?';
	}
	return len;
}
