#ifndef lint
static char *RCSid = "$Header: bmap.c,v 1.1 89/12/14 08:20:08 jay Exp $";
#endif /* not lint */

/*
 * bmap.c
 *
 * empire bigmap: probably the second most-used command in empire.
 *
 * Dave Pare, 1986
 * With hack by Jay Phillips and Bill Frolik, 1989
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "deity.h"
#include "nat.h"
#include "map.h"
#include "ship.h"

#if	defined(BMAP) || defined(AUTONAV)

bmap()
{
	extern	s_char getbigmap();
	extern	int aborted;
	extern	s_char *argp[];
	register s_char *ptr;
	struct	nstr_sect ns;
	struct	natstr *np;
	struct	sctstr sect;
	struct	range range;
	int	i;
	s_char	wmap[WORLD_Y][MAPWIDTH(1)];
	coord	y;
	s_char	what[64];
	s_char	*str;
	struct	shpstr ship;

	if(argp[1] == (s_char *) 0) {
		if ((str = getstring("(sects)? ")) == 0)
			return RET_SYN;
	}
	else {
		str = argp[1];
	}

	if(*str == '*') {
		sprintf(what, "%d:%d,%d:%d",
			-WORLD_X/2, WORLD_X/2-1,
			-WORLD_Y/2, WORLD_Y/2-1);
		if (!snxtsct(&ns, what))
			return RET_FAIL;
	}
	else
        if (!snxtsct(&ns, str)){
                i=atoi(str);
                if (!getship(i, &ship) ||
                        (ship.shp_own != cnum || ship.shp_own == 0))
                        return RET_FAIL;
                sprintf(what, "%d:%d,%d:%d",  ship.shp_x-10, ship.shp_x+10,
                        ship.shp_y-5, ship.shp_y+5);
                if (!snxtsct(&ns, what))
                        return RET_FAIL;
        }
	np = getnatp(cnum);
	/* zap any conditionals */
	ns.ncond = 0;
	xyrelrange(np, &ns.range, &range);
	border(&range, "     ", "");
	blankfill((s_char *)wmap, &ns.range, 1);
	while (bmnxtsct(&ns) && !aborted) {
		ptr = &wmap[ns.dy][ns.dx];
		*ptr = getbigmap(ns.x, ns.y);
	}
	if (aborted)
		return RET_OK;
	for (y=ns.range.ly, i=0; i < ns.range.height; y++, i++) {
		int yval;

		yval = yrel(np, y);
		pr(fmt("%4d %s %-4d\n", yval, wmap[i], yval));
		if (y >= WORLD_Y)
			y -= WORLD_Y;
	}
	border(&range, "     ", "");
	return RET_OK;
}


/*
 * get the next sector in the range
 */
int
bmnxtsct(np)
	register struct nstr_sect *np;
{
	while (1) {
		np->dx++;
		np->x++;
		if (np->x >= WORLD_X)
			np->x = 0;
		if (np->dx >= np->range.width) {
			np->dx = 0;
			np->x = np->range.lx;
			np->dy++;
			if (np->dy >= np->range.height)
				return 0;
			np->y++;
			if (np->y >= WORLD_Y)
				np->y = 0;
		}
		if ((np->y + np->x) & 01)
			continue;
		if (np->type == NS_DIST) {
			np->curdist = mapdist(np->x, np->y, np->cx, np->cy);
			if (np->curdist > np->dist)
				continue;
		}
		np->id = sctoff(np->x, np->y);
		return 1;
	}
	/*NOTREACHED*/
}

#endif
