#ifndef lint
static char *RCSid = "$Header: cens.c,v 1.13 89/08/04 20:10:39 jeffw Exp $";
#endif /* not lint */

/*
 * stop.c
 *
 * stop a sector from producing
 *
 * --ts 1992
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "path.h"
#include "file.h"
#include "product.h"

#ifdef STOP

stop()
{
	extern	s_char *argp[];
	struct	sctstr sect;
	int	nsect;
	int	n;
	struct	nstr_sect nstr;
	int	vec[I_MAX+1];

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	prdate();
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		if (nsect++ == 0)
			stop_hdr();
		if (god)
			pr(fmt("%3d ", sect.sct_own));
		pr(xyfmt("%4d,%-4d", nstr.x, nstr.y, cnum));
		pr(fmt(" %c", dchr[sect.sct_type].d_mnem));
		if (sect.sct_newtype != sect.sct_type)
			pr(fmt("%c", dchr[sect.sct_newtype].d_mnem));
		else
			pr(" ");
		pr(fmt("%4d%%", sect.sct_effic));

		pr(" will not produce or gain efficiency.\n");
		sect.sct_off = 1;
		putsect(&sect);
	}
	if (nsect == 0) {
		if (argp[1])
			pr(fmt("%s: No sector(s)\n", argp[1]));
		else
			pr(fmt("%s: No sector(s)\n", ""));
		return RET_FAIL;
	}else
		pr(fmt("%d sector%s\n", nsect, splur(nsect)));
	return 0;
}

static
stop_hdr()
{
	if (god)
		pr("    ");
	pr("PRODUCTION STOPPAGE\n");
	if (god)
		pr("own ");
	pr("  sect        eff\n");
}
#endif /* STOP */
