#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/real.c,v 1.7 89/09/10 16:26:44 mr-frog Exp $";
#endif

/*
 * real.c
 *
 * show or set realm
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "xy.h"
#include "file.h"
#include "nsc.h"

real()
{
	extern	s_char *argp[];
	register struct boundstr *rp;
	struct	natstr *natp;
	int     curr;
	int     lastr;
	struct	range abs;
	struct	range rel;
	struct	boundstr *b;

	natp = getnatp(cnum);
	if (argp[1] == 0) {
		curr = 0;
		lastr = MAXNOR - 1;
	} else {
		curr = lastr = atoi(argp[1]);
		if (curr < 0 || curr >= MAXNOR) {
			pr(fmt("Realm number must be in the range 0:%d\n",
			       MAXNOR-1));
			return RET_SYN;
		}
	}
	abs.width = 0;		/* keep saber happy */
	abs.height = 0;
	if (argp[2] == 0) {
		while (curr <= lastr) {
			b = &natp->nat_b[curr];
			abs.lx = b->b_xl;
			abs.hx = b->b_xh;
			abs.ly = b->b_yl;
			abs.hy = b->b_yh;
			xyrelrange(natp, &abs, &rel);
			pr(fmt("Realm #%d is %d:%d,%d:%d\n", curr,
				rel.lx, rel.hx, rel.ly, rel.hy));
			curr++;
		}
	} else {
		if (sarg_type(argp[2]) != NS_AREA)
			return RET_SYN;
		if (!sarg_area(argp[2], &abs))
			return RET_SYN;
		rp = &natp->nat_b[curr];
		rp->b_xl = abs.lx;
		rp->b_xh = abs.hx - 1;
		rp->b_yl = abs.ly;
		rp->b_yh = abs.hy - 1;
		NAT_SETARY(nat_b[0], cnum, curr, &natp->nat_b[curr]);
	}
	return RET_OK;
}

dreal()
{
	extern	s_char *argp[];
	register struct boundstr *rp;
	struct	natstr *natp;
	int     curr;
	int     lastr;
	struct	range abs;
	struct	range rel;
	struct	boundstr *b;
	int	nat;

	lastr = MAXNOR - 1;
	curr  = 0;
	if (argp[1] == 0) {
		nat = cnum;
	} else {
		nat = atoi(argp[1]);
		if (nat < 0)
			return RET_SYN;
		if (nat >= MAXNOC)
			return RET_SYN;
	}
	pr(fmt("Realms for %s (#%d)\n",cname(nat),nat));
	natp = getnatp(nat);
	abs.width = 0;		/* keep saber happy */
	abs.height = 0;
	while (curr <= lastr) {
		b = &natp->nat_b[curr];
		abs.lx = b->b_xl;
		abs.hx = b->b_xh;
		abs.ly = b->b_yl;
		abs.hy = b->b_yh;
		xyrelrange(natp, &abs, &rel);
		pr(fmt("Realm #%d is %d:%d,%d:%d\n", curr,
			rel.lx, rel.hx, rel.ly, rel.hy));
		curr++;
	}
	return RET_OK;
}
