#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/rada.c,v 1.8 89/06/27 14:59:16 griffith Exp $";
#endif

/*
 * rada.c
 *
 * do radar from ship or sector
 *
 * from PSL Empire, 1985
 * XXX should give better error messages when radaring from bad ship/sect.
 */

#include <ctype.h>
#include "misc.h"
#include "xy.h"
#include "var.h"
#include "ship.h"
#include "land.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "file.h"

static int from_unit=0;

rada()
{
	extern	s_char *argp[];
	s_char	*cp;
	int	type;
	double	tf;
	double	tech;
	struct	nstr_item ni;
	struct	nstr_sect ns;
	struct	shpstr ship;
	struct	lndstr land;
	struct	sctstr sect;

	if (!from_unit)
		cp = getstarg(argp[1], "Radar from (ship # or sector(s)) : ");
	else
		cp = getstarg(argp[1], "Radar from (unit # or sector(s)) : ");
	if (cp == 0)
		return RET_SYN;
	type = sarg_type(cp);
	if (type == NS_AREA) {
		if (!snxtsct(&ns, cp))
			return RET_SYN;
		tech = tfact(cnum, 8.0);
		if (tech > ((double)WORLD_Y/4.0))
			tech = ((double)WORLD_Y/4.0);
		if (tech > ((double)WORLD_X/8.0))
			tech = ((double)WORLD_X/8.0);
		while (nxtsct(&ns, &sect)) {
			if (sect.sct_type != SCT_RADAR)
				continue;
			if (!owner)
				continue;
			radmap(sect.sct_x, sect.sct_y, (int)sect.sct_effic,
				(int) (tech * 2.0), 0.0);
		}
	} else if (type == NS_LIST || type == NS_GROUP) {
		if (!from_unit){
			/* assumes a NS_LIST return is a shipno */
			if (!snxtitem(&ni, EF_SHIP, cp)) {
				pr("Specify at least one ship\n");
				return RET_SYN;
			}
			while (nxtitem(&ni, (s_char *)&ship)) {
				if (!owner)
					continue;
				if (mchr[ship.shp_type].m_flags & M_SONAR)
					tf = techfact(ship.shp_tech, 1.0);
				else
					tf = 0.0;
#ifdef	SHIPNAMES
				pr(fmt("%s %s(#%d) at ", mchr[ship.shp_type].m_name,
					ship.shp_name,
#else
				pr(fmt("%s #%d at ", mchr[ship.shp_type].m_name,
#endif	SHIPNAMES
			       	ship.shp_uid));
				tech = techfact(ship.shp_tech,
					(double) mchr[ship.shp_type].m_vrnge);
				if (tech > ((double)WORLD_Y/2.0))
					tech = ((double)WORLD_Y/2.0);
				if (tech > ((double)WORLD_X/4.0))
					tech = ((double)WORLD_X/4.0);
				radmap(ship.shp_x, ship.shp_y, ship.shp_effic,
					(int) tech, tf);
			}
		}else{
			/* from a land unit */
			if (!snxtitem(&ni, EF_LAND, cp)) {
				pr("Specify at least one unit\n");
				return RET_SYN;
			}
			while (nxtitem(&ni, (s_char *)&land)) {
				if (!owner)
					continue;
				if (!(lchr[land.lnd_type].l_flags & L_RADAR)){
					pr(fmt("%s #%d can't use radar!\n",
					lchr[land.lnd_type].l_name,
					land.lnd_uid));
					continue;
				}
				if (land.lnd_ship >= 0){
					pr("Units on ships can't use radar!\n");
					continue;
				}
				tf = 0.0;
				pr(fmt("%s #%d at ", lchr[land.lnd_type].l_name,
			       		land.lnd_uid));
				tech = techfact(land.lnd_tech,
					(double) lchr[land.lnd_type].l_spy);
				if (tech > ((double)WORLD_Y/2.0))
					tech = ((double)WORLD_Y/2.0);
				if (tech > ((double)WORLD_X/4.0))
					tech = ((double)WORLD_X/4.0);
				radmap(land.lnd_x, land.lnd_y, land.lnd_effic,
					(int) tech, tf);
			}
		}
	} else {
		if (!from_unit)
			pr("Must use a ship or sector specifier\n");
		else
			pr("Must use a unit or sector specifier\n");
		return RET_SYN;
	}
	return RET_OK;
}

lrada()
{
	from_unit=1;
	rada();
	from_unit=0;
}
