#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/mine.c,v 1.8 89/09/17 21:10:58 mr-frog Exp $";
#endif /* not lint */

/*
 * mine.c
 *
 * lay mines from ships or engineering units
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "ship.h"
#include "land.h"
#include "sect.h"
#include "nat.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"

/*
 * format: mine <SHIPS> <NUMBER MINES>
 */
mine()
{
	extern	s_char *argp[];
	struct	shpstr ship;
	struct	sctstr sect;
	struct	mchrstr *mp;
	struct	nstr_item ni;
	int	mines;
	int	shells;
	int	mines_avail;
	int	mines_there;

	if (!snxtitem(&ni, EF_SHIP, argp[1]))
		return RET_SYN;
	mines = onearg(argp[2], "Drop how many mines from each ship?  ");
	if (mines <= 0)
		return RET_SYN;
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (!owner)
			continue;
		mp = &mchr[ship.shp_type];
		if ((mp->m_flags & M_MINE) == 0)
			continue;
		if ((shells = getvar(V_SHELL, (s_char *)&ship, EF_SHIP)) == 0)
			continue;
		mines_avail = min(shells, mines);
		if (getsect(ship.shp_x, ship.shp_y, &sect) == 0 ||
		    (sect.sct_type != SCT_WATER &&
		    sect.sct_type != SCT_BSPAN)) {
			pr("You can't lay mines there!!\n");
			continue;
		}
		mines_there = getvar(V_MINE, (s_char *)&sect, EF_SECTOR);
		putvar(V_SHELL, shells - mines_avail, (s_char *)&ship, EF_SHIP);
		putvar(V_MINE, mines_avail + mines_there, (s_char *)&sect,
			EF_SECTOR);
		putsect(&sect);
		ship.shp_mission = 0;
		putship(ship.shp_uid, &ship);
#ifdef	SHIPNAMES
		pr(fmt("Laying %d mines from %s #%d\n", mines_avail,
			mp->m_name, ship.shp_uid));
#else
		pr(fmt("Laying %d mines from %s %s(#%d)\n", mines_avail,
			mp->m_name, ship.shp_name, ship.shp_uid));
#endif	SHIPNAMES
	}
	return RET_OK;
}

/*
 * format: landmine <UNITS> <NUMBER MINES>
 */
landmine()
{
	extern	s_char *argp[];
	struct	lndstr land;
	struct	sctstr sect;
	struct	lchrstr *lp;
	struct	nstr_item ni;
	int	mines;
	int	shells;
	int	mines_avail;
	int	mines_there;

	if (!snxtitem(&ni, EF_LAND, argp[1]))
		return RET_SYN;
	mines = onearg(argp[2], "Drop how many mines from each unit?  ");
	if (mines <= 0)
		return RET_SYN;
	while (nxtitem(&ni, (s_char *)&land)) {
		if (!owner)
			continue;
		lp = &lchr[land.lnd_type];
		if ((lp->l_flags & L_ENGINEER) == 0)
			continue;
		resupply_commod(&land,I_SHELL);
		if ((shells = getvar(V_SHELL, (s_char *)&land, EF_LAND)) == 0)
			continue;
		mines_avail = min(shells, mines);
		if (getsect(land.lnd_x, land.lnd_y, &sect) == 0 ||
		    (sect.sct_type == SCT_WATER ||
		    sect.sct_type == SCT_BSPAN)) {
			pr("You can't lay mines there!!\n");
			continue;
		}
		mines_there = getvar(V_MINE, (s_char *)&sect, EF_SECTOR);
		putvar(V_SHELL, shells - mines_avail, (s_char *)&land, EF_LAND);
		putvar(V_MINE, mines_avail + mines_there, (s_char *)&sect,
			EF_SECTOR);
		putsect(&sect);
		land.lnd_mission = 0;
		putland(land.lnd_uid, &land);
		pr(fmt("Laying %d mines from %s #%d\n", mines_avail,
			lp->l_name, land.lnd_uid));
	}
	return RET_OK;
}
