/*
 * foll.c
 *
 * set leader of a set of ships
 *
 * hacked by Robert Forsman <thoth@beach.cis.ufl.edu>
 * by staring at flee.c
 */

#include <ctype.h>
#include "misc.h"
#include "var.h"
#include "ship.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "nat.h"

#ifdef	SAIL

foll()
{
	extern	s_char *argp[];
	struct shpstr ship;
	s_char	*cp,*s;
	s_char	c;
	int	good,leader,count=0;
	coord	x,y;
	struct	nstr_item nstr;

	if (!snxtitem(&nstr, EF_SHIP, argp[1]))
		return RET_SYN;
	cp = getstarg(argp[2],"leader?");
	if (cp==0) cp="";
	good = sscanf(cp,"%d",&leader);
	if  (!good)
	  return RET_SYN;
	getship(leader,&ship);
	if (ship.shp_own!=cnum && getrel(getnatp(ship.shp_own),cnum)!=ALLIED)
	  {
	    pr("That ship won't let you follow.\n");
	    return RET_FAIL;
	  }
	x = ship.shp_x;
	y = ship.shp_y;
	while (nxtitem(&nstr, (s_char *)&ship)) {
		if (!owner)
			continue;
		if ( ship.shp_x!=x || ship.shp_y!=y )
		  {
		    pr(fmt("Ship #%d not in same sector as #%d\n",ship.shp_uid,leader));
		    continue;
		  }
		if (ship.shp_uid==leader)
		  {
		    pr(fmt("Ship #%d can't follow itself!\n",leader));
		    continue;
		  }
		if ((ship.shp_autonav & AN_AUTONAV) && !(ship.shp_autonav & AN_STANDBY))
		  {
		    pr(fmt("Ship #%d has other orders!\n",ship.shp_uid));
		    continue;
		  }
		count++;
		ship.shp_mission = 0;
		*ship.shp_path = 'f';
		ship.shp_path[1] = 0;
/*		sprintf(ship.shp_path,"f%d",leader);*/
		ship.shp_follow = leader;
		pr(fmt("Ship #%d follows #%d.\n",ship.shp_uid,leader));
		putship(nstr.cur, &ship);
	}
	if (count == 0) {
		if (argp[1])
			pr(fmt("%s: No ship(s)\n", argp[1]));
		else
			pr(fmt("%s: No ship(s)\n", ""));
		return RET_FAIL;
	}else
		pr(fmt("%d ship%s\n", count, splur(count)));
	return RET_OK;
}
#endif	SAIL
