#ifndef lint
static char *RCSid = "$Header: dist.c,v 1.10 89/10/16 20:24:19 mr-frog Exp $";
#endif /* not lint */

/*
 * dist.c
 *
 * name distribution sector (by a pathname) for a given
 * range of sectors (individually)
 *
 * Dave Pare, 1986
 *
 * Rewritten to use dist sector & BestPath stuff instead of paths.
 * --ts Jan 1993
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "file.h"
#include "path.h"

/*
 * distribute <SECT> <DISTSECT|.|h>
 */
dist()
{
	extern	s_char *argp[];
	extern	int aborted;
	struct	sctstr sect, dsect, tsect;
	struct	nstr_sect nstr, nstr2;
	s_char	*path, *p, *BestDistPath(), *BestLandPath(), *bestownedpath();
	double	move_cost=0.0;
	coord	dstx, dsty;

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;

	while (!aborted && nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		pr(fmt("%s at %s ", dchr[sect.sct_type].d_name,
			xyas(nstr.x, nstr.y, cnum)));
		if ((sect.sct_dist_x != sect.sct_x) ||
			(sect.sct_dist_x != sect.sct_x)){
			getsect(sect.sct_dist_x, sect.sct_dist_y, &tsect);
			if (tsect.sct_own != cnum)
				pr(fmt("distributes to %s, not owned by you.\n",
					xyas(tsect.sct_x, tsect.sct_y, cnum)));
			else
				pr(fmt("distributes to %s. \n",
					xyas(tsect.sct_x, tsect.sct_y, cnum)));
		} else
			pr("has no dist sector. \n");

		p = getstarg(argp[2], "Distribution sector? ");

		if (p && (*p == 0))
			continue;

		if (p && (*p != '.') && (*p != 'h') &&
			(!sarg_xy(p, &dstx, &dsty)))
			return RET_SYN;

		if (p && ((*p == '.') || (*p == 'h'))){
			dstx = sect.sct_x;
			dsty = sect.sct_y;
		}

		if (!getsect(dstx,dsty,&dsect)){
			pr("Bad sector.\n");
			return RET_FAIL;
		}

		if (dsect.sct_own != cnum)
			pr(fmt("Warning: you don't own %s!\n",
				xyas(dsect.sct_x,dsect.sct_y,cnum)));

		path = BestDistPath(&sect,&dsect,&move_cost);

		if (path == (s_char *)0){
			pr(fmt("No owned path from %s to %s.\n",
				xyas(dsect.sct_x,dsect.sct_y,cnum),
				xyas(sect.sct_x,sect.sct_y,cnum)));
			continue;
		}

		if ((dsect.sct_x == sect.sct_x) &&
			(dsect.sct_y == sect.sct_y)) {
			pr(fmt("Distribution from and to %s %s terminated\n",
					dchr[sect.sct_type].d_name,
					xyas(sect.sct_x, sect.sct_y, cnum)));
		} else {
			pr(fmt("%s %s new path distributes to %s (cost %1.3f)\n", 
					dchr[sect.sct_type].d_name,
					xyas(sect.sct_x, sect.sct_y, cnum),
					xyas(dsect.sct_x, dsect.sct_y, cnum),
					move_cost));
			pr(fmt("\tCurrent best path is '%s'\n", path));

			if (dsect.sct_own==cnum && dsect.sct_type != SCT_WAREH)
				pr(fmt("\tWarning: %s not a warehouse!\n",
					xyas(dsect.sct_x, dsect.sct_y, cnum)));
		}
		sect.sct_dist_x = dsect.sct_x;
		sect.sct_dist_y = dsect.sct_y;
		pr("\n");
		putsect(&sect);
	}
	return RET_OK;
}
