#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/lib/common/RCS/damage.c,v 1.3 89/09/17 22:31:18 mr-frog Exp $";
#endif

/*
 * damage.c
 *
 * damage a sector, ship, or plane.
 *
 * Should probably do this in some regular fashion, but
 * we don't yet have a list of fields we can iterate through
 * and find the "damageable" ones.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "land.h"
#include "plane.h"
#include "nuke.h"
#include "xy.h"
#include "nsc.h"
#ifdef EASY_BRIDGES
#include "file.h"
#endif /* EASY_BRIDGES */

shipdamage(sp, dam)
	struct	shpstr *sp;
	int	dam;
{
	if (dam <= 0)
		return;
	if (dam > 100)
		dam = 100;
	sp->shp_effic = damage((int)sp->shp_effic, dam);
	if (sp->shp_mobil > 0)
		sp->shp_mobil = damage((int)sp->shp_mobil, dam);
#ifdef FUEL
	if (sp->shp_fuel > 0)
		sp->shp_fuel = damage((int)sp->shp_fuel, dam);
#endif /* FUEL */
	sp->shp_nv = vl_damage(dam, sp->shp_vtype, sp->shp_vamt,
		(int) sp->shp_nv);
}

landdamage(lp, dam)
	struct	lndstr *lp;
	int	dam;
{
	double	real_dam, m;
	extern	int land_mob_max;

	m = (double)land_mob_max;

	if (dam <= 0)
		return;
	if (dam > 100)
		dam = 100;

	/* fortification reduces damage */
	real_dam = m / (m+((double)lp->lnd_harden));
	if (real_dam == 0.0)
		real_dam = 1.0;

	real_dam *= (double)dam;
	dam = ldround(real_dam,1);
	lp->lnd_effic = damage((int)lp->lnd_effic, dam);
	if (lp->lnd_mobil > 0)
		lp->lnd_mobil = damage((int)lp->lnd_mobil, dam);
#ifdef FUEL
	if (lp->lnd_fuel > 0)
		lp->lnd_fuel = damage((int)lp->lnd_fuel, dam);
#endif /* FUEL */
	lp->lnd_nv = vl_damage(dam, lp->lnd_vtype, lp->lnd_vamt,
		(int) lp->lnd_nv);
}

planedamage(pp, dam)
	struct	plnstr *pp;
	int	dam;
{
	if (dam <= 0)
		return;
	if (dam > 100)
		dam = 100;
	pp->pln_effic = damage((int)pp->pln_effic, dam);
	if (pp->pln_mobil > 0)
		pp->pln_mobil = damage((int)pp->pln_mobil, dam);
}

/*
 * nukedamage() actually just calculates damage
 * rather than inflicting it.
 */
int
nukedamage(ncp, range, airburst)
	struct	nchrstr *ncp;
	int	range;
	int	airburst;
{
	int	dam;
	int	rad;

	rad = ncp->n_blast;
	if (airburst)
		rad = (int) (rad * 1.5);
	if (rad < range)
		return 0;
	if (airburst) {
		/* larger area, less center damage */
		dam = (int) ((ncp->n_dam * 0.75) - (range * 20));
	} else {
		/* smaller area, more center damage */
		dam = (int) (ncp->n_dam / (range + 1.0));
	}
	if (dam < 5)
		dam = 0;
	return dam;
}

int
damage(amt, pct)
	register int amt;
	int	pct;
{
	register int tmp;
	register int lost;

	if (amt <= 0)
		return 0;
	tmp = amt * pct;
	lost = tmp / 100;
	if ((random() % 100) < (tmp % 100))
		lost++;
	return amt - lost;
}
