.TH Command MOVE
.SY "move <ITEM> <SECT> <NUMBER> <ROUTE|DESTINATION>"
The move command is crucial to Empire; it carries out the movement
of civilians, military, ore, guns, shells, food, planes, etc. on land.
Note that you can only move into sectors that you own, so you cannot
take sectors via move.  To take sectors, use the "explore" command,
which uses the same syntax as move.
.s3
<ITEM> can be any one of:
.NF
c       civilians
m       military
u	uncompensated workers
f       food
g       guns
s       shells
p       petrol
i       iron ore
d       gold dust
b       bars of gold
l       light construction materials
h       heavy construction materials
r	radioactive materials
.FI
.s1
If <SECT> is not provided in the command line,
the program will request the starting sector
then display the number of mobility units in that sector,
its designation, and its coordinates in the form:
.s1
.NF
<97.0: a -6,4>
.FI
.s3
which indicates 97 mobility units in agribusiness sector -6,4.
You may respond with any combination of:
.s1
.NF
y  for up-left
u  for up-right               y    u
g  for left                    \\\\  /
j  for right               g  --  --  j
b  for down-left               /  \\\\
n  for down-right             b    n
v  for view
m  for map
h  for end of movement
.FI
.s3
The \*Qview\*U command shows the sector efficiency
and some of the contents of the sector you are currently occupying.
.s3
Since the <ROUTE> can be specified in the command line,
simple movements are often typed as a single line, such as:
.EX move m 2,0 20 jjjh
Or some movements may be done partly on the command line and partly
interactively:
.EX move c 2,2 18 jj
.NF
<32.3: g 6,2> v
10% gold mine with 3 civilians.
<32.3: 6,2> h
.FI
.s3
You may also simply specify the destination sector.
In this case,
empire will set the path to be the cheapest path (in terms of
mobility) from the current sector to the destination sector,
if such a path exists.
.s3
For example,
.EX move c 2,2 18 6,2
.s1
Typical mobility costs are:
.s1
.NF
 1 mu per 5 civilians
 1 mu per 5 military
 2 mu per 5 uncompensated workers
 2 mu per 5 shells
 2 mu per gun
 4 mu per plane
 1 mu per 5 tons of iron ore
 1 mu per 5 tons of gold dust
10 mu per bar of gold
 1 mu per 5 tons of food
 1 mu per 5 units of oil
 1 mu per 5 tons of light construction materials
 1 mu per 5 tons of heavy construction materials
 1 mu per 5 tons of radioactive materials
.FI
.s1
Mobility is used from the source sector when moving.
Mobility used is a factor of the commodity involved, the types of the
sector and dist sector, the efficiency of both, the cost of the
path to the distribution sector, and the amount of the commodity.
When the move is finished, move reports the total mobility used,
and the amount of mobility left in the sector.
.s3
.L Weight
.s3
Each commodity has a weight. Normally, everything weighs the same, 1, except
for gold dust, which is 5x as hard to move, uw's, which are 2x, and gold bars,
which are 50x. This is deity-settable, but rarely changes.
.s3
.L Packing
.s3
Some sectors are better at moving commodities. This ability is known
as their packing factor. Warehouses are 10x as good
as a normal sector at moving anything but people (normal) and bars (5x).
Banks are 4x as good as moving bars. These sectors only get these bonuses
for moving items \*Qfrom\*U them \*Qto\*U somewhere else, not moving \*Qinto\*U
the sector. If the sector is less than 60% efficient, it doesn't get it's
packing bonus.
.s3
.L "Path Cost"
.s3
The path cost is the cumulative mobility cost of moving through each
sector in the path. The cost to enter a sector is based on the sector's type
and effiicency. Most normal sectors cost .4 to enter at 0%, decreasing to
0.2 at 100%. Roads start at 0.2 at 0%, and decrease to 0.01 cost at 100%.
Bridges are 0.2/0.1, wilderness sectors are 0.8/0.4, and mountains are
25.4/12.7 (ouch!). These constants are deity-settable, but rarely changed.
(The most common change is making bridge spans the same as roads)
.s3
.L Mines
.s3
Note that while moving, you might hit mines. The more stuff you're
moving, the greater the chance of setting off any
mines in the sectors you move through. See info lmine for more details.
.s3
Also, when moving unhappy civilians (work percentage less than 100%), 
unhappiness is contagious. If you move even 1 unhappy civilian into a
sector, the new sector's work percentage is set to the level of the
civilian being moved, if that is less than the existing level.
.s3
However, if the NEW_WORK option is enabled, the work percentage of the
destination sector is computed by averaging the incoming civ's happiness
with the happiness of the civs already there. For example, say you move
100 civs with work percentage of 0% into a sector with 100 fully happy
civilians (100% work). If NEW_WORK is enabled, the work would be:
.ti 3
((migrants * their work) + (people at dest * their work) / (total civs)
((100 * 0%) + (100 * 100%)) / (100+100) =  100/200 = 50%
.s3
See also : navigate, transport, test, explore
