.TH Command MISSION
.SY "mission <type> <UNITS> <s|i|e|r|a|c|q> [<op sector|.>] [<radius>]"
.s3
The mission command is used to assign ships, planes, or land units to
missions. The available missions are: support, 's' (planes only),
interdiction, 'i' (any), escort, 'e' (escort or intercept capable planes only),
air defense, 'a' (intercept capable planes only),
and reserve, 'r' (land units only). You may also use 'q' (query) to check on
the mission of something, or 'c' (clear) to wipe the mission of a land
unit/plane/ship.

.s3
GENERAL CONCEPT
.s3
Missions are things that your planes/land units/ships can do automatically, such
as bombing/shelling. You assign a unit to a mission, and whenever the right
conditions occur, the unit attempts to perform its mission. Note that missions
don't allow a unit to do anything it normally could not do, they simply allow
them to do it in an automatic fashion. In some cases, units performing missions
might not be as 'smart' as they would be if you were operating them personally.
That's the price you pay for having automatic defenses.
.s3
.L "IMPORTANT NOTES"
.s3
No missions occur during updates.
.s3
Planes flying missions will be intercepted normally. (i.e. if you fly
over enemy territory, you'll get intercepted. Any misison except air
missions may also be intercepted by planes on air defense missions)
.s3
Planes of less than 40% efficiency will not fly missions.
.s3
Planes assigned to missions are \*QNOT\*U eligible to intercept
normally. For example, if a fighter is assigned to an escort or air-defense
or interdiction or support mission, it will \*QNOT\*U rise to intercept
an intruding enemy plane. (planes on air-defense missions will intercept
planes flying in their op-area, in accordance with the air-defense mission,
but will not intercept one outside their op-area, even if it is within
their normal range. Be sure you understand this before using plane missions.)
.s3
OPERATIONS SECTORS
.s3
Some missions require the designation of an 'op sector', short for operations
sector. This is the center of an area that the mission is focussed on.
The op sector may be any sector that is within the unit's range.
(Firing range,
for ships & land units, flying range for planes, changeable with rangeedit).
The unit will exert influence in a radius around the op sector.
By default, the radius will be as large as possible, i.e. the biggest range
so that the unit/ship/plane could legally act there.)
For example, a ship with a range of 4 could designate any sector up
to 4 away from it as it's op sector, and would affect anything within
4 of it's op-sector, provided it was also within 4 of the ship.
.s3
If a smaller radius is desired, it may be specified on
the command line. If it is not specified, it will not be prompted for.
.s3
The area affected by a unit is known as that unit's op-area.
.s3
If a '.' is given as the op-sector, the op sector will be the location
of the unit.
.s3
Additionally, if the unit's op-sector is the sector the unit is in, and
the unit moves without losing its mission
status, the operation sector will move with it. (Normally, of course, the
only way for a unit on a mission to move is to be carried on a ship, so
this mostly applies to planes on carriers) Thus, a tactical bomber on a ship
could have an op-area centered on the carrier that moved with the carrier.
.s3
Otherwise, if the unit moves without losing its mission status, the
op sector will stay where it was designated.
.s3
For example, suppose that land unit 4 is an artillery unit, range 5,
located at 0,0.
.s3
.EX "mission land 4 int ."
.s3
This would make the unit interdict anything passing within 5 sectors of
its location.
.s3
.EX "mission land 4 int 4,0"
.s3
This would make the unit interdict anything passing within 5 sectors of
4,0, provided it was also within 5 sectors (the unit's range) of 0,0.
.s3
.EX "mission land 4 int 4,0 2"
.s3
This would make the unit interdict anything passing within 2 sectors of
4,0, provided it was also within 5 sectors (the unit's range) of 0,0.
.s3
The op-sector/op-range concept allows you to restrict a unit's area of 
interest to a small, important area, or just let it shoot at anything within
range.
.s3
MOBILITY USE
.s3
When a unit is given a mission, it immediately uses 1/2 it's maximum mobility.
For example, if a plane unit (normal max mobility 127) is given a mission, it
immediately loses 64 mobility. From then on, whenever the unit performs its
mission, it uses less than the amount of mobility is would normally use. For
instance, if a land unit is given a reserve mission and then reacts to a sector,
it pays only half the normal mobility cost of combat.
A plane performing a mission would pay only 1/4 the
normal amount of mobility to fly a mission. A sub torping as part of a mission
would pay 1/2 the normal amount of mobility, etc. Learn by doing.
.s3
A unit stays on it's mission until you cancel it, OR the unit acts. Any type
of action not a part of a mission
is sufficient, so marching, navving, transporting, flying, reconing,
fortifying, bombing, mining, paratrooping, being attacked, being 
paratrooped on, retreating, etc, will all cause a unit to lose its 
mission status, but the unit could bomb/shell/etc AS PART OF A MISSION, and
still retain its mission status.
Also, land units with a reserve
mission can react to a threatened sector and fight, and (assuming they win)
return to their original sector without losing their reserve status.
.s3
DEFENDERS
.s3
The defender's planes will intercept planes flying missions.
His ships/forts/units, however, will \*QNOT\*U fire at ships/forts/units
firing on a mission.
.s3
INTERDICTION MISSIONS (ships, planes, land units)
.s3
When giving a unit a interdiction mission, you designate an op sector. From
then on, whenever an enemy (defined as something belonging to a nation which
you are hostile or worse towards) moves in a sector in that unit's op-area,
the unit will try to shell or bomb it (as appropriate). Almost any kind of
movement, except for distribution movement during an update, and the tiny
amounts moved by the supply routines is enough.
.s3
For example, an enemy land unit marching up to the front would be
shelled/bombed.
An enemy moving commodities around would have the commodities automatically
shelled/bombed. A ship navving into a sea sector would be shelled or bombed,
depending on it's type (obviously, only depth-charge or ASW capable units would
affect a submarine, and a submarine would only affect things it could torpedo)
In general, units can only affect things they could normally affect. For
example, if the enemy was transporting a plane along a highway, and you had an
artillery unit and a light bomber interdicting the highway sector, the land
unit would fire and the bomber would fly there and bomb, and the total damage
would be applied to the plane being transported. If it was still alive, it
might be moved to another sector, there to be bombed/shelled again (assuming the
new sector was also in both units' op-areas) If a different unit later moved
in, it would be shelled/bombed. This happens as long as the interdicting units
have mobility left.
.s3
Damage done is divided amongst all units/ships/commodities moving. For
example, if 6 ships were moving, and the interdiciton mission did 18 pts of
damage, each ship would take 3. 
.s3
Note that only ships with sonar and ASW planes can interdict subs. Also, the
units may or may not detect the subs, so it's kind of random. The sub also
has a chance of escaping the damage, depending on the visibility of the sub.
.s3
Only planes with the 'tactical' ability can fly interdiction missions.
Only planes with 'ASW' ability will fly vs. subs. Planes with 'ASW'
ability will not fly interdiction vs. other types of ships/planes/units/commods.
Interdiction has no effect on flying planes. Interdiction affects
only things moving on the surface.
.s3
Note also that forts will fire at enemy ships coming within
range. You don't have to set anything for this, it
happens automatically. (Forts firing at enemy ships naving happens before 
ships/planes/units interdicting ships, so if the enemy is using an area a 
lot, a fort will hurt him without costing you mob from planes)
.s3
SUPPORT MISSIONS (planes only)
.s3
When giving a plane a support mission, you designate an op sector. From then on,
whenever a sector owned by the plane's owner in that plane's op-area is
attacked, the plane will attempt to fly to that sector and give ground support.
If the plane's owner attacks a sector in that plane's op-area, the plane will
also attempt to fly there and give offensive support. (see info attack for
more information on how support works in land combat)
.s3
Only planes with the 'tactical' ability can fly support missions.
.s3
ESCORT MISSIONS (planes only)
.s3
When given an escort mission, an escort or intercept capable plane will attempt
to escort any plane flying a support or interdict mission from the same airport.
If even 1 plane flys a support or interdiction mission from an airport, all
planes on escort duty at that airport will attempt to escort. Planes with escort
duty will NOT attempt to escort planes taking off from other airports, so it
pays to put your bombing planes and escorting planes together.
.s3
Only planes with the 'escort' or 'intercept' abilities can fly escort missions.
.s3
AIR DEFENSE MISSIONS (planes only)
When given an air defense mission, an intercept capable plane will attempt
to intercept any enemy plane flying into its operations area, irregardless
of whether the enemy planes are flying over owned sectors. For example, if
a plane is given an air defense mission with an op area covering some
owned sectors, some sea, some allied sectors, and some enemy sectors, it
would try to intercept over any of them.
.s3
When a plane enters a sector, any planes with air defense missions that are
hostile to the plane will fly there to fight it. The air defense planes
encounter normal interception along the way (but do \*QNOT\*U trigger 
more air defense missions, but \*QMAY\*U be intercepted normally).
Once the air defense planes get to the sector,
they fight the plane. Then, if the plane is hostile to the actual owner of
the sector, still more planes may intercept it.
.s3
.L Example
Groonland wants to run a recon flight over Bannannarama. Joeland has a
jet fighter with an air defense mission and an op-area covering part of
Bannannarama. The 'j' sector belongs to Joeland, and is the base for the
fighter. The 'b' sectors belong to Bannannarama, which has 1 fighter
in the center sector. The 'g' sector belongs to Groonland. Assume that
all countries are mutually hostile.
.s3
The Joeland fighter's op area is centered on the 'B', radius 2.
.NF
 . . . . . . . . . . . . . . . . . 
  . . . . . j . . . . . b b . . . .
 . . . . . . . . . . . b B b . . . 
  . . . . . . . . . . . b b . . . .
 . . . . . . . . . g . . . . . . . 
.FI
.s3
The Groonland player enters a path of 'uujjjbgbggh'.
The first sectors entered is sea, and is not in the Joeland
aircraft's op-area, so nothing happens.
.s3
Next, the Groonland plane enters the sector adjacent to Bannannarama.
This is within the Joeland aircraft's op-area, so it flies to intercept.
It takes the shortest path there, and fights the Groonland plane.
Let's say that both take 20 points of damage, and neither aborts.
.s3
Next, the Groonland plane overflies a Bannannarama sector. The Joeland
plane flies there, and is intercepted by the Bannannarama plane. Let's
say that it comes through the fight without being aborted. It then fights
the Groonland plane. After this combat, if the Groonland plane is not
aborted, it may be intercepted again by the busy Bannannarama fighter,
assuming that that plane is still efficient enough, has mob enough, etc.
.s3
A good use of this mission is to provide a wider CAP around a carrier,
so that enemy planes get intercepted several times on the way to the
carrier, rather than just once, in the carrier's sector.
.s3
Another use is to provide air-cover for an ally who has temporarily
lost his planes.
.s3
RESERVE MISSIONS (land units only)
.s3
A land unit given reserve orders has an increased ability to react to enemy
attacks. A reserve unit has its reaction radius increased by 2.
(Note: this is cumulative with the +1 modifier for being at an
efficient headquarters, so a reserve unit at an HQ would have a +3).
In addition, a reserve unit pays 1/2 the normal cost for fighting a battle.
(It still pays the normal cost for moving to the threatened sector)
See info attack for more details on reaction.
.s3
Note that units with a reserve mission retain this status, even though they
move to the threatened sector and return. This is an exception to the normal
rules on losing your mission status. If, however, the land unit is forced to
retreat from the combat (see land combat for details), it WOULD lose its status.
.s3
When a unit with a reserve mission is listed, the op sector is the sector
the unit is in, and the radius is the units maximum reaction radius, including
the bonus for the reserve mission and HQ (if applicable). Note that the unit's
actual radius might be different if it was changed by lrangeedit.
.s3
Final note: information gained from planes flying missions is not automatically
added to your bmap (due to annoying programming problems) However, you may use
the bdesignate command to add the information manually, if you so desire.
(See info \*Qbdesignate\*U for more information on bdes)
.s3
See also : ship-types, plane-types, land-types, attack, bomb
