.TH Command DISTRIBUTE
.SY "distribute <SECTS> <DISTSECT|.|h>"
The distribute command is used to specify the way that goods will
travel during an update.
Each sector is allowed to have one and only one
\*Qdistribution sector\*U (a warehouse or road, typically).
Subsequent distribute commands
will replace the existing distribution sector.
.s3
For example,
.EX distribute 2,0 8,4
.NF
highway at 2,0 delivers to 8,4. 
Distribution sector? 7,-1
highway 2,0 new path distributes to 7,-1 (cost 0.200)
        Current best path is 'gguh'
.FI
This command changed the distribution path for sector 2,0 from
a warehouse at 8,4 to a warehouse at 7,-1. The cost is the mobility cost
to move 1 normal-weight unit from the sector to the warehouse.
.s1
DISTSECT is a normal empire sector specification. During the update,
empire will determine the cheapest existing path to the distribution
sector, and use that. (Note that the mobility cost for the path used
during the update could
be different than the cost reported to you when you use the distribute command,
if you have re-designated sectors, or sectors were captured, etc)
Again, it will use the cheapest path available AT THE TIME OF THE UPDATE.
.s3
You may also use '.' or 'h' to specify no distribution sector.
.s3
.EX dist 2,0 .
.NF
Distribution to and from 2,0 halted.
.FI
.s1
The command will warn you if there is no existing path completely
owned by you, and also if the path does not end at a warehouse.
It is not required that the distribution path end at a warehouse,
but it is required that you own all the sectors that the goods
will travel along.
.s3
.L "Distribution & the Update"
.s3
One of the last things that takes place during the update, after all growth,
production, delivery, etc, distribution takes place. (The only thing that
really happens after that is mobility increases) Each sector may have
product
thresholds and a distribution sector. A threshold is a target level for a
particular commodity, like food. So, if the food threshold for a sector is
100, it will try to maintain 100 food there. If it has more than 100 food,
it will export it to its distribution point. If it has less than 100, it
will try to import food from the distribution point to reach 100.
.s3
During the distribution phase of the update, all sectors (going left to
right, top to bottom) first export excess
commodities, and then (again left to right, top to bottom)
import needed commodities.
.s3
In order to either send things to or get things from a distribution sector,
you must own the distribution sector, and there must be a path of owned
sectors to it.
.s3
Mobility is used from the sector when sending \*Qto\*U the distribution sector.
When getting something \*Qfrom\*U the distribution sector, mobility is paid
by the distribuion sector.
Mobility used is a factor of the commodity involved, the types of the
sector and dist sector, the efficiency of both, the cost of the
path to the distribution sector, the amount of the commodity, and
the mobility break given to distribution.
.s3
.L Weight
.s3
Each commodity has a weight. Normally, everything weighs the same, 1, except
for gold dust, which is 5x as hard to move, and gold bars, which are 50x.
This is deity-settable, but rarely changes.
.s3
.L Packing
.s3
Some sectors are better at moving commodities. This ability is known
as their packing factor.
If a sector is less than 60% efficient, it doesn't get it's packing bonus.
.s3
Warehouses are 10x as good
as a normal sector at moving anything but people (normal) and bars (5x).
Banks are 4x as good as moving bars. Warehouses get to use their
packing factor whenever they ship something, or something is shipped to them.
The other sectors only get their bonuses
for moving items \*Qfrom\*U them \*Qto\*U somewhere else, not moving \*Qinto\*U
the sector.
.s3
So, when the sector is sending something \*Qto\*U the distribution sector,
it uses its packing bonus, if any, unless its distribution center is a
60% or better warehouse, in which case it uses the warehouse's packing.
When getting something \*Qfrom\*U the
distribution sector, the dist sector's packing bonus is used.
.s3
.L Cost
.s3
The path cost is the cumulative mobility cost of moving a unit of weight 1
along the path. The cost to enter a sector is based on the sector's type
and efficiency. Most normal sectors cost .4 to enter at 0%, decreasing to
0.2 at 100%. Roads start at 0.2 at 0%, and decrease to 0.01 cost at 100%.
Bridges are 0.2/0.1, wilderness sectors are 0.8/0.4, and mountains are
25.4/12.7 (ouch!). These constants are deity-settable, but rarely changed.
(The most common change is making bridge spans the same as roads)
.s3
When importing, the cost used is the cost to move something from the dist
point to the sector. When exporting, the cost used is the cost to move
something from the dist point into the sector.
.s3
.L Amount
.s3
The amount is determined by the threshold, as explained above.
Use the \*Qthreshold\*U command to specify what goods
will flow to and from the warehouse.
.s3
.L Mobility_Break
.s3
Distribution gets a cost break, making it cheaper (in terms of mobility)
than moving things manually. Moving things via distribute takes 1/4 the 
mobility it would take to move it normally.
.s3
.L CHANGES
.s3
Note! In earlier versions, all distributions sectors got used warehouse
packing, regardless of whether they were warehouses or not, and regardless
of their efficiency. \*QTHIS IS NO LONGER TRUE\*U.
Also, sectors got to use their
packing bonus regardless of their efficiency. \*QTHIS IS NO LONGER TRUE\*U.
This may change some of your strategies, if you are used to playing earlier
versions of empire. Be warned.
.s3
.L "Finding sectors with not dist point set"
.s3
If you want to find sectors with no distribution point set, use the 
xdist and ydist selectors:
.s3
.EX level # ?xdist=xloc&ydist=yloc
.s3
This finds all sectors that have themselves as a distribution point.
.s3
See also : deliver, threshold, level
