/* Autoconf patching by David Hedbor, neotron@lysator.liu.se */
/*********************************************************************/
/* file: action.c - funtions related to the action command           */
/*                             TINTIN III                            */
/*          (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t             */
/*                     coded by peter unold 1992                     */
/*********************************************************************/
#include <ctype.h>
#ifdef HAVE_STRING_H
#include <string.h>
#else
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#endif
#include "tintin.h"
#include <readline/readline.h>


#include <sys/signal.h>
#ifndef BADSIG
#define BADSIG (void (*)())-1
#endif

extern struct session *activesession;
extern struct listnode *common_sounds;
extern char vars[10][BUFFER_SIZE]; /* the &0, %1, %2,....%9 variables */
extern int term_echoing;
extern int readline_echoing_p;
extern int ignore_interrupt;
extern int echo;
extern char tintin_char;
extern int sonum;
extern int mesvar[6];
extern char *get_arg_in_braces();
extern struct listnode *search_node_with_wild();
extern struct listnode *searchnode_list();
extern void substitute_vars();
extern int match_a_string();
extern char homepath[];
int var_len[10];
char *var_ptr[10];

int pid;

char defaultplayer[256] = "audioplay";

/***********************/
/* the #sound command */
/***********************/

/*  Priority code added by Joann Ellsworth 2/2/94 */

void sound_command(arg, ses)
     char *arg;
     struct session *ses;
{
  char left[BUFFER_SIZE], right[BUFFER_SIZE], result[BUFFER_SIZE];
  char pr[BUFFER_SIZE];
  struct listnode *mysounds, *ln;

  mysounds=(ses) ? ses->sounds : common_sounds;
  arg=get_arg_in_braces(arg, left, 0);
  arg=get_arg_in_braces(arg, right, 1);
  arg=get_arg_in_braces(arg, pr, 1);
  if (!*pr) strcpy(pr, "5"); /* defaults priority to 5 if no value given */
  if(!*left) {
    tintin_puts2("#Defined sounds:", ses);
    show_list_sound(mysounds);
    prompt(ses);
  }

  else if(*left && !*right) {
    if ((ln=search_node_with_wild(mysounds,left))!=NULL) {
      while((mysounds=search_node_with_wild(mysounds, left))!=NULL) {
        shownode_list_sound(mysounds);
      }
      prompt(ses);
    }
    else
      if (mesvar[1])
        tintin_puts("#That sound is not defined.", ses);
  }

  else {
    if((ln=searchnode_list(mysounds, left))!=NULL)
      deletenode_list(mysounds, ln);
    insertnode_list(mysounds, left, right, pr, PRIORITY);
    if (mesvar[1]) {
      sprintf(result,"#Ok. {%s} now triggers {%s} @ {%s}",left,right,pr);
      tintin_puts2(result, ses);
    }
    sonum++;
  }
}

/*************************/
/* the #sound command */
/*************************/
void unsound_command(arg, ses)
     char *arg;
     struct session *ses;
{
  char left[BUFFER_SIZE] ,result[BUFFER_SIZE];
  struct listnode *mysounds, *ln, *temp;
  int flag;
  flag=FALSE;
  mysounds=(ses) ? ses->sounds : common_sounds;
  temp=mysounds;
  arg=get_arg_in_braces(arg,left,1);
  while ((ln=search_node_with_wild(temp, left))!=NULL) {
    if (mesvar[1]) {
      sprintf(result,"#Ok. {%s} is no longer a trigger.",ln->left);
      tintin_puts2(result, ses);
    }
    deletenode_list(mysounds, ln);
    flag=TRUE;
    temp=ln;
  }
  if (!flag && mesvar[1]) {
    sprintf(result, "#No match(es) found for {%s}", left);
    tintin_puts2(result, ses);
  }
}

/**************************************************************************/
/* run throught each of the commands on the right side of a sound         */
/* expression, call substitute_text() for all commands but #sound         */
/**************************************************************************/
void prepare_soundalias(string, result, ses)
     char *string;
     char *result;
     struct session *ses;
{

  char arg[BUFFER_SIZE];
  *result='\0';
  substitute_vars(string,arg);
  substitute_myvars(arg, result, ses);
}

/**********************************************/
/* play sound                                 */
/**********************************************/

void sound_play(path)
     char *path;
{
   char lbuf[2049];
   char lbuf2[2049];
   
   strcpy(lbuf, homepath);
   strcat(lbuf, "/.ttsounds/");
   strcat(lbuf, path);
   
   strcpy(lbuf2, homepath);
   strcat(lbuf2, "/.ttsounds/playsound.sh");
   
  if((pid = fork()) < 0)
    {
      fprintf(stderr, "fork() failed, exiting.\n");
      exit(-1);
    }
  
  if(!pid)
    { 
      close(0); /* close stdin and stdout */
      close(1);
      
      execlp(lbuf2, lbuf2, lbuf, defaultplayer);
      fprintf(stderr, "%s does not exist or is not executable.\n",
	      lbuf2);
      exit(-2);
    }
  
}

void chldwait()
{
   int res;
   
   ignore_interrupt = 1;
   while(wait(&res) != pid); /* wait for that child so we dont get zombies */
   pid = -1;
   
   if(signal(SIGCHLD, chldwait) == BADSIG)
      syserr("signal SIGCHLD");

}

/*
 * default player command 
 */

void defplay_command(arg, ses)
     char *arg;
     struct session *ses;
{
  char left[BUFFER_SIZE];
  char lbuf[1024];
  
  arg = get_arg_in_braces(arg, left, 0);
  
  if(!*left)
    sprintf(lbuf, "Default player is %s\n", 
	    *defaultplayer ? defaultplayer : "<none> (using playmidi)");
  else
    {
      strcpy(defaultplayer, left);
      sprintf(lbuf, "Default player has been set to %s\n", 
	      defaultplayer);
    }
  tintin_puts2(lbuf, ses);
}
/**********************************************/
/* check sounds from a sessions against line */
/**********************************************/
void check_all_sounds(line, ses)
     char *line;
     struct session *ses;
{

  struct listnode *ln;
 static char temp[BUFFER_SIZE]=PROMPT_FOR_PW_TEXT;
 char strng[BUFFER_SIZE];
 if(check_one_sound(line, temp, ses) && ses==activesession) {
    term_echoing=FALSE;
    readline_echoing_p = 0;	/* this tells readline to quit echoing */
  } 
  ln=(ses) ? ses->sounds : common_sounds;

  while(( ln=ln->next )) {
    if(check_one_sound(line, ln->left,ses)) 
      {
	char buffer[BUFFER_SIZE];
	/* prepare_soundalias(ln->right, buffer,ses); not needed */
	if(echo && activesession==ses) 
	  { 
	    sprintf(strng, "[SOUND: %s]", buffer);
	    tintin_puts2(strng, activesession);
	  }
	/*	parse_input(buffer, ses);  sounds does not do screenstuff */
	
	sound_play(ln->right);
	return;
      }
  }
}

int check_one_sound(line, sound, ses)
     char *line;
     char *sound;
     struct session *ses;
{
  int i; 
  if (check_a_sound(line,sound,ses)) {
    for(i=0; i<10; i++) {
      if (var_len[i]!=-1) {
        strncpy(vars[i], var_ptr[i], var_len[i]);
        *(vars[i]+var_len[i])='\0'; 
      }
    }
    return TRUE;
  }       
  else
    return FALSE;
}
/******************************************************************/
/* check if a text triggers a sound and fill into the variables   */
/* return TRUE if triggered                                       */
/******************************************************************/
int check_a_sound(line, sound, ses)
     char *line;
     char *sound;
     struct session *ses;
{   
  char result[BUFFER_SIZE];
  char *temp2, *tptr, *lptr, *lptr2;
  int  i,flag_anchor, count, len, flag;
  for (i=0; i<10; i++) var_len[i]=-1;
  flag_anchor=FALSE;
  lptr=line;
  substitute_myvars(sound,result,ses);
  tptr=result;
  if(*tptr=='^') {
    tptr++;
    flag_anchor=TRUE;
    /* CHANGED to fix a bug with #action {^%0 foo}
     * Thanks to Spencer Sun for the bug report (AND fix!)
    if (*tptr!=*line)
      return FALSE;
    */
  }
  if (flag_anchor) {
    if ((len=match_a_string(lptr, tptr))==-1)
      return FALSE;
    lptr+=len;
    tptr+=len;
  }
  else {
    flag=TRUE;
    len=-1;
    while(*lptr && flag) {
      if((len=match_a_string(lptr, tptr))!=-1) {
        flag=FALSE;
      }
      else
        lptr++;
    }
    if (len!=-1) {
      lptr+=len;
      tptr+=len;
    }
    else
      return FALSE;
  }
  while(*lptr && *tptr) {
    temp2=tptr+2;
    if (!*temp2) {
      var_len[*(tptr+1)-48]=strlen(lptr);
      var_ptr[*(tptr+1)-48]=lptr;
      return TRUE;
    }
    lptr2=lptr;
    flag=TRUE;
    len=-1;
    while(*lptr2 && flag) {
      if ((len=match_a_string(lptr2, temp2))!=-1) {
        flag=FALSE;
      }
      else 
        lptr2++;
    }
    if (len!=-1) {
      var_len[*(tptr+1)-48]=lptr2-lptr;
      var_ptr[*(tptr+1)-48]=lptr;
      lptr=lptr2+len;
      tptr=temp2+len;
    }
    else {
      return FALSE;
    }
  }
  if (*tptr)
    return FALSE;
  else
    return TRUE;
}       
    























