/* New for v2.0: readline support -- daw */

/*
 * Routines to figure out the screen size for split mode.
 * Code is mostly stolen from less-v177!
 */

#ifdef Xenix
#include <sys/types.h>
#include <sys/ioctl.h>
#endif

#ifdef HAVE_SYS_TERMIO_H
#include <sys/termio.h>
#else
#include <sgtty.h>
#endif

#if !defined(HAVE_SYS_TERMIO_H) && defined(TIOCGWINSZ)
#include <sys/ioctl.h>
#else
/*
 * For the Unix PC (ATT 7300 & 3B1):
 * Since WIOCGETD is defined in sys/window.h, we can't use that to decide
 * whether to include sys/window.h.  Use SIGPHONE from signal.h instead.
 */
#include <signal.h>
#ifdef SIGPHONE
#include <sys/window.h>
#endif
#endif

/* for SCO.  god only knows if this'll work.  -- daw */
#if defined(HAVE_PTEM_H) && defined(TIOCGWINSZ)
/*
 * All this just to get struct winsize.  Sigh.
 */
#include <sys/types.h>
#include <sys/stream.h>
#include <sys/ptem.h>
#endif

/*
 * These two variables are sometimes defined in,
 * and needed by, the termcap library.
 * It may be necessary on some systems to declare them extern here.
 */
/*extern*/ short ospeed;	/* Terminal output baud rate */
/*extern*/ char PC;		/* Pad character */

extern char *tgetstr();
extern char *tgoto();
extern char *getenv();

/*
 * Get size of the output screen.
 */
void
scrsize(p_height, p_width)
	int *p_height;
	int *p_width;
{
	register char *s;
#ifdef TIOCGWINSZ
	struct winsize w;
#else
#ifdef WIOCGETD
	struct uwdata w;
#endif
#endif

#ifdef TIOCGWINSZ
	if (ioctl(2, TIOCGWINSZ, &w) == 0 && w.ws_row > 0)
		*p_height = w.ws_row;
	else
#else
#ifdef WIOCGETD
	if (ioctl(2, WIOCGETD, &w) == 0 && w.uw_height > 0)
		*p_height = w.uw_height/w.uw_vs;
	else
#endif
#endif
	if ((s = getenv("LINES")) != (char *) 0)
		*p_height = atoi(s);
	else
 		*p_height = tgetnum("li");

	if (*p_height <= 0)
		*p_height = 24;

#ifdef TIOCGWINSZ
 	if (ioctl(2, TIOCGWINSZ, &w) == 0 && w.ws_col > 0)
		*p_width = w.ws_col;
	else
#ifdef WIOCGETD
	if (ioctl(2, WIOCGETD, &w) == 0 && w.uw_width > 0)
		*p_width = w.uw_width/w.uw_hs;
	else
#endif
#endif
	if ((s = getenv("COLUMNS")) != (char *) 0)
		*p_width = atoi(s);
	else
 		*p_width = tgetnum("co");

 	if (*p_width <= 0)
  		*p_width = 80;
}
