struct objpos_data
{
  int position;
  int in_object;
  int container;
}; 

#define INVENTORY	-1
#define CONTAINER	-2

void read_obj_pos(struct char_data *ch)
{
  char fn[40];
  FILE *obj_file;
  struct objpos_data op;
  struct obj_data *obj,*obj2,*obj3;
  int container,found;

  int perform_wear(struct char_data *ch,struct obj_data *obj, int where);
  void perform_put(struct char_data *ch,struct obj_data *obj, struct obj_data *cont);

  read_obj = TRUE;
  if(!get_filename(GET_NAME(ch), fn, OBJPOS_FILE)){
    sprintf(buf2, "Cannot get file for PLAYER %s in read_obj_pos()", GET_NAME(ch));
    log(buf2);
    send_to_char("There is a problem loading your ITEMS IN PLACE.\r\n"
                 "Please contact a god and report this.\r\n", ch);
    read_obj = FALSE;
    return;
  }

  if(!(obj_file = fopen(fn, "rb"))){
    read_obj = FALSE;
    return;
  }

  fread((char *)&op, 1, sizeof(struct objpos_data), obj_file);
  obj = ch->carrying;
 
  /* Handle Equipment */
  while((!(feof(obj_file)) && (op.position > INVENTORY)) && (!op.in_object)){
    perform_wear( ch, obj, op.position );
    obj = obj->next;
    fread((char *)&op, 1, sizeof(struct objpos_data), obj_file); 
  }
 
  while(!(feof(obj_file))){
    if( op.in_object) {
      if( op.position > INVENTORY )
        perform_put( ch, obj, ch->equipment[op.position]);
      else{ 
        container = 0; 
        found = FALSE;
        for( obj2 = ch->carrying; obj2 && !found; obj2 = obj2->next_content)
          if( GET_OBJ_TYPE(obj2) == ITEM_CONTAINER ){
            container++;
            if(container == op.container)
              found = TRUE; 
            obj3 = obj2;
          }
        perform_put( ch, obj, obj3);
      }  
    } 
    obj = obj->next; 
    fread((char *)&op, 1, sizeof(struct objpos_data), obj_file);
  }

  fclose(obj_file);
  read_obj = FALSE;
}

void save_obj_pos(struct char_data *ch)
{
  char fn[40];
  FILE *obj_file;
  int i,container;
  struct objpos_data op;
  struct obj_data *obj,*obj2;
  

  if(!get_filename(GET_NAME(ch), fn, OBJPOS_FILE)){
    sprintf(buf2, "Cannot get file for PLAYER %s in save_obj_pos()", GET_NAME(ch));
    log(buf2);
    send_to_char("There is a problem saving your ITEMS IN PLACE.\r\n"
                 "Please contact a god and report this.\r\n", ch);
    return;
  }

  if(!(obj_file = fopen(fn, "wb"))){
    sprintf(buf2, "Cannot create file for PLAYER %s in save_obj_pos()", GET_NAME(ch));
    log(buf2);
    send_to_char("There is a problem saving your ITEMS IN PLACE.\r\n"
                 "Please contact a god and report this.\r\n", ch);
    unlink(fn);    /* erase the old one */ 
    return; 
  }

  /* To have this file match the players' object file, the loop MUST run
     backwards while processing equipment.
  */
  op.container = 0; 
  for( i = NUM_WEARS-1; i >= 0; i--)
    if( ch->equipment[i] ){ 
      op.position = i; 
      fwrite((char *)&op, 1, sizeof(struct objpos_data), obj_file);
    } 
 
  /* Now do inventory.  Note all items MUST be recorded since we want to
     match the players' object files.
  */
  op.position = INVENTORY;  /* Position for INVENTORY for this loop */
  op.in_object = FALSE;
 
  for( obj = ch->carrying; obj; obj = obj->next_content)
    fwrite((char *)&op, 1, sizeof(struct objpos_data), obj_file);

  for( i = NUM_WEARS-1; i >= 0;  i--)
    if( GET_OBJ_TYPE(ch->equipment[i]) == ITEM_CONTAINER )
      for( obj = ch->equipment[i]->contains; obj; obj = obj->next_content){
        op.in_object = TRUE; 
        op.position = i;
        fwrite((char *)&op, 1, sizeof(struct objpos_data), obj_file);
      }
 
  container = 0;
  op.position = INVENTORY;   
  for( obj = ch->carrying; obj; obj = obj->next_content)
    if( GET_OBJ_TYPE(obj) == ITEM_CONTAINER ){
      container++;
      op.container = container; 
      for( obj2 = obj->contains; obj2; obj2 = obj2->next_content){
        op.in_object = TRUE; 
        fwrite((char *)&op, 1, sizeof(struct objpos_data), obj_file);
      }
    }

  fclose(obj_file);
} 
