/*
   $Id: mSQL.xs,v 1.27 1995/06/22 00:37:04 timbo Rel $

   Copyright (c) 1994,1995  Alligator Descartes

   You may distribute under the terms of either the GNU General Public
   License or the Artistic License, as specified in the Perl README file.

*/

#include "mSQL.h"


/* --- Variables --- */


DBISTATE_DECLARE;

/* see dbd_init for initialisation */
SV *dbd_errnum = NULL;
SV *dbd_errstr = NULL;


MODULE = DBD::mSQL	PACKAGE = DBD::mSQL

BOOT:
    items = 0;	/* avoid 'unused variable' warning */
    DBISTATE_INIT;
    printf( "Bootstrapping mSQL-0.58 ** Disney release\n(c)1995 Alligator Descartes <descarte@mcqueen.com>\n(c)1994-1995 Portions by Tim Bunce <Tim.Bunce@ig.co.uk>\n\n" );
    dbd_init(DBIS);

void
errstr(h)
    SV *	h
    CODE:
    h = 0;	/* avoid 'unused variable' warning */
    ST(0) = sv_mortalcopy(dbd_errstr);


MODULE = DBD::mSQL	PACKAGE = DBD::mSQL::dr

void
disconnect_all(drh)
    SV *	drh
    CODE:
    if (!dirty && !SvTRUE(perl_get_sv("DBI::ENDING",0))) {
	D_dbihcom(drh);
	sv_setiv(dbd_errnum, (IV)1);
	sv_setpv(dbd_errstr, (char*)"disconnect_all not implemented");
	DBIh_EVENT2(drh, ERROR_event, dbd_errnum, dbd_errstr);
	XSRETURN(0);
    }
    XST_mIV(0, 1);


void
dbd_dr_login(drh, host, dbname)
    SV *	drh
    char *	host
    char *	dbname
    PPCODE:
    PUSHMARK(mark);
    XSRETURN(dbd_dr_login(drh, host, dbname));


MODULE = DBD::mSQL    PACKAGE = DBD::mSQL::db


void
dbd_db_prepare(dbh, statement)
    SV *	dbh
    char *	statement
    PPCODE:
    PUSHMARK(mark);
    XSRETURN(dbd_db_prepare(dbh, statement));

void
STORE(dbh, keysv, valuesv)
    SV *	dbh
    SV *	keysv
    SV *	valuesv
    CODE:
    D_dbihcom(dbh);
    D_imp_dbh;
    STRLEN kl;
    char *key = SvPV(keysv,kl);
    SV *retsv = &sv_undef;
    /* Default to caching results for DBI dispatch quick_FETCH	*/
    int cacheit = TRUE;

    if (kl==10 && strEQ(key, "AutoCommit")){
	/* Ignore SvTRUE warning: '=' where '==' may have been intended. */
	int on = SvTRUE(valuesv);
	if ( (on) ? ocon(&imp_dbh->lda) : ocof(&imp_dbh->lda) ) {
	    do_error(imp_dbh->lda.rc, "ocon/ocof failed");
	} else {
	    retsv = (on) ? &sv_yes : &sv_no;	/* cache new state */
	}
    } else {
	warn("STORE st %s %s NOT IMPLEMENTED YET\n",SvPV(dbh,na),key);
	XSRETURN_UNDEF;
    }
    if (cacheit && retsv) /* cache value for later fetch? */
	hv_store((HV*)SvRV(dbh),key,kl,retsv,0);
    XST_mUNDEF(0);


void
FETCH(dbh, keysv)
    SV *	dbh
    SV *	keysv
    CODE:
    D_dbihcom(dbh);
    D_imp_dbh;
    STRLEN kl;
    char *key = SvPV(keysv,kl);
    SV *retsv = NULL;
    /* Default to caching results for DBI dispatch quick_FETCH	*/
    int cacheit = TRUE;

    imp_dbh = imp_dbh; 	/* avoid unused warning */

    if (TRUE) {
	warn("FETCH st %s %s NOT IMPLEMENTED YET\n",SvPV(dbh,na),key);
	XSRETURN_UNDEF;
    }
    if (cacheit) /* cache for next time */
	hv_store((HV*)SvRV(dbh),key,kl,retsv,0);
    ST(0) = sv_mortalcopy(retsv);


void
disconnect(dbh)
    SV *	dbh
    CODE:
    D_dbihcom(dbh);
    D_imp_dbh;
    if (imp_dbh->open_cursors > 0) {
	if (dbis->debug >= 2)
	    warn("disconnect: %d cursor(s) still open", imp_dbh->open_cursors);
    }
    if (!imp_dbh->logged_on) {
	if (dbis->debug >= 2)
	    warn("disconnect: already logged off!");
	XSRETURN_UNDEF;
    }
    PUSHMARK(mark);
    XSRETURN(dbd_db_disconnect(dbh));


void
DESTROY(dbh)
    SV *	dbh
    CODE:
    D_dbihcom(dbh);
    D_imp_dbh;
    if (imp_dbh->logged_on) {
	warn("Database handle destroyed without disconnect");
	dbd_db_disconnect(dbh);
    }
    dbd_db_destroy(dbh);



MODULE = DBD::mSQL    PACKAGE = DBD::mSQL::st

void
rows(sth)
    SV *	sth
    CODE:
    D_dbihcom(sth);
    D_imp_sth;
/*    XST_mIV(0, (IV)imp_sth->cda->rpc); */


void
execute(sth, ...)
    SV *	sth
    CODE:
     D_dbihcom(sth);
     D_imp_sth;
     if ( dbis->debug >= 2 )
         printf( "In: DBD::mSQL::execute()\n" );
     /* Handle binding any supplied values to placeholders */
     if (items > 1) 
       {
	 char name[16];
	 int i, error;
         if ( dbis->debug >= 2 )
             printf( "In: DBD::mSQL::execute::itemsloop()\n" );
	 if (items-1 != HvKEYS(imp_sth->bind_names))
	   {
	     do_error( 1, "Wrong number of bind variables");
	     XSRETURN_UNDEF;
	   }
	 for(i=1, error=0; i < items ; ++i) 
	   {
	     sprintf(name, ":p%d", i);
	     printf( "Name: %s\n", name );
	     if (dbd_bind_ph(sth, imp_sth, name, ST(i)))
		++error;
	   }
	 if (error) 
	   {
	     XSRETURN_UNDEF;	/* dbd_bind_ph called do_error	*/
	   }
       } 
     else 
     if (imp_sth->bind_names) 
       {
         printf( "In: DBD::mSQL::execute::nobinds()\n" );
	 /* oracle will tell us if values have not been bound	*/
	 warn("execute assuming binds done elsewhere\n");
       }

    /* describe and allocate storage for results */
/*    if (!imp_sth->done_desc && dbd_describe(sth, imp_sth)){
        printf( "In: DBD::mSQL::execute::describe()\n" );
        XSRETURN_UNDEF;  *//* dbd_describe called do_error()	*/
/*    } */
    imp_sth->currow = 0;
    imp_sth->flags |= IMP_STH_EXECUTING;
    XST_mYES(0);


void
fetchrow(sth)
    SV *	sth
    PPCODE:
    D_dbihcom(sth);
    D_imp_sth;
    int i;
    SV *sv;
    imp_sth->done_desc = 0;
    if ( dbis->debug >= 2 ) {
        printf( "In: DBD::mSQL::fetchrow\n" );
        printf( "In: DBD::mSQL::fetchrow'imp_sth->currow: %d\n", 
                imp_sth->currow );
        printf( "In: DBD::mSQL::fetchrow'imp_sth->row_num: %d\n", 
                imp_sth->row_num );
      }
    dbd_describe( sth, imp_sth );
    /* Check that execute() was executed sucessfuly. This also implies	*/
    /* that dbd_describe() executed sucessfuly so the memory buffers	*/
    /* are allocated and bound.						*/
    if ( !(imp_sth->flags & IMP_STH_EXECUTING) ) {
	do_error( 1, "no statement executing");
	XSRETURN(0);
      }
    /* Advance through the buffer until we get to the row we want */

    if ( dbis->debug >= 2 ) {
        warn( "Number of fields: %d\n", imp_sth->fbh_num );
        warn( "Current ROWID: %d\n", imp_sth->currow );
      }

    EXTEND(sp,imp_sth->fbh_num);
    for ( i = 0 ; i < imp_sth->fbh_num ; i++ ) {
        imp_fbh_t *fbh = &imp_sth->fbh[i];
        if ( dbis->debug >=2 ) {
            printf( "In: DBD::mSQL::execute'FieldBufferDump: %d\n", i );
            printf( "In: DBD::mSQL::execute'FieldBufferDump->cbuf: %s\n", 
                    fbh->cbuf );
            printf( "In: DBD::mSQL::execute'FieldBufferDump->rlen: %i\n", 
                    fbh->rlen );
          }
        SvCUR( fbh->sv ) = fbh->rlen;
/*        sv = sv_mortalcopy( fbh->sv ); */
        sv = sv_2mortal( newSVpv( fbh->cbuf, fbh->rlen ) );
        PUSHs(sv);
      }
    imp_sth->currow++;

void
readblob(sth, field, offset, len, destsv=Nullsv)
    SV *	sth
    int	field
    long	offset
    long	len
    SV *	destsv
    PPCODE:
    {
    D_dbihcom(sth);
    D_imp_sth;
    ub4 retl;
    SV *bufsv;

    if (destsv) {		/* write to users buffer	*/
	bufsv = SvRV(destsv);
	sv_setpvn(bufsv,"",0);	/* ensure it's writable string	*/
	SvGROW(bufsv, len+1);	/* SvGROW doesn't do +1 itself	*/
    } else {
	bufsv = newSV((STRLEN)len);	/* allocate new buffer	*/
    }
    /* Sadly, even though retl is a ub4, oracle will cap the	*/
    /* value of retl at 65535 even if more was returned!	*/
    /* This is according to the OCI manual for mSQL 7.0.	*/
    /* Once again mSQL causes us grief. How can we tell what	*/
    /* length to assign to destsv? We do have a compromise: if	*/
    /* retl is exactly 65535 we assume that all data was read.	*/
    SvCUR_set(bufsv, (retl == 65535) ? len : retl);
    *SvEND(bufsv) = '\0'; /* consistent with perl sv_setpvn etc	*/
    /* Avoid mortal combat if user supplied own buffer		*/
    ST(0) = (destsv && retl) ? sv_mortalcopy(&sv_yes) : sv_2mortal(bufsv);
    XSRETURN(1);
    }


void
STORE(sth, keysv, valuesv)
    SV *	sth
    SV *	keysv
    SV *	valuesv
    CODE:
    D_dbihcom(sth);
    D_imp_sth;
    imp_dbh_t *dbh = imp_sth->imp_dbh;
    STRLEN kl;
    char *key = SvPV(keysv,kl);
    SV *retsv = NULL;
    /* Default to caching results for DBI dispatch quick_FETCH	*/
    int cacheit = TRUE;

    dbh = dbh; 	/* avoid unused warning */

    if (kl==8 && strEQ(key, "ora_long")){
	imp_sth->long_buflen = SvIV(valuesv);

    } else if (kl==9 && strEQ(key, "ora_trunc")){
	/* Ignore SvTRUE warning: '=' where '==' may have been intended. */
	imp_sth->long_trunc_ok = SvTRUE(valuesv);

    } else {
	warn("STORE st %s %s NOT IMPLEMENTED YET\n",SvPV(sth,na),key);
	XSRETURN_UNDEF;
    }
    if (cacheit && retsv) /* cache value for later fetch? */
	hv_store((HV*)SvRV(sth),key,kl,retsv,0);
    XST_mUNDEF(0);



void
FETCH(sth, keysv)
    SV *	sth
    SV *	keysv
    CODE:
    D_dbihcom(sth);
    D_imp_sth;
    STRLEN kl;
    char *key = SvPV(keysv,kl);
    int i;
    SV *retsv = NULL;
    /* Default to caching results for DBI dispatch quick_FETCH	*/
    int cacheit = TRUE;

    if (!imp_sth->done_desc && dbd_describe(sth, imp_sth)){
        XSRETURN_UNDEF;	/* dbd_describe called do_error()	*/
    }

    i = imp_sth->fbh_num;

    if (kl==11 && strEQ(key, "ora_lengths")){
	AV *av = newAV();
	retsv = newRV((SV*)av);
	while(--i >= 0)
	    av_store(av, i, newSViv((IV)imp_sth->fbh[i].dsize));

    } else if (kl==9 && strEQ(key, "ora_types")){
	AV *av = newAV();
	retsv = newRV((SV*)av);
	while(--i >= 0)
	    av_store(av, i, newSViv(imp_sth->fbh[i].dbtype));

    } else if (kl==9 && strEQ(key, "NumParams")){
	HV *bn = imp_sth->bind_names;
	retsv = newSViv( (bn) ? HvKEYS(bn) : 0 );

    } else if (kl==4 && strEQ(key, "NAME")){
	AV *av = newAV();
	retsv = newRV((SV*)av);
	while(--i >= 0)
	    av_store(av, i, newSVpv(imp_sth->fbh[i].cbuf,0));

    } else {
	warn("FETCH st %s %s NOT IMPLEMENTED YET\n",SvPV(sth,na),key);
	XSRETURN_UNDEF;
    }
    if (cacheit) /* cache for next time */
	hv_store((HV*)SvRV(sth),key,kl,retsv,0);
    ST(0) = sv_mortalcopy(retsv);


void
finish(sth)
    SV *	sth
    CODE:
    D_dbihcom(sth);
    D_imp_sth;
    /* Cancel further fetches from this cursor.			*/
    /* We don't close the cursor till DESTROY.			*/
    if ( ( imp_sth->is_insert != 1 ) && ( imp_sth->is_create != 1 ) )
        msqlFreeResult( imp_sth->cda );
    imp_sth->flags &= ~IMP_STH_EXECUTING;
    XST_mYES(0);


void
DESTROY(sth)
    SV *	sth
    CODE:
    dbd_st_destroy(sth);

# end of mSQL.xs
