#   $Id: mSQL.pm,v 1.16 1995/06/22 00:37:04 timbo Rel $
#
#   Copyright (c) 1994,1995 Tim Bunce
#
#   You may distribute under the terms of either the GNU General Public
#   License or the Artistic License, as specified in the Perl README file.

{
    package DBD::mSQL;

    require DBI;

    require DynaLoader;
    @ISA = qw(DynaLoader);

	$VERSION = substr(q$Revision: 1.16 $, 10);

    bootstrap DBD::mSQL;

    unless ($ENV{'MSQL_HOME'}){
	foreach(qw(/usr/mSQL /opt/mSQL)){
	    $ENV{'MSQL_HOME'}=$_,last if -d "$_/lib";
	}
	die "Unable to determine MSQL_HOME" unless $ENV{'MSQL_HOME'};
	warn "MSQL_HOME set to $ENV{'MSQL_HOME'}\n";
    }

    $drh = undef;	# holds driver handle once initialised
    $err = 0;		# holds error code   for DBI::err
    $errstr = "";	# holds error string for DBI::errstr

    sub driver{
	return $drh if $drh;
	my($class, $attr) = @_;
	$class .= "::dr";
	($drh) = DBI::_new_drh($class, {
	    'Name' => 'mSQL',
	    'Version' => $VERSION,
	    'Attribution' => 'mSQL DBD by Alligator Descartes',
	    });
	$drh;
    }

    1;
}


{   package DBD::mSQL::dr; # ====== DRIVER ======
    use strict;

    sub errstr {
	DBD::mSQL::errstr(@_);
    }

    sub connect {
	my($drh, $host, $dbname)= @_;

	# Call mSQL OCI orlon func in mSQL.xs file.
	# Store returned structure pointer as private data
	# in the $dbh created by DBI::_new_dbh() below.

	my $imp_dbh = dbd_dr_login($drh, $host, $dbname) or return undef;

	my($this) = DBI::_new_dbh($drh, {
	    'Err'    => \$DBD::mSQL::err,
	    'Errstr' => \$DBD::mSQL::errstr,
	    'Name' => $dbname,
            'Host' => $host,
	    }, $imp_dbh);
	$this;
    }

}


{   package DBD::mSQL::db; # ====== DATABASE ======
    use strict;

    sub errstr {
	DBD::mSQL::errstr(@_);
    }

    sub prepare {
	my($dbh, $statement)= @_;

	# Call mSQL OCI oparse func in mSQL.xs file.
	# (This will actually also call oopen for you.)
	# Store returned structure pointer as private data
	# in the $sth created by DBI::_new_sth() below.

	my $imp_sth = dbd_db_prepare($dbh, $statement) or return undef;

	my($outer, $sth) = DBI::_new_sth($dbh, {
	    'Statement' => $statement,
	    }, $imp_sth);
	$outer;
    }

}


{   package DBD::mSQL::st; # ====== STATEMENT ======
    use strict;

    sub errstr {
	DBD::mSQL::errstr(@_);
    }
}

1;
