/*
 *	Copyright (c) 1993-1996 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	BPFT $Id: trafshow.h,v 2.0 1996/01/15 20:01:08 bob Exp $
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 * Redistribution in binary form may occur without any restrictions.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

/*
 * Screen refresh interval in seconds
 */
#define	DEFAULT_SCR	5

/*
 * Offset on screen for ferst line
 */
#define	SCR_OFFS	2

/*
 * Max pages on screen
 */
#define	MAX_PAGES	10

/*
 * Show in ANSI colors
 */
#define	NICECOLOR	"\033[0m\033[1;33;44m\033[H\033[J"

/*
 * Default screen colors
 */
#define	DEFCOLOR	"\033[0;37;40m\033[H\033[J"

/*
 * Keyboard functions
 */
#define	ctrl(c)		((c) & 0x1F)
#define	ESC		'\033'
#define	CR		'\r'
#define	NL		'\n'
#define	BS		'\b'

/*
 *  used by get_arrow_key()
 */
#define	KEYMAP_UNKNOWN		0
#define	KEYMAP_UP		1
#define	KEYMAP_DOWN		2
#define	KEYMAP_LEFT		3
#define	KEYMAP_RIGHT		4
#define	KEYMAP_PAGE_UP		5
#define	KEYMAP_PAGE_DOWN	6
#define	KEYMAP_HOME		7
#define	KEYMAP_END		8
#define	KEYMAP_INS		9
#define	KEYMAP_F1		10
#define	KEYMAP_F2		11
#define	KEYMAP_F3		12
#define	KEYMAP_F4		13


#ifndef	IPPROTO_OSPF
#define	IPPROTO_OSPF	89
#endif
#ifndef	IPPROTO_IGMP
#define	IPPROTO_IGMP	2
#endif

extern unsigned char *snapend;
extern char *device_name;
extern int alarm_flag;
extern int scr_interval;
extern int n_entry;		/* counter for number of records */
extern int kflag;
extern int nflag;
extern int Nflag;
extern int page_size;
