/*
 *	Copyright (c) 1993 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	BPFT $Id: interfaces.c,v 1.1 1993/10/20 16:03:56 bob Exp $
 *
 *	$Log: interfaces.c,v $
 * Revision 1.1  1993/10/20  16:03:56  bob
 * Initial revision
 *
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 * Redistribution in binary form may occur without any restrictions.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <net/slip.h>
#include <net/if_slvar.h>
#include <net/ppp_proto.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
#include <netinet/tcp.h>
#include <netinet/tcpip.h>
#include <net/bpf.h>

#include "interface.h"

u_char *packetp;
u_char *snapend;

/*
 * Here defined hardware depended funtions table.
 */
static struct if_func {
	void (*f)();
	int type;
} if_funcs[] = {
	{	bpf_ether,	DLT_EN10MB	},
	{	bpf_slip,	DLT_SLIP	},
	{	bpf_ppp,	DLT_PPP		},
	{	bpf_null,	DLT_NULL	},
	{ 0, 0 },
};

/*
 * Assign data link type to interface function.
 */
void
(*link_func())()
{
	struct if_func *p;

	for (p = if_funcs; p->f; ++p)
		if (link_type == p->type)
			return p->f;
	error("unknown data link type 0x%x", link_type);
}

/*
 * This is the interface depended routines for ethernet, slip, ppp and lo.
 * Use as (*usage_func)();
 *
 *	'p' is the points to the packet,
 *	'length' is the length of the packet,
 *	'caplen' is the number of bytes actually captured.
 *
 * WARNING:
 * processing_ip() is the user's function, see interface.h for more details.
 */
void
bpf_ether(p, length, caplen)
	u_char *p;
	int length;
	int caplen;
{
	struct ether_header *ep;
	register int i;

	if (caplen < sizeof(struct ether_header))
		return;
	packetp = p;
	snapend = p + caplen;
	length -= sizeof(struct ether_header);
	ep = (struct ether_header *)p;
	p += sizeof(struct ether_header);
	if ((ntohs(ep->ether_type)) == ETHERTYPE_IP)
		processing_ip((struct ip *)p, length);
}

void
bpf_slip(p, length, caplen)
	u_char *p;
	int length;
	int caplen;
{
	struct ip *ip;

	if (caplen < SLIP_HDRLEN)
		return;
	packetp = (u_char *)p;
	snapend = (u_char *)p + caplen;
	length -= SLIP_HDRLEN;
	ip = (struct ip *)(p + SLIP_HDRLEN);
	processing_ip(ip, length);
}

void
bpf_ppp(p, length, caplen)
	u_char *p;
	int length;
	int caplen;
{
	struct ip *ip;
	int hdrlength;
	u_short type;

	/*
	 * Thanks to Gregory J. Miller <gmiller@gateway.mitre.org> for
	 * help of true PPP header parsing.
	 */
	if (caplen < sizeof(struct ppp_header))
		return;
	packetp = (u_char *)p;
	snapend = (u_char *)p + caplen;
	hdrlength = 0;
	if (p[0] == PPP_ADDRESS && p[1] == PPP_CONTROL)
		p += 2, hdrlength = 2;
	/* Retrive the protocol type */
	if (*p & 01) {	/* Compressed protocol field */
		type = *p++;
		hdrlength++;
	} else {	/* Un-compressed protocol field */
		type = ntohs(*(u_short *)p);
		p += 2;
		hdrlength += 2;
	}
	length -= hdrlength;
	switch (type) {
	case PPP_IP:
		ip = (struct ip *)p;
		processing_ip(ip, length);
		break;
	}
}

#define	NULL_HDRLEN 4

void
bpf_null(p, length, caplen)
	u_char *p;
	int length;
	int caplen;
{
	struct ip *ip;
  	u_int family;

	bcopy(p, &family, sizeof(family));

	packetp = (u_char *)p;
	snapend = (u_char *)p + caplen;

	length -= NULL_HDRLEN;

	ip = (struct ip *)(p + NULL_HDRLEN);

	switch (family) {
	case AF_INET:
		processing_ip(ip, length);
		break;
	}
}
