/* p11 - pdp11 emulator; Copyright (C) 1994 Hartmut Brandt, Joerg Micheel 
 * see the file LICENSE for further information */

/*
 * fast block move, addresses are aligned on 16bit boundaries
 * It turns out that this isn't faster than bcopy!
# define CopyW(T,F,C)	asm("cld; 			\
			     movl %2, %%ecx;		\
			     andl $1, %2;		\
			     shrl $1, %%ecx;		\
			     rep; movsl;		\
			     movl %2, %%ecx;		\
			     rep; movsw"		\
			   : : "D"(T), "S"(F), "r"(C) : "ecx")
 */
# define CopyW(T,F,C)	bcopy((F), (T), (C) << 1)

/************************************************************
 *
 * processor emulation
 */

/*
 * Test word/byte and set N and Z
 */
# define TestW(V)	asm("testw %2, %2; setz %0; sets %1" 		\
			   : "=g"(proc.z), "=g"(proc.n) 		\
			   : "r"((short)V) : "cc")
# define TestB(V)	asm("testb %2, %2; setz %0; sets %1" 		\
			   : "=g"(proc.z), "=g"(proc.n) 		\
			   : "q"(V) : "cc")

/*
 * compare words/bytes and set NZCV
 */
# define CmpW(D,S)	asm("subw %4, %5; setz %0; sets %1; setb %2; seto %3" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=g"(proc.v) \
			   : "r"((short)D), "r"((short)S) : "cc")
# define CmpB(D,S)	asm("subb %4, %5; setz %0; sets %1; setb %2; seto %3" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=g"(proc.v) \
			   : "q"(D), "q"(S) : "cc")

/*
 * sub/add words/bytes and set NZCV
 */
# define SubWC(D,S)	asm("subw %6, %5; setz %0; sets %1; setb %2; seto %3" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=g"(proc.v), "=r"(D) \
			   : "4"((short)D), "g"((short)S) : "cc")
# define AddWC(D,S)	asm("addw %6, %5; setz %0; sets %1; setb %2; seto %3" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=g"(proc.v), "=r"(D) \
			   : "4"((short)D), "g"((short)S) : "cc")
# define SubBC(D,S)	asm("subb %%dl, %%al; setz %0; sets %1; setb %2; seto %3" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=q"(proc.v), "=a"(D) \
			   : "4"(D), "d"(S) : "cc")
# define AddBC(D,S)	asm("addb %%dl, %%al; setz %0; sets %1; setb %2; seto %3" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=q"(proc.v), "=a"(D) \
			   : "4"(D), "d"(S) : "cc")

/*
 * sub/add words/bytes and set NZV
 */
# define SubW(D,S)	asm("subw %5, %4; setz %0; sets %1; seto %2" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.v), "=g"(D) \
			   : "3"((short)D), "r"((short)S) : "cc")
# define AddW(D,S)	asm("addw %5, %4; setz %0; sets %1; seto %2" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.v), "=g"(D) \
			   : "3"((short)D), "r"((short)S) : "cc")
# define SubB(D,S)	asm("subb %%dl, %%al; setz %0; sets %1; seto %2" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.v), "=a"(D) \
			   : "3"(D), "d"(S) : "cc")
# define AddB(D,S)	asm("addb %%dl, %%al; setz %0; sets %1; seto %2" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.v), "=a"(D) \
			   : "3"(D), "d"(S) : "cc")

# define SwabB(D)	asm("xchgb %%al, %%ah" : "=a"(D) : "0"((short)D) : "cc");

/*
 * this is a workaround for a bug in cc1
# define SCHAR(S)	({ ushort _tm1 = (S); (sshort)(schar)_tm1; })
*/
# define SCHAR(S)	((sshort)(schar)(S))


# define Div(v1,v2,v,d)	asm("cltd; idivl %3"		\
		   	   : "=a"(v1), "=d"(v2)		\
		   	   : "0"(v), "g"(d))
