/*
 * Routines for displaying current line settings and prompting for changes.
 */

#include <stdio.h>
#include <oldcurses.h>
#include "dial_dir.h"
#include "misc.h"
#include "param.h"

static void disp_settings();

/*
 * Display the current line settings and prompt for changes.  A non-zero
 * return code means settings were changed.
 */

int
ls_menu()
{
	extern int fd;
	WINDOW *l_win, *newwin();
	int num, ret_code;

	l_win = newwin(21, 47, 0, 16);

	mvwattrstr(l_win, 1, 16, A_BOLD, "Line Settings");
	horizontal(l_win, 2, 0, 47);
	mvwaddstr(l_win, 6, 5, "1)    1200,E,7,1     8)    1200,N,8,1");
	mvwaddstr(l_win, 7, 5, "2)    2400,E,7,1     9)    2400,N,8,1");
	mvwaddstr(l_win, 8, 5, "3)    4800,E,7,1    10)    4800,N,8,1");
	mvwaddstr(l_win, 9, 5, "4)    9600,E,7,1    11)    9600,N,8,1");
	mvwaddstr(l_win, 10, 5, "5)   19200,E,7,1    12)   19200,N,8,1");
	mvwaddstr(l_win, 11, 5, "6)   38400,E,7,1    13)   38400,N,8,1");
	mvwaddstr(l_win, 12, 5, "7)   57600,E,7,1    14)   57600,N,8,1");
	mvwaddstr(l_win, 14, 4, "Parity        Data Bits       Stop Bits");
	mvwaddstr(l_win, 15, 4, "15) Odd       16) 7 bits      18) 1 bit");
	mvwaddstr(l_win, 16, 18, "17) 8 bits      19) 2 bits");
	mvwaddstr(l_win, 18, 4, "20) Save Changes");
	mvwattrstr(l_win, 18, 28, A_BOLD, "YOUR CHOICE:");
	wmove(l_win, 18, 41);
	box(l_win, VERT, HORZ);

	mvwaddstr(l_win, 20, 13, " Press <ESC> to return ");
					/* display current settings */
	disp_settings(l_win);
	wmove(l_win, 18, 41);
	wrefresh(l_win);
					/* get the options */
	ret_code = 0;
	while ((num = get_num(l_win, 2)) != -1) {
		switch (num) {
			case 1:
				dir->baud[0] = 1200;
				dir->parity[0] = 'E';
				dir->data_bits[0] = 7;
				dir->stop_bits[0] = 1;
				break;
			case 2:
				dir->baud[0] = 2400;
				dir->parity[0] = 'E';
				dir->data_bits[0] = 7;
				dir->stop_bits[0] = 1;
				break;
			case 3:
				dir->baud[0] = 4800;
				dir->parity[0] = 'E';
				dir->data_bits[0] = 7;
				dir->stop_bits[0] = 1;
				break;
			case 4:
				dir->baud[0] = 9600;
				dir->parity[0] = 'E';
				dir->data_bits[0] = 7;
				dir->stop_bits[0] = 1;
				break;
			case 5:
				dir->baud[0] = 19200;
				dir->parity[0] = 'E';
				dir->data_bits[0] = 7;
				dir->stop_bits[0] = 1;
				break;
			case 6:
				dir->baud[0] = 38400;
				dir->parity[0] = 'E';
				dir->data_bits[0] = 7;
				dir->stop_bits[0] = 1;
				break;
			case 7:
				dir->baud[0] = 57600;
				dir->parity[0] = 'E';
				dir->data_bits[0] = 7;
				dir->stop_bits[0] = 1;
				break;
			case 8:
				dir->baud[0] = 1200;
				dir->parity[0] = 'N';
				dir->data_bits[0] = 8;
				dir->stop_bits[0] = 1;
				break;
			case 9:
				dir->baud[0] = 2400;
				dir->parity[0] = 'N';
				dir->data_bits[0] = 8;
				dir->stop_bits[0] = 1;
				break;
			case 10:
				dir->baud[0] = 4800;
				dir->parity[0] = 'N';
				dir->data_bits[0] = 8;
				dir->stop_bits[0] = 1;
				break;
			case 11:
				dir->baud[0] = 9600;
				dir->parity[0] = 'N';
				dir->data_bits[0] = 8;
				dir->stop_bits[0] = 1;
				break;
			case 12:
				dir->baud[0] = 19200;
				dir->parity[0] = 'N';
				dir->data_bits[0] = 8;
				dir->stop_bits[0] = 1;
				break;
			case 13:
				dir->baud[0] = 38400;
				dir->parity[0] = 'N';
				dir->data_bits[0] = 8;
				dir->stop_bits[0] = 1;
				break;
			case 14:
				dir->baud[0] = 57600;
				dir->parity[0] = 'N';
				dir->data_bits[0] = 8;
				dir->stop_bits[0] = 1;
				break;
			case 15:
				dir->parity[0] = 'O';
				break;
			case 16:
				dir->data_bits[0] = 7;
				break;
			case 17:
				dir->data_bits[0] = 8;
				break;
			case 18:
				dir->stop_bits[0] = 1;
				break;
			case 19:
				dir->stop_bits[0] = 2;
				break;
			case 20:
					/* copy the current settings */
				param->d_baud = dir->baud[0];
				param->d_parity = dir->parity[0];
				param->d_data_bits = dir->data_bits[0];
				param->d_stop_bits = dir->stop_bits[0];
				/*
				 * We've changed the values in memory even
				 * if the update fails.
				 */
				if (up_param()) {
					touchwin(l_win);
					wrefresh(l_win);
				}
				break;
			default:
				beep();
		}
		ret_code++;
		disp_settings(l_win);
		mvwaddstr(l_win, 17, 41, "    ");
		wmove(l_win, 18, 41);
		wrefresh(l_win);
	}
	if (fd == -1) {
		werase(l_win);
		wrefresh(l_win);
	}
	delwin(l_win);
	return(ret_code);
}

/*
 * Display the current settings.  Formats the entire string at one
 * time, in case you've got a magic cookie terminal.
 */

static void
disp_settings(win)
WINDOW *win;
{
	extern int xmc;
	char buf[40];

	sprintf(buf, "Current Settings: %5d,%c,%d,%d", dir->baud[0],
	 dir->parity[0], dir->data_bits[0], dir->stop_bits[0]);

	if (xmc > 0) {
		touchwin(win);
		clear_line(win, 4, 8, TRUE);
		wrefresh(win);
	}
	mvwattrstr(win, 4, 8, A_BOLD, buf);
	return;
}
