/***************************************************************************/
/*  Module:      $Id: daemon.c,v 1.3 1995/05/24 00:46:49 maf Exp $
/*  Description: Daemon mode functions for sendpage
/*  Author:      maf
/*
/* Copyright (c) 1995 Mark Fullmer and The Ohio State University
/***************************************************************************/

/*
$Log: daemon.c,v $
 * Revision 1.3  1995/05/24  00:46:49  maf
 * all unknown string sizes use %.512s for report()
 *
 * Revision 1.2  1995/03/15  04:40:51  maf
 * *** empty log message ***
 *
 * Revision 1.1  1995/01/10  01:42:27  maf
 * Initial revision
 *
*/

#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <limits.h>
#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <string.h>
#include <fcntl.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/param.h>
#include <db.h>
#include <sys/uio.h>
#include "report.h"
#include "sendpage.h"

#ifdef NEED_MALLOC_H
#include <malloc.h>
#endif

/*********************************************************************/
/* Function: BeADeamon()
/*	implements the daemon mode of sendpage
/*
/*	Returns:	0	good
/*				!0	bad
/*
/*	records pid file, fork()'s, sets up flags to have config file
/*	read, sets up signal handlers, etc.  Attempts to prevent two 
/*	copies of sendpage running by sending a signal to the pid listed
/*	in PATH_SENDPAGE_PIDFILE
/*
/*********************************************************************/
BeADaemon()
{

	extern int	need_readconfig, need_runqueue;
	extern int errno, debug;
	pid_t pid;
	int n;
	u_int pid2;
	FILE *FP;

	pid2 = 0;

	/* First check to make sure sendpage is not allready running */
	if ((FP = fopen(PATH_SENDPAGE_PIDFILE, "r"))) {

		fscanf(FP, "%u", &pid2);
		fclose(FP);

		if (pid2 && (!kill((int)pid2, 0))) {
			report_init(0);
			report (LOG_ERR, "sendpage allready running as pid %u", pid2);
			return 1;
		} /* pid2 */
	} 

	/* need to read config file */
	need_readconfig = 1;

	/* need to check queue */
	need_runqueue = 1;

	/* Handle SIGHUP */
	signal(SIGHUP, sig_hup);

	/* Handle SIGUSR1 */
	signal(SIGUSR1, sig_usr1);

	/* Handle SIGALRM */
	signal(SIGALRM, sig_alrm);

	/* Handle SIGQUIT */
	signal(SIGQUIT, sig_quit);

	/* Handle SIGPIPE */
	signal(SIGPIPE, sig_pipe);

	if (debug > 2)
		goto skipfork;

	if ((pid = fork()) == -1) {
		report_init(0);
		report(LOG_ERR, "Can't fork() to become daemon: %s", strerror(errno));
		return 1; 
	} else if (pid) /* parent exits here */
		exit (0);

	/* child... */

	/* set reasonable umask */
	umask(0022);

	/* become a session leader */
	setsid();

	/* close open fd'd (atleast NOFILE of them) */
	for (n = 0; n < NOFILE; ++n)
		close(n);

	/* need to call report_init */
	report_init(0);

skipfork:

	FP = (FILE*)NULL;

	if ((FP = fopen(PATH_SENDPAGE_PIDFILE, "w"))) {
		fprintf(FP, "%u\n", (unsigned)getpid());
		fclose(FP);
	} else {
		report (LOG_ERR, "Can't open pidfile %.512s", PATH_SENDPAGE_PIDFILE);
	}

	report (LOG_INFO, "daemon started");

	return 0;

} /* BeADaemon */

