/***************************************************************************/
/*  Module:      $Id: verify.c,v 1.2 1995/03/15 04:41:09 maf Exp $
/*  Description: Verify mode of sendpage
/*  Author:      maf
/*
/* Copyright (c) 1995 Mark Fullmer and The Ohio State University
/***************************************************************************/

/*
$Log: verify.c,v $
 * Revision 1.2  1995/03/15  04:41:09  maf
 * *** empty log message ***
 *
 * Revision 1.1  1995/01/10  01:45:24  maf
 * Initial revision
 *
*/


#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <limits.h>
#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <string.h>
#include <fcntl.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <db.h>
#include "report.h"
#include "sendpage.h"

#ifdef NEED_MALLOC_H
#include <malloc.h>
#endif

/*********************************************************************/
/* Function: VerifyMode
/*	implements a high level interface to verifying aliases, and this the
/*	sendpage config file were read
/*
/*	aliasdb and pcdb should be setup by ReadConfig() before calling this.
/*
/*	returns 0	good
/*			!0	bad
/*
/*	errors are reported to stderr
/*
/*********************************************************************/
VerifyMode(aliasdb, pcdb)
DB *aliasdb, *pcdb;
{

	struct dynstring aliaslist;
	DBT dbkey, dbval;
	struct linebuf linebuf;
	int err;
	int len, r;
	char *p;
	extern int debug;
	

	bzero(&aliaslist, sizeof aliaslist);
	bzero(&linebuf, sizeof linebuf);
	err = 1;							/* bad */

	if (!aliasdb) {
		printf("Error, alias database not initialized.\n");
		goto VerifyModeout;
	}
	if (!pcdb) {
		printf("Error, paging central database not initialized.\n");
		goto VerifyModeout;
	}

	printf("\nsendpage verify mode\nEnter address\n");

	while (1) {

		if ((r = GetLine(STDIN_FILENO, &linebuf)) == -1) {
			fprintf(stderr, "GetLine() failed\n");
			goto VerifyModeout;
		}

		/* exit loop EOF */
		if (r == 1)
			break;

		/* skip blank and comment lines */
		if (!linebuf.len2)
			continue;

		dbkey.data = linebuf.buf;
		dbkey.size = linebuf.len2;

		aliaslist = AliasExpand(aliasdb, dbkey);

		if (aliaslist.bufused == -1)  {
			fprintf(stderr, "AliasExpand() returned an error condition\n");
			goto VerifyModeout;
		}

		if (!aliaslist.bufused) {
			printf("---> no expansion\n");
			continue;
		}

		printf("---> ");
		p = aliaslist.buf;
		for (; (len = strlen(p)); p += len+1)
			printf("%s ", p);

		printf("\n");

		if (aliaslist.buf)
			free (aliaslist.buf);

#ifdef DEBUG
#ifdef SYSV_MALLOC
	if (debug > 10) 
		PrintMallinfo(mallinfo());
#endif /* SYSV_MALLOC */
#endif /* DEBUG */
	} /* while 1*/

	err = 0; /* good */

VerifyModeout:

	if (linebuf.buf)
		free (linebuf.buf);

	return err;
		
} /* VerifyMode */
