/***************************************************************************/
/*  Module:      $Id: testpet.c,v 1.4 1995/08/28 02:38:05 maf Exp $
/*  Description: PET protocol test code - part of sendpage
/*  Author:      maf
/*
/* Copyright (c) 1995 Mark Fullmer and The Ohio State University
/***************************************************************************/

/*
$Log: testpet.c,v $
 * Revision 1.4  1995/08/28  02:38:05  maf
 * PET1 should of been default
 *
 * Revision 1.3  1995/05/24  00:48:02  maf
 * pcinfo.password not set
 *
 * Revision 1.2  1995/03/15  04:41:07  maf
 * *** empty log message ***
 *
 * Revision 1.1  1995/01/10  01:45:10  maf
 * Initial revision
 *
*/

#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <limits.h>
#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <string.h>
#include <fcntl.h>
#include <termios.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include "report.h"
#include "sendpage.h"

#ifdef NEED_MALLOC_H
#include <malloc.h>
#endif

int debug;
char *progname;

main(argc, argv)
int argc;
char **argv;
{

	extern int optind, opterr;
	extern char *optarg;
	extern char *progname;
	int x;
	char *recipient, *message;
	int mfd;
	struct cbuf cbuf;
#ifdef UUCP_LOCKING
	int gotuucplock = 0;
#endif /* UUCP_LOCKING */
	struct pcinfo pcinfo;

	recipient = message = (char*)NULL;
	debug = 0; 				/* debugging off by default */
	bzero(&cbuf, sizeof cbuf);
	mfd = -1;

	/* setup a default pcinfo struct */
	pcinfo.id = 0;
	pcinfo.dialer = DIALER_INTERNAL;
	pcinfo.name[0] = 0;
	pcinfo.phone[0] = 0;
	strcpy(pcinfo.modeminit, MODEM_INIT);
	strcpy(pcinfo.modemdev, MODEM_DEV);
	strcpy(pcinfo.modemdial, MODEM_DIAL);
	pcinfo.answertime = 25;
	pcinfo.parity = PARENB;
	pcinfo.speed = B1200;
	pcinfo.databits = CS7;
	pcinfo.protocol = PC_PET1;
	pcinfo.msgretries = 30;
	strcpy(pcinfo.password, "000000");

	progname = strrchr(argv[0], '/');
	if (progname)
		progname ++;
	else
		progname = argv[0];

	/* initialize logging - borrowed from CMU's bootpd */
	report_init (0);

	/* p = dialing string 
	/* r = recipient pin 
	/* m = message 
	/* d = debug level */

	while ((x = getopt(argc, argv, "p:r:m:d:")) != -1) 
		switch (x) {

		case 'd':
			debug = atoi(optarg);
			break;

		case 'r':
			recipient = optarg;
			break;

		case 'm':
			message = optarg;
			break;

		case 'p':
			if ((strlen(optarg)+1) > PCINFO_STR_LEN) {
				fprintf(stderr, "phone # too long\n");
				exit (1);
			}
			strcpy(pcinfo.phone, optarg);
			break;

		case 'h':
			usage();
			exit (1);
			break;

		default:
			exit (1);

		} /* end switch */

	if ( !recipient || !message) {
		usage();
		exit (1);
	}

#ifdef UUCP_LOCKING
	/* try to lock the device */
	if (LockTTY(pcinfo.modemdev)) {
		fprintf(stderr, "can't lock modem device\n");
		exit (1);
	}
	gotuucplock = 1;
#endif /* UUCP_LOCKING */

	/* open and initialize the modem device */
	if (OpenModem(&pcinfo, &mfd))
		goto main_exit;

	/* reset the modem to a known state */
	if (ResetModem(mfd, &cbuf, &pcinfo))
		goto main_exit;

	/* Dial paging central */
	printf ("Dialing....\n");
	x = DialModem (mfd, &cbuf, &pcinfo);

	switch (x) {

		case MODEM_RES_C300:
		case MODEM_RES_C1200:
			report (LOG_INFO, "Connected");
			break;

		default:
			report (LOG_INFO, "Not connected - reason %d", x);
			exit(1);
	} /* switch */

	/* Start up the PET protocol */
	printf ("Starting up PET protocol\n");
	if (StartPET(mfd, &cbuf, &pcinfo))
		goto main_exit;

	/* Send the message */
	printf ("Sending message\n");
	if (SendPETTransaction(mfd, &cbuf, recipient, message))
		goto main_exit;

	/* End Transaction */
	printf ("Ending transaction\n");
	if (EndPETTransaction(mfd, &cbuf))
		goto main_exit;

	/* Hangup Modem */
	HangUpModem(mfd, &cbuf);


	printf ("Done!\n");

main_exit:

	if (mfd != -1)
		if (close(mfd) == -1) {
			fprintf(stderr, "close of modem device failed\n");
			exit (1);
		}

#ifdef UUCP_LOCKING
	if (gotuucplock)
		if (UnLockTTY(MODEM_DEV))
			fprintf(stderr, "unlock of modem device failed\n");
#endif /* UUCP_LOCKING */

} /* main */

usage() {

	fprintf(stderr, "usage: testpet -p phone -r recipient -m message [-d debuglevel]\n");
	fprintf(stderr, "\nexample: testpet -p \"98465504\" -r 999999 -m \"take a vacation\" -d99\n\n");
};
