/***************************************************************************/
/*  Module:      $Id: sendpage.c,v 1.4 1995/05/24 00:51:01 maf Exp $
/*  Description: sendpage main module
/*  Author:      maf
/*
/* Copyright (c) 1995 Mark Fullmer and The Ohio State University
/***************************************************************************/

/*
$Log: sendpage.c,v $
 * Revision 1.4  1995/05/24  00:51:01  maf
 * alpha 4
 * progname belongs here, not in sendpage.h
 *
 * Revision 1.3  1995/03/17  04:16:26  maf
 * upped version to alpha 3
 *
 * Revision 1.2  1995/03/15  04:40:56  maf
 * *** empty log message ***
 *
 * Revision 1.1  1995/01/10  01:44:23  maf
 * Initial revision
 *
*/

#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <limits.h>
#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <string.h>
#include <fcntl.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <db.h>
#include <pwd.h>
#include "report.h"
#include "sendpage.h"

#ifdef NEED_MALLOC_H
#include <malloc.h>
#endif

int debug;
int need_readconfig, need_runqueue, need_quit;
int alias_recurse_depth;
int	do_longjump;
int got_sigpipe;

char *versionID = "alpha 4 (May 23 1995)";

/* environment to pass children - used when fork()ing for sendmail 
/* and/or pipe style aliases */

char *sendpage_env[] = {

	"PATH=/bin:/usr/bin:/usr/ucb:",
	"SHELL=/bin/sh",
	0
};

char *progname;	

/*********************************************************************/
/* Function: main
/*	program sendpage 
/*
/* Returns: EX_OK	(0)	good
/*			!0			bad (return codes for client are set for use
/*						with sendmail.
/*
/*	usage:
/*		bv		verify alias mode
/*		bp		print queue - will also work if invoked as 'pageq'
/*		bd		run in daemon mode
/*		d:		set debug level
/*		f:		set sender, normally set with getpwuid(getuid)
/*		s		when in client mode, skip all messages up to the first
/*				blank line - for use with sendmail
/*		m:		limit # of messages.
/*		n		don't send mail response.
/*
/*********************************************************************/
main(argc, argv)
int argc;
char **argv;
{

	extern int optind, opterr;
	extern char *optarg;
	extern char *progname;
	int runmode;
	int skiptoblank, x, ret;
	char *sender;
	DB *aliasdb, *pcdb;
	u_int	ncentral;
	char nullstring[1];
	struct passwd *pwd;
	int maxmsgs, nomail;
	
	debug = 0; 				/* debugging off by default */
	skiptoblank = 0;		/* ignore all message lines until there is
							/* first a blank line */
	aliasdb = (DB*)0;
	pcdb = (DB*)0;
	nullstring[0] = 0;
	sender = nullstring;
	ret = 0; /* good */
	alias_recurse_depth = 0;/* for alias recursion loop testing */
	maxmsgs = 0;		/* allow infinate # of messages per invocation */
	nomail = 0;

	progname = strrchr(argv[0], '/');
	if (progname)
		progname ++;
	else
		progname = argv[0];

	if (!strcmp(progname, "pageq"))
		runmode = RUN_PRINTQUEUE;
	else if (!strcmp(progname, "sendpage"))
		runmode = RUN_CLIENT;
	else {
		fprintf(stderr, "sendpage: unknown mode (%s)\n", progname);
		exit (EX_SOFTWARE);
	}


	while ((x = getopt(argc, argv, "f:sd:b:m:nh?")) != -1) 

		switch (x) {

		case 'b':
			if (optarg[0] == 'd')
				runmode = RUN_DAEMON;
			else if (optarg[0] == 'p')
				runmode = RUN_PRINTQUEUE;
			else if (optarg[0] == 'v')
				runmode = RUN_VERIFY;
			else
				runmode = RUN_UNKNOWN;
			break;

		case 'd':
			debug = atoi(optarg);
			break;

		case 'm':
			maxmsgs = atoi(optarg);
			break;

		case 'n':
			nomail = 1;
			break;

		case 's':
			skiptoblank = 1;
			break;

		case 'f':
			sender = optarg;
			break;

		case '?':
		case 'h':
			Usage();
			exit (0);
			break;  /* not reached */

		default:
			Usage();
			exit (1);
			break;   /* not reached */

		} /* end switch */

	if (chdir(PATH_QUEUE) == -1) {
		perror(PATH_QUEUE);
		exit (EX_SOFTWARE);
	}

	/* initialize logging - borrowed from CMU's bootpd */
	/* the daemon code needs to start this itself sence it closes all fd's */

	if (runmode != RUN_DAEMON)
		report_init (0); 

	if (runmode == RUN_DAEMON) {

		if (BeADaemon()) {
			fprintf(stderr, "Daemon failed to start.\n");
			exit (1);
		}

		if (Deliver()) {
			fprintf(stderr,
				"Delivery code failure - Daemon failed to start.\n");
			exit (1);
		}

	} else if (runmode == RUN_PRINTQUEUE) {

		PrintMessageQueue();
		exit (1);

	} else if (runmode == RUN_CLIENT) {

		/* try to set the sender if it's not allready set */
		if (!sender[0]) 
			if ((pwd = (struct passwd*)getpwuid(getuid())))
				sender = pwd->pw_name;
		
		ret = BeAClient(argc, argv, optind, skiptoblank, sender, 1, maxmsgs,
			nomail);

	} else if (runmode == RUN_VERIFY) {

		if (ReadConfig(&aliasdb, &pcdb, &ncentral, PATH_SENDPAGE_CONFIG)) {
			fprintf(stderr, "ReadConfig() failed\n");
			exit (1);
		}
		ret = VerifyMode(aliasdb, pcdb);

	}

	return ret;

} /* main */

Usage() {

	fprintf(stderr, "sendpage usage:\n\n");
	fprintf(stderr, " -bv   verify alias mode\n");
	fprintf(stderr, " -bd   run in daemon mode\n");
	fprintf(stderr,
		" -bp   print queue - will also work if invoked as 'pageq'\n");
	fprintf(stderr,
		" -d n  set debug level to n\n");
	fprintf(stderr,
		" -f s  set sender to s, normally set with getpwuid(getuid)\n");
	fprintf(stderr,
		" -s    when in client mode, skip all messages up to the first blank line\n");
	fprintf(stderr, " -m n  limit to n messages\n");
	fprintf(stderr, " -n    don't send mail response\n");

	fprintf(stderr, "\n\n");

} /* Usage */

