/*   
	t3d

Flying Balls Demo for X
by Georg Acher , acher@informatik.tu-muenchen.de
(developed on HP9000/720 (55 MIPS,20 MFLOPS) )
NO warranty at all ! Complaints to /dev/null !

Clock Demo for X
by Bernd Paysan , paysan@informatik.tu-muenchen.de
*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <stdlib.h>
/* #include <unistd.h>*/
#include <stdio.h>
#include <math.h>
/* #include <time.h>*/
#include "patchlevel.h"

int maxk=34;

#define   WIDTH      200
#define   HEIGHT     200
#define   norm       20.0

int timewait=40000;

#define   ROOT       0x1
#define PI M_PI
#define TWOPI 2*M_PI

#define kmax ((minutes?60:24))
/* Anzahl der Kugeln */
#define sines 52
/* Werte in der Sinus-Tabelle */
/*-----------------------------------------------------------------*/
#define setink(inkcolor) \
	XSetForeground (dpy,gc,inkcolor)

#define drawline(xx1,yy1,xx2,yy2) \
	XDrawLine(dpy,win,gc,xx1,yy1,xx2,yy2) 

#define drawseg(segments,nr_segments) \
	XDrawSegments(dpy,win,gc,segments,nr_segments) 


#define polyfill(ppts,pcount) \
	XFillPolygon(dpy,win,gc,ppts,pcount,Convex,CoordModeOrigin)


#define frac(argument) argument-floor(argument)

#define abs(x) ((x)<0.0 ? -(x) : (x))

Colormap cmap;
XColor gray1;
double r=1.0,g=1.0,b=1.0;
double hue=0.0,sat=0.0,val=1.0;

typedef struct {
double x,y,z,r,d,r1;
int x1,y1;
} kugeldat;

/* Felder fuer 3D */

kugeldat kugeln[100];

double  a[3],m[3],am[3],x[3],y[3],v[3];
double zoom,speed,zaehler,vspeed,AE;
double vturn,aturn;
XPoint track[sines];
double sinus[sines];
double cosinus[sines];

int startx,starty;
double magx,magy,mag=10;
double lastx,lasty,lastz;
int lastcx,lastcy,lastcz;
/* int move=1; */
int minutes=0;
int cycl=0;
double hsvcycl=0.0;
double movef =0.5, wobber=2.0, cycle=6.0;

/* time */

double sec;

/* Windows */
GC	gc;
GC orgc;
GC andgc;
Window	win;
Font font;
Display	*dpy;
int	screen, scrnWidth = WIDTH, scrnHeight = HEIGHT;
Pixmap  buffer;
#define maxfast 100
int fastch=40;
#ifdef FASTDRAW
#	ifdef FASTCOPY
#		define sum1ton(a) (((a)*(a)+1)/2)
#		define fastcw sum1ton(fastch)
		Pixmap fastcircles;
		Pixmap fastmask;
#	else
		XImage* fastcircles[maxfast];
		XImage* fastmask[maxfast];
#	endif
#endif

int fastdraw=0;
int scrnW2,scrnH2;
unsigned short flags = 0;
char *text;
XColor colors[64];
struct tm *zeit;

int planes;
/* compute time */

double gettime ()
{
	struct timeval time1;
	struct timezone zone1;
	struct tm *zeit;

	gettimeofday(&time1,&zone1);
	zeit=localtime(&time1.tv_sec);

	return (zeit->tm_sec+60*(zeit->tm_min+60*(zeit->tm_hour))
			  + time1.tv_usec*1.0E-6);

}

/* --------------------COLORMAP---------------------*/ 

void hsv2rgb(h, s, v, r, g, b)
double h, s, v, *r, *g, *b;
{
	h/=360.0;	h=6*(h-floor(h));

	if(s==0.0)
	{
		*r=*g=*b=v;
	}
	else
	{	int i=(int)h;
		double t,u,w;

		h=h-floor(h);

		u=v*(s*(1.0-h));
		w=v*(1.0-s);
		t=v*(s*h+1.0-s);

		switch(i)
		{
			case 0:	*r=v;	*g=t;	*b=w;	break;
			case 1:	*r=u;	*g=v;	*b=w;	break;
			case 2:	*r=w;	*g=v;	*b=t;	break;
			case 3:	*r=w;	*g=u;	*b=v;	break;
			case 4:	*r=t;	*g=w;	*b=v;	break;
			case 5:	*r=v;	*g=w;	*b=u;	break;
		}
	}
#ifdef PRTDBX
	printf("HSV: %f %f %f to\nRGB: %f %f %f\n",h,s,v,*r,*g,*b);
#endif
}

void changeColor (r, g, b)
double r,g,b;
{
	int n,n1;

	n1=0;
	for(n=30;n<64;n+=3)
	{
		colors[n1].red   =1023+ n*(int)(1024.*r);
		colors[n1].blue  =1023+ n*(int)(1024.*b);
		colors[n1].green =1023+ n*(int)(1024.*g);

		n1++;
	}

	if (!(XStoreColors (dpy, cmap, colors, 12)))
	{
   	(void) fprintf (stderr, "Error:  Cannot set colors\n");
   	exit (1);
	}
}

void initColor (r, g, b)
double r,g,b;
{
	int n,n1;
	unsigned long pixels[12];
	long dummy;

   cmap = DefaultColormap (dpy, screen);

	if(hsvcycl!=0.0 && XAllocColorCells(dpy, cmap, 0, &dummy, 0, pixels, 12))
	{
		for(n1=0;n1<12;n1++)
		{
			colors[n1].pixel=pixels[n1];
			colors[n1].flags=DoRed | DoGreen | DoBlue;
		}

		changeColor(r,g,b);
	}
	else
	{
		n1=0;
		for(n=30;n<64;n+=3)
		{
			colors[n1].red   =1023+ n*(int)(1024.*r);
			colors[n1].blue  =1023+ n*(int)(1024.*b);
			colors[n1].green =1023+ n*(int)(1024.*g);

		   if (!(XAllocColor (dpy, cmap, &colors[n1]))) {
   		   (void) fprintf (stderr, "Error:  Cannot allocate colors\n");
   		   exit (1);
   		}

			n1++;
		}
	}
}

/* ----------------WINDOW-------------------*/

void initialize (argc,argv)
int argc;
char *argv[];
{	XGCValues *xgc;
	XGCValues *xorgc;
	XGCValues *xandgc;
	char* display = getenv("DISPLAY");
	char* geometry = "";
	XSetWindowAttributes xswa;
	XSizeHints hints;
	Font font;
	int xswamask=0, retval=0;
	int x=0, y=0, w=scrnWidth, h=scrnHeight;
	int wr,hr,hx,hy;
	int niced=19;
	double magfac;
	Pixmap icon;

	while (++argv, --argc)
	{
		if (!strcmp(*argv,"-cycle"))
			{	cycle=60.0/atof(*(++argv));argc--;}
		else if (!strcmp(*argv,"-display"))
			{	display=*(++argv);argc--;}
		else if (!strcmp(*argv,"-geometry") )
			{	geometry=*(++argv);argc--;}
		else if (!strcmp(*argv,"-move") )
			{	movef = atof(*(++argv))/2 ;argc--;}
		else if (!strcmp(*argv,"-wobber") )
			{	wobber *= atof(*(++argv));argc--;}
		else if (!strcmp(*argv,"-nice") )
			{	niced=(atoi(*(++argv)));argc--;}
		else if (!strcmp(*argv,"-mag"))
			{
				magfac = atof(*(++argv));argc--;
				mag *= magfac;
				w = (int)(w*magfac);
				h = (int)(h*magfac);
				fastch=(int)(fastch*magfac);
			}
		else if (!strcmp(*argv,"-minutes"))
			{	minutes=1; maxk+=60-24;}
		else if (!strcmp(*argv,"-wait"))
			{	timewait=(atoi(*(++argv)));argc--;}
		else if (!strcmp(*argv,"-fast"))
			{	fastch=(atoi(*(++argv)));argc--;}
		else if (!strcmp(*argv,"-colcycle"))
			{	cycl=1;}
		else if (!strcmp(*argv,"-hsvcycle"))
			{
				hsvcycl=atof(*(++argv));
				argc--;
			}
		else if (!strcmp(*argv,"-rgb"))
			{
				r=atof(*(++argv));
				g=atof(*(++argv));
				b=atof(*(++argv));
				argc-=3;
			}
		else if (!strcmp(*argv,"-hsv"))
			{
				hue=atof(*(++argv));
				sat=atof(*(++argv));
				val=atof(*(++argv));
				hsv2rgb(hue,sat,val,&r,&g,&b);
				argc-=3;
			}
		else if (!strcmp(*argv,"-help"))
			{
				puts("Time 3D (c) Bernd Paysan\nusage: t3d {option }");
				puts("\t-display <host>:<dpy>\n\t-geometry <geometry string>");
				puts("\t-move <factor>\n\t-wobber <factor>\n\t-nice <factor>");
				puts("\t-minutes\n\t-mag <factor>\n\t-cycle <period>");
				puts("\t-wait <microsec>\n\t-fast <precalc radius>");
				puts("\t-colcycle\n\t-rgb <red> <green> <blue>");
				puts("\t-hsv <hue> <value> <saturation>\n\t-hsvcycle <speed>\n\t-help");
				exit(0);
			}
		else
			{
				printf("unrecognised option '%s'\ntype 't3d -help' for help\n",*argv);
			}
	}

	if (fastch>maxfast)
		fastch=maxfast;

#ifdef PRTDBX
	printf("Set options:\ndisplay: '%s'\ngeometry: '%s'\n",display,geometry);
	printf("move\t%.2f\nwobber\t%.2f\nmag\t%.2f\ncycle\t%.4f\n",
			movef,wobber,mag/10,cycle);
	printf("nice\t%i\nfast\t%i\nmarks\t%i\nwait\t%i\n",niced,fastch,maxk,timewait);
#endif

	(void)nice(niced);

	xgc=( XGCValues *) malloc(sizeof(XGCValues) );
	xorgc=( XGCValues *) malloc(sizeof(XGCValues) );
	xandgc=( XGCValues *) malloc(sizeof(XGCValues) );
   if (!(dpy = XOpenDisplay (display))) {
      (void) fprintf (stderr, "Error:  Can't open display '%s'!\n",display);
      exit (1);
   }

	screen = DefaultScreen (dpy);
	if(geometry[00])
		retval=XParseGeometry(geometry,&x,&y,&w,&h);
	if (retval & XValue && retval & XNegative)
		x = XDisplayWidth(dpy,screen)-w-abs(x);
	if (retval & YValue && retval & YNegative)
		y = XDisplayHeight(dpy,screen)-h-abs(y);
	hints.flags = 0;
	if(retval & (XValue | YValue))
		hints.flags |= USPosition;
	hints.flags |= USSize;
	hints.x = x; hints.y = y;
	hints.width = w; hints.height = h;

	if (flags & ROOT)
		{
      	win = DefaultRootWindow (dpy);
      	scrnWidth = DisplayWidth (dpy, screen);
      	scrnHeight = DisplayHeight (dpy, screen);
	   }
	else
		{  xswamask |= CWBackPixel | CWBorderPixel;
			xswa.background_pixel=BlackPixel(dpy, screen);
			xswa.border_pixel=BlackPixel(dpy, screen);

			scrnWidth=w; scrnHeight=h;

		   win = XCreateWindow (dpy, DefaultRootWindow (dpy),
					x, y, scrnWidth, scrnHeight, 1, 0,
					CopyFromParent, CopyFromParent,
					xswamask, &xswa
					);

			XSetStandardProperties(dpy,win,"Time 3D","Time 3D",
				(!XReadBitmapFile(dpy, win, T3DICON,
									  &wr, &hr, &icon, &hx, &hy) ? icon : None),
				0,0,&hints);

     		XMapWindow (dpy, win);
     		XSelectInput (dpy, win, ExposureMask | StructureNotifyMask
											| KeyPressMask | ButtonPressMask
											| VisibilityChangeMask | PropertyChangeMask);
			for (;;)
			{
				XEvent event;
				XNextEvent(dpy, &event);
	 			if (event.type == Expose) break;
      	}
		}

	xswa.override_redirect = 0;

	planes=DefaultDepth(dpy,screen);

   gc = XCreateGC (dpy, win, 0,  xgc);
	xorgc->function =GXor;
   orgc = XCreateGC (dpy, win, GCFunction,  xorgc);
	xandgc->function =GXandInverted;
   andgc = XCreateGC (dpy, win, GCFunction,  xandgc);

 	buffer = XCreatePixmap (dpy, DefaultRootWindow(dpy), scrnWidth, scrnHeight,
									DefaultDepth (dpy, screen)); 

	printf("Time 3D drawing ");
#ifdef FASTDRAW
#	ifdef FASTCOPY
	puts("fast by Pixmap copy");
#	else
	puts("fast by XImage copy");
#	endif
#else
	puts("slow");
#endif

#ifdef FASTCOPY
	fastcircles = XCreatePixmap (dpy, DefaultRootWindow(dpy), fastcw, fastch+1,
											DefaultDepth (dpy,screen));
	fastmask    = XCreatePixmap (dpy, DefaultRootWindow(dpy), fastcw, fastch+1,
											DefaultDepth (dpy,screen));
#endif

	setink(BlackPixel (dpy, screen));
	XFillRectangle (dpy, buffer     , gc, 0, 0, scrnWidth, scrnHeight);	

#ifdef FASTCOPY

	setink(BlackPixel (dpy, screen));
	XFillRectangle (dpy, fastcircles, gc, 0, 0, fastcw, fastch+1);
	XFillRectangle (dpy, fastmask   , gc, 0, 0, fastcw, fastch+1);

#endif
}


/*------------------------------------------------------------------*/
void init_kugel()
{
	int i;

#ifdef FASTDRAW
	for(i=0; i<fastch; i++)
	{
#	ifdef FASTCOPY
		kugeln[i].r1=-((double) i)/2 -1;
		kugeln[i].x1=sum1ton(i);
		kugeln[i].y1=((double) i)/2 +1;

		fill_kugel(i,fastcircles,1);
		setink((1<<DefaultDepth (dpy, screen))-1);
		fill_kugel(i,fastmask,0);
#	else
		kugeln[i].r1=-((double) i)/2 -1;
		kugeln[i].x1=kugeln[i].y1=((double) i)/2 +1;

		fill_kugel(i,buffer,1);
		fastcircles[i]=XGetImage(dpy,buffer,0,0,i+2,i+2,(1<<planes)-1,ZPixmap);

		setink((1<<DefaultDepth (dpy, screen))-1);
		fill_kugel(i,buffer,0);
		fastmask[i]=XGetImage(dpy,buffer,0,0,i+2,i+2,(1<<planes)-1,ZPixmap);

		setink(0);
		XFillRectangle (dpy, buffer     , gc, 0, 0, scrnWidth, scrnHeight);	
#	endif
	}
	fastdraw=1;
#endif
}

/* Zeiger zeichnen */

void zeiger(dist,rad,z,sec,q)
double dist,rad,z,sec;
int *q;
{
	int i,n;
	double gratio=sqrt(2.0/(1.0+sqrt(5.0)));

	n = *q;

	for(i=0;i<3;i++)
	{
		kugeln[n].x=dist*cos(sec);
		kugeln[n].y=-dist*sin(sec);
		kugeln[n].z=z;
		kugeln[n].r=rad;
		n++;

		dist += rad;
		rad = rad*gratio;
	}
	*q = n;
}

/*-----------------------------------------------------------------*
 *                           Uhr zeichnen                          *
 *-----------------------------------------------------------------*/

void manipulate(k)
double k;
{
	double i,l,xs,ys,zs,mod;
	double persec,sec,min,hour;
	int n;

	sec=TWOPI*modf(k/60,&mod);
	min=TWOPI*modf(k/3600,&mod);
	hour=TWOPI*modf(k/43200,&mod);

	l=TWOPI*modf(k/300,&mod);
	i=0.0;
	for (n=0;n<kmax;n++)
	{

		kugeln[n].x=4.0*sin(i);
		kugeln[n].y=4.0*cos(i);
		kugeln[n].z=wobber* /* (sin(floor(2+2*l/(PI))*i)*sin(2*l)); */
						 cos((i-sec)*floor(2+5*l/(PI)))*sin(5*l);
		if(minutes)
		{	kugeln[n].r=/* (1.0+0.3*cos(floor(2+2*l/(PI))*i)*sin(2*l))* */
		   	          ((n % 5!=0) ? 0.3 : 0.6)*
							 ((n % 15 ==0) ? 1.25 : .75);
		}
		else
		{	kugeln[n].r=/* (1.0+0.3*cos(floor(2+2*l/(PI))*i)*sin(2*l))* */
		   	          ((n & 1) ? 0.5 : 1.0)*
							 ((n % 6==0) ? 1.25 : .75);
		}
		i+=TWOPI/kmax;
	}

	kugeln[n].x=0.0;
	kugeln[n].y=0.0;
	kugeln[n].z=0.0;
	kugeln[n].r=2.0+cos(TWOPI*modf(k,&mod))/2;
	n++;

	zeiger(2.0,0.75,-2.0,sec,&n);
	zeiger(1.0,1.0,-1.5,min,&n);
	zeiger(0.0,1.5,-1.0,hour,&n);

	for(n=0;n<maxk;n++)
	{
		ys=kugeln[n].y*cos(movef*sin(cycle*sec))+kugeln[n].z*sin(movef*sin(cycle*sec));
		zs=-kugeln[n].y*sin(movef*sin(cycle*sec))+kugeln[n].z*cos(movef*sin(cycle*sec));
		kugeln[n].y=ys;
		kugeln[n].z=zs;
	}
}
/*------------------------------------------------------------------*/
void sort(l,r)
int l,r;
{
	int i,j;
	kugeldat ex;
	double x;

	i=l;j=r;
	x=kugeln[(l+r)/2].d;
	while(1)
	{
		while(kugeln[i].d>x) i++;
		while(x>kugeln[j].d) j--;
		if (i<=j)
		{
			ex=kugeln[i];kugeln[i]=kugeln[j];kugeln[j]=ex;
			i++;j--;
		}
		if (i>j) break;
	}
	if (l<j) sort(l,j);
	if (i<r) sort (i,r);
}
/*------------------------------------------------------------------*/
void draw_kugel()
{
	int i;

	XSetForeground(dpy,gc,WhitePixel (dpy, screen));
	XFillRectangle(dpy,buffer,gc,0,0,10,10);
	for (i=0;i<maxk;i++)
	{
		if (kugeln[i].d>0.0)
		{
			XFillRectangle(dpy,buffer,gc,kugeln[i].x1,kugeln[i].y1,kugeln[i].r1,kugeln[i].r1);
		}
	}
}
/*------------------------------------------------------------------*/
int fill_kugel(i,buf,setcol)
int i, setcol;
Pixmap buf;
{
	double ra,ra1;
	int nr=0,m,col,n,inc=1,inr=3,d;
	d=(int)((abs(kugeln[i].r1)*2));
	if (d==0) d=1;

#ifdef FASTDRAW
	if(fastdraw && d<fastch)
	{
#	ifdef FASTCOPY
		XCopyArea(dpy, fastmask, buf, andgc, sum1ton(d)-(d+1)/2, 1,d,d,
					 (int)(kugeln[i].x1)-d/2, (int)(kugeln[i].y1)-d/2);
		XCopyArea(dpy, fastcircles, buf, orgc, sum1ton(d)-(d+1)/2, 1,d,d,
					 (int)(kugeln[i].x1)-d/2, (int)(kugeln[i].y1)-d/2);
#	else
		XPutImage(dpy, buf, andgc, fastmask[d-1], 0, 0,
					 (int)(kugeln[i].x1)-d/2, (int)(kugeln[i].y1)-d/2, d, d);
		XPutImage(dpy, buf, orgc, fastcircles[d-1], 0, 0,
					 (int)(kugeln[i].x1)-d/2, (int)(kugeln[i].y1)-d/2, d, d);
#	endif
	}
	else
#endif
	{
		if(abs(kugeln[i].r1)<6.0) inr=9;

		for (m=0;m<=28;m+=inr)
		{
			ra=kugeln[i].r1*sqrt(1-m*m/(28.0*28.0));
#ifdef PRTDBX
			printf("Radius: %f\n",ra);
#endif
			     if(-ra< 3.0) inc=14;
			else if(-ra< 6.0) inc=8;
			else if(-ra<20.0) inc=4;
			else if(-ra<40.0) inc=2;
			if(setcol)
			{
				if (m==27) col=33;
				else
					col=(int)(m);
				if (col>33) col=33;	col/=3;
				setink(colors[col].pixel);
			}

			for (n=0,nr=0;n<=sines-1;n+=inc,nr++)
			{
				track[nr].x=kugeln[i].x1+(int)(ra*sinus[n])+(kugeln[i].r1-ra)/2;
				track[nr].y=kugeln[i].y1+(int)(ra*cosinus[n])+(kugeln[i].r1-ra)/2;
			}
			XFillPolygon(dpy,buf,gc,track,nr,Convex,CoordModeOrigin);
		}
	}
}

/*------------------------------------------------------------------*/

void init_3d()
{
	double i;
	int n=0;

	a[0]=0.0;
	a[1]=0.0;
	a[2]=-10.0;

	x[0]=10.0;
	x[1]=0.0;
	x[2]=0.0;

	y[0]=0.0;
	y[1]=10.0;
	y[2]=0.0;


	zoom=-10.0;
	speed=.0;

	for (i=0.0;n<sines;i+=TWOPI/sines,n++)
	{
		sinus[n]=sin(i);
		cosinus[n]=cos(i);
	}
}
/*------------------------------------------------------------------*/


void vektorprodukt(feld1,feld2,feld3)
double feld1[],feld2[],feld3[];
{
	feld3[0]=feld1[1]*feld2[2]-feld1[2]*feld2[1];
	feld3[1]=feld1[2]*feld2[0]-feld1[0]*feld2[2];
	feld3[2]=feld1[0]*feld2[1]-feld1[1]*feld2[0];
}
/*------------------------------------------------------------------*/
void turn(feld1,feld2,winkel)
double feld1[],feld2[];
double winkel;
{
	double temp[3];
	double s,ca,sa,sx1,sx2,sx3;

	vektorprodukt(feld1,feld2,temp);

	s=feld1[0]*feld2[0]+feld1[1]*feld2[1]+feld1[2]*feld2[2];

	sx1=s*feld2[0];
	sx2=s*feld2[1];
	sx3=s*feld2[2];
	sa=sin(winkel);ca=cos(winkel);
	feld1[0]=ca*(feld1[0]-sx1)+sa*temp[0]+sx1;
	feld1[1]=ca*(feld1[1]-sx2)+sa*temp[1]+sx2;
	feld1[2]=ca*(feld1[2]-sx3)+sa*temp[2]+sx3;
}
/*------------------------------------------------------------------*/

void viewpoint()

/* 1: Blickrichtung v;3:Ebenenmittelpunkt m 
double feld1[],feld3[]; */
{
 	am[0]=-zoom*v[0];
	am[1]=-zoom*v[1];
	am[2]=-zoom*v[2];

	zaehler=norm*norm*zoom;
}
/*------------------------------------------------------------------*/
void projektion()
{
	double c1[3],c2[3],k[3],x1,y1;
	double cno,cnorm,magnit;
	int i;

	for (i=0;i<maxk;i++)
	{
		c1[0]=kugeln[i].x-a[0];
		c1[1]=kugeln[i].y-a[1];
		c1[2]=kugeln[i].z-a[2];
		cnorm=sqrt(c1[0]*c1[0]+c1[1]*c1[1]+c1[2]*c1[2]);

		c2[0]=c1[0];
		c2[1]=c1[1];
		c2[2]=c1[2];

		cno=c2[0]*v[0]+c2[1]*v[1]+c2[2]*v[2];
		kugeln[i].d=cnorm;
		if (cno<0) kugeln[i].d=-20.0;


		kugeln[i].r1=(mag*zoom*kugeln[i].r/cnorm);

		c2[0]=v[0]/cno;
		c2[1]=v[1]/cno;
		c2[2]=v[2]/cno;

		vektorprodukt(c2,c1,k);


		x1=(startx+(x[0]*k[0]+x[1]*k[1]+x[2]*k[2])*mag);
		y1=(starty-(y[0]*k[0]+y[1]*k[1]+y[2]*k[2])*mag);
		if((x1>-2000.0)
			&& (x1<scrnWidth+2000.0)
			&& (y1>-2000.0)
			&& (y1<scrnHeight+2000.0))
		{
			kugeln[i].x1=(int)x1;
			kugeln[i].y1=(int)y1;
		}
		else
		{
			kugeln[i].x1=0;
			kugeln[i].y1=0;
			kugeln[i].d=-20.0;
		}
	}
}

/*---------- event-handler ----------------*/
void event_handler()
{
	int kpr;
	while (XEventsQueued (dpy, QueuedAfterReading))
	{
		XEvent event;

		XNextEvent (dpy, &event);
		switch (event.type)
		{
			case ConfigureNotify:
				if (event.xconfigure.width != scrnWidth ||
					 event.xconfigure.height != scrnHeight)
				{
					XFreePixmap (dpy, buffer); 
					scrnWidth = event.xconfigure.width;
					scrnHeight = event.xconfigure.height;
					buffer = XCreatePixmap (dpy, DefaultRootWindow (dpy),
													scrnWidth, scrnHeight,
					DefaultDepth (dpy, screen));
	 
					startx=scrnWidth/2;
					starty=scrnHeight/2;
					scrnH2=startx;
					scrnW2=starty;
       		}
			case KeyPress:
			{
				kpr=event.xkey.keycode;
				if (kpr==52) /* s */
					vspeed=0.5;
				if (kpr==53)
					vspeed=-0.3;
				if (kpr==62)
				{
					speed=0;vspeed=0;
				}
				/*	printf("%i\n",event.xkey.keycode);*/
				if (kpr==36) mag*=1.02;
				if (kpr==35) mag/=1.02;
			}
	    	default:
				kpr=0;
	      break;
		}
	}
	/*nap(40);-Ersatz*/ 
	{
		struct timeval timeout;
		timeout.tv_sec=timewait/1000000;
		timeout.tv_usec=timewait%1000000;
		(void)select(0,0,0,0,&timeout);
	}
}
/*-------------------------------------------------*/
main(argc,argv)
int argc;
char *argv[];
{	Window junk_win,in_win;

	int px,py,junk,kb,wai;
	int act,act1,tc;
	double vnorm;
	/* double var=0.0; */
	int color=0, dir=1;
	
	initialize(argc,argv);
	
	initColor(r,g,b);
	init_3d();
	zeit=malloc(sizeof(struct tm));
	init_kugel();

	startx=scrnWidth/2;
	starty=scrnHeight/2;
	scrnH2=startx;
	scrnW2=starty;
	vspeed=0;


	vektorprodukt(x,y,v);
	viewpoint(m,v);
   
	setink (BlackPixel (dpy, screen));
	XFillRectangle (dpy, win, gc, 0, 0, scrnWidth, scrnHeight);
	XQueryPointer (dpy, win, &junk_win, &junk_win, &junk, &junk,
						&px, &py, &kb);

	for (;;)
	{	double dtime;

		/*--------------- Zeichenteil --------------*/

		event_handler();

		vektorprodukt(x,y,v);

		vnorm=sqrt(v[0]*v[0]+v[1]*v[1]+v[2]*v[2]);
		v[0]=v[0]*norm/vnorm;
		v[1]=v[1]*norm/vnorm;
		v[2]=v[2]*norm/vnorm;
		vnorm=sqrt(x[0]*x[0]+x[1]*x[1]+x[2]*x[2]);
		x[0]=x[0]*norm/vnorm;
		x[1]=x[1]*norm/vnorm;
		x[2]=x[2]*norm/vnorm;
		vnorm=sqrt(y[0]*y[0]+y[1]*y[1]+y[2]*y[2]);
		y[0]=y[0]*norm/vnorm;
		y[1]=y[1]*norm/vnorm;
		y[2]=y[2]*norm/vnorm;

		projektion();
		sort(0,maxk-1);

		dtime=gettime();

		if(cycl)
		{
			color=(int)(64.0*(dtime/60-floor(dtime/60)))-32;

			if(color<0)
				color=-color;

			setink(colors[color/3].pixel);
		}
		else
			setink(BlackPixel (dpy, screen));

		XFillRectangle(dpy,buffer,gc,0,0,scrnWidth,scrnHeight);

		{
			int i;

			manipulate(dtime);

			for (i=0;i<maxk;i++)
			{
				if (kugeln[i].d>0.0)
				fill_kugel(i,buffer,1);
			}
		}

		XSync(dpy,0);

		/* manipulate(gettime());
		var+=PI/500;
		if (var>=TWOPI) var=PI/500; */

		/*event_handler();*/

		if(hsvcycl!=0.0)
		{
			dtime=hsvcycl*dtime/10.0+hue/360.0;
			dtime=360*(dtime-floor(dtime));

			hsv2rgb(dtime,sat,val,&r,&g,&b);
			changeColor(r,g,b);
		}

		XCopyArea (dpy, buffer, win, gc, 0, 0, scrnWidth, scrnHeight, 0, 0);


		/*-------------------------------------------------*/
		XSync(dpy,0);

		event_handler();

		(void)(XQueryPointer (dpy, win, &junk_win, &in_win, &junk, &junk,
									&px, &py, &kb));
	
		if ((px>0)&&(px<scrnWidth)&&(py>0)&&(py<scrnHeight) )		
		{
			if ((px !=startx)&&(kb&Button2Mask))
			{
/*				printf("y=(%f,%f,%f)",y[0],y[1],y[2]);*/
				turn(y,x,((double)(px-startx))/(8000*mag));
/*				printf("->(%f,%f,%f)\n",y[0],y[1],y[2]);*/
			}
			if ((py !=starty)&&(kb&Button2Mask)) 
			{
/*				printf("x=(%f,%f,%f)",x[0],x[1],x[2]);*/
				turn(x,y,((double)(py-starty))/(-8000*mag));
/*				printf("->(%f,%f,%f)\n",x[0],x[1],x[2]);*/
			}
			if ((kb&Button1Mask)) 
			{
				if (vturn==0.0) vturn=.005; else if (vturn<2)  vturn+=.01;
				turn(x,v,.002*vturn);
				turn(y,v,.002*vturn); 
			}
			if ((kb&Button3Mask)) 
			{
				if (vturn==0.0) vturn=.005; else if (vturn<2) vturn+=.01;
				turn(x,v,-.002*vturn);
				turn(y,v,-.002*vturn);
			}
		}
		if (!(kb&Button1Mask)&&!(kb&Button3Mask)) 
		vturn=0;

		speed=speed+speed*vspeed;
		if ((speed<0.0000001) &&(vspeed>0.000001)) speed=0.000001;
		vspeed=.1*vspeed;
		if (speed>0.01) speed=.01;
		a[0]=a[0]+speed*v[0];
		a[1]=a[1]+speed*v[1];
		a[2]=a[2]+speed*v[2];
	}
}
