/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.components;

import com.github.ajalt.mordant.components.Text;
import com.github.ajalt.mordant.components.TextKt;
import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.rendering.EmptyRenderable;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.LinesKt;
import com.github.ajalt.mordant.rendering.Renderable;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.SpanKt;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.rendering.WidthRange;
import com.github.ajalt.mordant.terminal.Terminal;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B3\b\u0016\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tB1\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0013\u001a\f\u0012\u0004\u0012\u00020\u00150\u0014j\u0002`\u00162\u0006\u0010\r\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/ajalt/mordant/components/HorizontalRule;", "Lcom/github/ajalt/mordant/rendering/Renderable;", "()V", "title", "", "ruleCharacter", "ruleStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "titleStyle", "(Ljava/lang/String;Ljava/lang/String;Lcom/github/ajalt/mordant/rendering/TextStyle;Lcom/github/ajalt/mordant/rendering/TextStyle;)V", "(Lcom/github/ajalt/mordant/rendering/Renderable;Ljava/lang/String;Lcom/github/ajalt/mordant/rendering/TextStyle;Lcom/github/ajalt/mordant/rendering/TextStyle;)V", "measure", "Lcom/github/ajalt/mordant/rendering/WidthRange;", "t", "Lcom/github/ajalt/mordant/terminal/Terminal;", "width", "", "render", "Lcom/github/ajalt/mordant/rendering/Lines;", "rule", "", "Lcom/github/ajalt/mordant/rendering/Span;", "Lcom/github/ajalt/mordant/rendering/Line;", "Lcom/github/ajalt/mordant/rendering/Theme;", "mordant"})
public final class HorizontalRule
implements Renderable {
    private final Renderable title;
    private final String ruleCharacter;
    private final TextStyle ruleStyle;
    private final TextStyle titleStyle;

    @Override
    @NotNull
    public WidthRange measure(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter(t, "t");
        return new WidthRange(width, width);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Lines render(@NotNull Terminal t, int width) {
        List<List<Span>> list;
        Intrinsics.checkNotNullParameter(t, "t");
        int minBarWidth = 6;
        Lines content = TextKt.withAlign$default(this.title, TextAlign.NONE, null, 2, null).render(t, width - minBarWidth);
        if (content.getLines().isEmpty()) {
            list = CollectionsKt.listOf(this.rule(t.getTheme(), width));
        } else {
            int n;
            TextStyle textStyle = this.titleStyle;
            if (textStyle == null) {
                textStyle = t.getTheme().getHorizontalRuleTitle();
            }
            Lines renderedTitle = content.withStyle$mordant(textStyle);
            List<Span> lastLine = CollectionsKt.last(renderedTitle.getLines());
            Iterable iterable = lastLine;
            int n2 = width;
            boolean bl = false;
            int n3 = 0;
            for (Object t2 : iterable) {
                void it;
                Span span = (Span)t2;
                n = n3;
                boolean bl2 = false;
                int n4 = it.getCellWidth$mordant();
                n3 = n + n4;
            }
            n = n3;
            int ruleWidth = n2 - n - 2;
            List<Span> leftRule = this.rule(t.getTheme(), ruleWidth / 2);
            List<Span> rightRule = this.rule(t.getTheme(), ruleWidth / 2 + ruleWidth % 2);
            Span span = SpanKt.getSINGLE_SPACE();
            TextStyle textStyle2 = this.ruleStyle;
            if (textStyle2 == null) {
                textStyle2 = t.getTheme().getHorizontalRule();
            }
            Span space = span.withStyle$mordant(textStyle2);
            List<Span> rule = LinesKt.flatLine(leftRule, space, lastLine, space, rightRule);
            if (renderedTitle.getLines().size() > 1) {
                Lines firstLines = LinesKt.setSize$default(new Lines(CollectionsKt.dropLast(renderedTitle.getLines(), 1)), width, 0, null, TextAlign.CENTER, 6, null);
                list = CollectionsKt.plus((Collection)firstLines.getLines(), (Iterable)CollectionsKt.listOf(rule));
            } else {
                list = CollectionsKt.listOf(rule);
            }
        }
        List<List<Span>> lines = list;
        return new Lines(lines);
    }

    private final List<Span> rule(Theme t, int width) {
        TextStyle textStyle = this.ruleStyle;
        if (textStyle == null) {
            textStyle = t.getHorizontalRule();
        }
        TextStyle style = textStyle;
        int ruleWidth = width / this.ruleCharacter.length();
        List<Span> rule = CollectionsKt.single(ParsingKt.parseText(StringsKt.repeat(this.ruleCharacter, ruleWidth), style).getLines());
        int remaining = width % this.ruleCharacter.length();
        if (remaining == 0) {
            return rule;
        }
        Span extraRule = Span.Companion.word(StringsKt.take(this.ruleCharacter, remaining), style);
        return CollectionsKt.plus((Collection)rule, extraRule);
    }

    public HorizontalRule(@NotNull Renderable title, @NotNull String ruleCharacter, @Nullable TextStyle ruleStyle, @Nullable TextStyle titleStyle) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(ruleCharacter, "ruleCharacter");
        this.title = title;
        this.ruleCharacter = ruleCharacter;
        this.ruleStyle = ruleStyle;
        this.titleStyle = titleStyle;
        boolean bl = !StringsKt.contains$default((CharSequence)this.ruleCharacter, "\n", false, 2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Rule characters cannot contain line breaks";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        CharSequence charSequence = this.ruleCharacter;
        bl2 = false;
        boolean bl5 = charSequence.length() > 0;
        bl2 = false;
        bl3 = false;
        if (!bl5) {
            boolean bl6 = false;
            String string = "Rule characters cannot be empty.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ HorizontalRule(Renderable renderable, String string, TextStyle textStyle, TextStyle textStyle2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "\u2500";
        }
        if ((n & 4) != 0) {
            textStyle = null;
        }
        if ((n & 8) != 0) {
            textStyle2 = null;
        }
        this(renderable, string, textStyle, textStyle2);
    }

    public HorizontalRule() {
        this(EmptyRenderable.INSTANCE, null, null, null, 14, null);
    }

    public HorizontalRule(@NotNull String title, @NotNull String ruleCharacter, @Nullable TextStyle ruleStyle, @Nullable TextStyle titleStyle) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(ruleCharacter, "ruleCharacter");
        this(new Text(ParsingKt.parseText(title, TextStyleKt.getDEFAULT_STYLE()), null, null, null, null, null, null, 126, null), ruleCharacter, ruleStyle, titleStyle);
    }

    public /* synthetic */ HorizontalRule(String string, String string2, TextStyle textStyle, TextStyle textStyle2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "\u2500";
        }
        if ((n & 4) != 0) {
            textStyle = null;
        }
        if ((n & 8) != 0) {
            textStyle2 = null;
        }
        this(string, string2, textStyle, textStyle2);
    }
}

