/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXFloatingPoint;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.datatool.DataNumericElement;
import com.dickimawbooks.texparserlib.latex.datatool.DatumCommand;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import com.dickimawbooks.texparserlib.latex.datatool.FileFormatType;
import com.dickimawbooks.texparserlib.latex.datatool.Julian;
import java.io.IOException;
import java.io.PrintWriter;

public class DatumElement
extends AbstractTeXObject
implements DataNumericElement,
Expandable {
    private TeXObject content;
    private TeXObject currencySymbol;
    private TeXNumber number;
    private TeXObject objectValue;
    private DatumType datumType;
    private Julian julian;

    public DatumElement() {
        this(new TeXObjectList(), null, null, null, null, DatumType.UNKNOWN);
    }

    public DatumElement(TeXObject teXObject) {
        this(teXObject, null, null, null, null, DatumType.STRING);
    }

    public DatumElement(TeXObject teXObject, TeXNumber teXNumber, TeXObject teXObject2, DatumType datumType) {
        this(teXObject, teXNumber, teXNumber, teXObject2, null, datumType);
    }

    public DatumElement(TeXObject teXObject, TeXNumber teXNumber, TeXObject teXObject2, TeXObject teXObject3, Julian julian, DatumType datumType) {
        this.content = teXObject;
        this.number = teXNumber;
        this.objectValue = teXObject2;
        this.currencySymbol = teXObject3;
        this.julian = julian;
        this.datumType = datumType;
    }

    public DatumElement(TeXParserListener teXParserListener, TeXObject teXObject, Julian julian) {
        this.content = teXObject;
        this.currencySymbol = null;
        TeXObjectList teXObjectList = teXParserListener.createStack();
        this.objectValue = teXObjectList;
        teXObjectList.add(new TeXCsRef("DTLtemporalvalue"));
        Group group = teXParserListener.createGroup();
        teXObjectList.add(group);
        if (julian.hasDate() && julian.hasTime()) {
            this.datumType = DatumType.DATETIME;
            this.number = new TeXFloatingPoint(julian.getJulianDate());
        } else if (julian.hasTime()) {
            this.datumType = DatumType.TIME;
            this.number = new TeXFloatingPoint(julian.getJulianTime());
        } else {
            this.datumType = DatumType.DATE;
            this.number = new UserNumber(julian.getJulianDay());
        }
        group.add(this.number);
        teXObjectList.add(teXParserListener.createGroup(julian.getTimeStamp()));
    }

    @Override
    public Object clone() {
        DatumElement datumElement = new DatumElement((TeXObject)this.content.clone());
        if (this.number != null) {
            datumElement.number = (TeXNumber)this.number.clone();
        }
        if (this.objectValue != null) {
            datumElement.objectValue = (TeXObject)this.objectValue.clone();
        }
        if (this.currencySymbol != null) {
            datumElement.currencySymbol = (TeXObject)this.currencySymbol.clone();
        }
        datumElement.julian = this.julian;
        datumElement.datumType = this.datumType;
        return datumElement;
    }

    @Override
    public byte getDataType() {
        return (byte)this.datumType.getValue();
    }

    @Override
    public DatumType getDatumType() {
        return this.datumType;
    }

    @Override
    public boolean isDataObject() {
        return true;
    }

    @Override
    public double doubleValue() {
        return this.number == null ? 0.0 : this.number.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public int intValue() {
        return this.number == null ? 0 : this.number.getValue();
    }

    @Override
    public long longValue() {
        return this.number == null ? 0L : this.number.longValue();
    }

    @Override
    public TeXObject getTeXValue(TeXParser teXParser) {
        return this.objectValue;
    }

    @Override
    public Julian getJulian() {
        return this.julian;
    }

    public Number getNumber() {
        if (this.number == null) {
            return null;
        }
        if (this.datumType == DatumType.INTEGER) {
            return this.number.getValue();
        }
        if (this.datumType == DatumType.DATE) {
            return this.number.longValue();
        }
        return this.number.doubleValue();
    }

    @Override
    public TeXObject getCurrencySymbol() {
        return this.currencySymbol;
    }

    public TeXObject getOriginal() {
        return this.content;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.intValue();
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        if (this.number == null) {
            throw new TeXSyntaxException(teXParser, "tex.error.number_expected", this.content.toString(teXParser));
        }
        this.number.advance(teXParser, numerical);
        this.content = this.number;
    }

    @Override
    public void divide(int n) {
        if (this.number != null) {
            this.number.divide(n);
            this.content = this.number;
        }
    }

    @Override
    public void multiply(int n) {
        if (this.number != null) {
            this.number.multiply(n);
            this.content = this.number;
        }
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXObjectList teXObjectList2 = teXParserListener.createStack();
        teXObjectList2.add(this.content, true);
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.content.canExpand()) {
            return TeXParserUtils.toList(TeXParserUtils.expandFully(this.content, teXParser, teXObjectList), teXParser);
        }
        return this.expandonce(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandfully(teXParser, teXParser);
    }

    @Override
    public ControlSequence createControlSequence(String string) {
        return new DatumCommand(string, this.content, this.getNumber(), this.currencySymbol, this.datumType);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.content.process(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.content.process(teXParser);
    }

    public void write(TeXParser teXParser, PrintWriter printWriter, FileFormatType fileFormatType, String string) throws IOException {
        if (fileFormatType == FileFormatType.DBTEX && string.equals("3.0")) {
            printWriter.print("\\dtldbdatumreconstruct{");
            printWriter.print(this.content.toString(teXParser));
            printWriter.print("}{");
            if (this.objectValue != null) {
                printWriter.print(this.objectValue.toString(teXParser));
            }
            printWriter.print("}{");
            if (this.currencySymbol != null) {
                printWriter.print(this.currencySymbol.toString(teXParser));
            }
            printWriter.print("}{");
            printWriter.print(this.datumType.getValue());
            printWriter.print("}");
        } else {
            printWriter.print(this.content.toString(teXParser));
        }
    }

    @Override
    public TeXObject getContent(TeXParser teXParser) {
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXObjectList teXObjectList = teXParserListener.createStack();
        teXObjectList.add(teXParserListener.getControlSequence("__datatool_datum:nnnn"));
        Group group = teXParserListener.createGroup();
        teXObjectList.add(group);
        group.add(this.content, true);
        group = teXParserListener.createGroup();
        teXObjectList.add(group);
        if (this.objectValue != null) {
            group.add((TeXObject)this.objectValue.clone());
        }
        group = teXParserListener.createGroup();
        teXObjectList.add(group);
        if (this.currencySymbol != null) {
            group.add(this.currencySymbol);
        }
        teXObjectList.add(new UserNumber(this.datumType.getValue()));
        return teXObjectList;
    }

    @Override
    public String format() {
        return this.content.format();
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.content.toString(teXParser);
    }

    public String toString() {
        return String.format("%s[content=%s,number=%s,objectValue=%s,symbol=%s,julian=%s,type=%s]", new Object[]{this.getClass().getSimpleName(), this.content, this.number, this.objectValue, this.currencySymbol, this.julian, this.datumType});
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return this.content.string(teXParser);
    }
}

