/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AssignedControlSequence;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.InternalQuantity;
import com.dickimawbooks.texparserlib.Letter;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.Other;
import com.dickimawbooks.texparserlib.Resolvable;
import com.dickimawbooks.texparserlib.SingleToken;
import com.dickimawbooks.texparserlib.TeXBoolean;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXFloatingPoint;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.primitives.Relax;
import java.io.IOException;

public class TeXParserUtils {
    public static TeXObject peek(TeXParser teXParser, TeXObjectList teXObjectList, byte by) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXParser.peekStack(by);
        }
        return teXObjectList.peekStack(by);
    }

    public static TeXObject pop(TeXParser teXParser, TeXObjectList teXObjectList, byte by) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXParser.popStack(by);
        }
        return teXObjectList.popStack(teXParser, by);
    }

    public static int popModifier(TeXParser teXParser, TeXObjectList teXObjectList, int ... nArray) throws IOException {
        TeXObject teXObject = teXParser == teXObjectList || teXObjectList == null ? teXParser.peekStack() : teXObjectList.peekStack();
        int n = -1;
        if (teXObject instanceof CharObject) {
            int n2 = ((CharObject)teXObject).getCharCode();
            for (int n3 : nArray) {
                if (n2 != n3) continue;
                n = n3;
                break;
            }
            if (n != -1) {
                if (teXParser == teXObjectList || teXObjectList == null) {
                    teXParser.popStack();
                } else {
                    teXObjectList.popStack(teXParser);
                }
            }
        }
        return n;
    }

    public static String popLabelString(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return teXParser.expandToString(TeXParserUtils.popArg(teXParser, teXObjectList), teXObjectList);
    }

    public static String popOptLabelString(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popOptArg(teXParser, teXObjectList);
        if (teXObject == null) {
            return null;
        }
        return teXParser.expandToString(teXObject, teXObjectList);
    }

    public static TeXPath popTeXPath(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        if (teXParser.isStack(teXObject) && ((TeXObjectList)teXObject).size() == 1) {
            teXObject = (TeXObject)((TeXObjectList)teXObject).firstElement();
        }
        if (teXObject instanceof TeXPath) {
            return (TeXPath)((Object)teXObject);
        }
        return new TeXPath(teXParser, teXParser.expandToString(teXObject, teXObjectList));
    }

    public static TeXObject popArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXParser.popNextArg();
        }
        return teXObjectList.popArg(teXParser);
    }

    public static TeXObject popArg(TeXParser teXParser, TeXObjectList teXObjectList, byte by) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXParser.popNextArg(by);
        }
        return teXObjectList.popArg(teXParser, by);
    }

    public static TeXObject popOptArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXParser.popNextArg(91, 93);
        }
        return teXObjectList.popArg(teXParser, 91, 93);
    }

    public static TeXObject popOptArg(byte by, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXParser.popNextArg(by, 91, 93);
        }
        return teXObjectList.popArg(teXParser, by, 91, 93);
    }

    public static TeXObject expandOnce(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return teXParser.expandonce(teXObject, teXObjectList);
    }

    public static TeXObject expandFully(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return teXParser.expandfully(teXObject, teXObjectList);
    }

    public static TeXObject popArgExpandOnce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        return TeXParserUtils.expandOnce(teXObject, teXParser, teXObjectList);
    }

    public static TeXObject popArgExpandFully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        return TeXParserUtils.expandFully(teXObject, teXParser, teXObjectList);
    }

    public static TeXObject popOptArgExpandFully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popOptArg(teXParser, teXObjectList);
        if (teXObject == null) {
            return null;
        }
        return TeXParserUtils.expandFully(teXObject, teXParser, teXObjectList);
    }

    public static String getControlSequenceValue(String string, String string2, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        ControlSequence controlSequence = teXParser.getControlSequence(string);
        if (controlSequence == null) {
            return string2;
        }
        if (controlSequence instanceof TextualContentCommand) {
            return ((TextualContentCommand)controlSequence).getText();
        }
        return teXParser.expandToString(controlSequence, teXObjectList);
    }

    public static int popInt(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Numerical numerical = TeXParserUtils.popNumericalArg(teXParser, teXObjectList);
        return numerical.number(teXParser);
    }

    public static int popOptInt(TeXParser teXParser, TeXObjectList teXObjectList, int n) throws IOException {
        Numerical numerical = TeXParserUtils.popOptNumericalArg(teXParser, teXObjectList);
        return numerical == null ? n : numerical.number(teXParser);
    }

    public static Numerical popNumericalArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXParser.popNumericalArg();
        }
        return teXObjectList.popNumericalArg(teXParser);
    }

    public static Numerical popOptNumericalArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXParser.popNumericalArg(91, 93);
        }
        return teXObjectList.popNumericalArg(teXParser, 91, 93);
    }

    public static NumericRegister popNumericRegister(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        NumericRegister numericRegister = null;
        if (teXObject instanceof ControlSequence) {
            numericRegister = teXParser.getSettings().getNumericRegister(((ControlSequence)teXObject).getName());
        }
        if (numericRegister == null) {
            throw new TeXSyntaxException(teXParser, "tex.error.register_not_numeric", teXObject.toString(teXParser));
        }
        return numericRegister;
    }

    public static TeXDimension popDimensionArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArgExpandFully(teXParser, teXObjectList);
        if (teXObject instanceof InternalQuantity) {
            teXObject = ((InternalQuantity)teXObject).getQuantity(teXParser, teXObjectList);
        }
        if (teXObject instanceof TeXDimension) {
            return (TeXDimension)teXObject;
        }
        if (teXObject instanceof TeXObjectList) {
            TeXObjectList teXObjectList2 = (TeXObjectList)teXObject;
            return teXObjectList2.popDimension(teXParser);
        }
        throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", new Object[0]);
    }

    public static TeXDimension popOptDimensionArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popOptArgExpandFully(teXParser, teXObjectList);
        if (teXObject == null) {
            return null;
        }
        if (teXObject instanceof InternalQuantity) {
            teXObject = ((InternalQuantity)teXObject).getQuantity(teXParser, teXObjectList);
        }
        if (teXObject instanceof TeXDimension) {
            return (TeXDimension)teXObject;
        }
        if (teXObject instanceof TeXObjectList) {
            TeXObjectList teXObjectList2 = (TeXObjectList)teXObject;
            return teXObjectList2.popDimension(teXParser);
        }
        throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", new Object[0]);
    }

    public static boolean onlyContainsControlSequence(TeXObjectList teXObjectList, String ... stringArray) {
        return TeXParserUtils.onlyContainsControlSequence(TeXObjectList.POP_RETAIN_IGNOREABLES, teXObjectList, stringArray);
    }

    public static boolean onlyContainsControlSequence(byte by, TeXObjectList teXObjectList, String ... stringArray) {
        TeXObject teXObject;
        int n;
        if (teXObjectList.isEmpty()) {
            return false;
        }
        boolean bl = !TeXObjectList.isRetainIgnoreables(by);
        boolean bl2 = TeXObjectList.isIgnoreLeadingSpace(by);
        TeXObject teXObject2 = null;
        for (n = 0; n < teXObjectList.size(); ++n) {
            teXObject = (TeXObject)teXObjectList.get(n);
            if (bl && teXObject instanceof Ignoreable || bl2 && teXObject instanceof WhiteSpace) continue;
            teXObject2 = teXObject;
            break;
        }
        if (teXObject2 == null) {
            if (n < teXObjectList.size()) {
                teXObject2 = (TeXObject)teXObjectList.get(n);
                ++n;
            } else {
                return false;
            }
        }
        if (!TeXParserUtils.isControlSequence(teXObject2, stringArray)) {
            return false;
        }
        if (bl) {
            while (n < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n);
                if (!(teXObject2 instanceof Ignoreable)) {
                    return false;
                }
                ++n;
            }
        }
        return n >= teXObjectList.size();
    }

    public static boolean isControlSequence(TeXObject teXObject, String ... stringArray) {
        if (teXObject instanceof ControlSequence) {
            ControlSequence controlSequence = (ControlSequence)teXObject;
            for (String string : stringArray) {
                if (!controlSequence.getName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static ControlSequence popControlSequence(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        if (teXParser.isStack(teXObject) && ((TeXObjectList)teXObject).size() == 1) {
            teXObject = (TeXObject)((TeXObjectList)teXObject).firstElement();
        }
        if (teXObject instanceof ControlSequence) {
            return (ControlSequence)teXObject;
        }
        if (teXParser.isStack(teXObject)) {
            if (teXObjectList == null) {
                teXParser.push(teXObject, true);
            } else {
                teXObjectList.push(teXObject, true);
            }
            teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
            if (teXObject instanceof ControlSequence) {
                return (ControlSequence)teXObject;
            }
        }
        throw new TeXSyntaxException(teXParser, "tex.error.cs_expected", teXObject.format(), teXObject.getClass().getSimpleName());
    }

    public static ControlSequence popResolvedControlSequence(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        if (teXParser.isStack(teXObject) && ((TeXObjectList)teXObject).size() == 1) {
            teXObject = (TeXObject)((TeXObjectList)teXObject).firstElement();
        }
        if (teXObject instanceof TeXCsRef) {
            teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
        }
        if (teXObject instanceof AssignedControlSequence) {
            teXObject = TeXParserUtils.resolve(teXObject, teXParser);
        }
        if (teXObject instanceof ControlSequence) {
            return (ControlSequence)teXObject;
        }
        if (teXParser.isStack(teXObject)) {
            if (teXObjectList == null) {
                teXParser.push(teXObject, true);
            } else {
                teXObjectList.push(teXObject, true);
            }
            teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
            if (teXObject instanceof TeXCsRef) {
                teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
            }
            if (teXObject instanceof AssignedControlSequence) {
                teXObject = TeXParserUtils.resolve(teXObject, teXParser);
            }
            if (teXObject instanceof ControlSequence) {
                return (ControlSequence)teXObject;
            }
        }
        throw new TeXSyntaxException(teXParser, "tex.error.cs_expected", teXObject.format(), teXObject.getClass().getSimpleName());
    }

    public static TeXObjectList toList(TeXObject teXObject, TeXParser teXParser) {
        if (teXParser.isStack(teXObject)) {
            return (TeXObjectList)teXObject;
        }
        return TeXParserUtils.createStack(teXParser, teXObject);
    }

    public static CsvList toCsvList(TeXObject teXObject, TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        if (teXObject instanceof CsvList) {
            return (CsvList)teXObject;
        }
        if (teXParser.isStack(teXObject) && (teXObjectList = (TeXObjectList)teXObject).size() == 1 && teXObjectList.firstElement() instanceof CsvList) {
            return (CsvList)teXObjectList.firstElement();
        }
        return CsvList.getList(teXParser, teXObject);
    }

    public static CsvList popCsvList(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        return TeXParserUtils.toCsvList(teXObject, teXParser);
    }

    public static CsvList popOptCsvList(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popOptArg(teXParser, teXObjectList);
        if (teXObject == null) {
            return null;
        }
        return TeXParserUtils.toCsvList(teXObject, teXParser);
    }

    public static KeyValList toKeyValList(TeXObject teXObject, TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        if (teXObject instanceof KeyValList) {
            return (KeyValList)teXObject;
        }
        if (teXObject instanceof CsvList) {
            return ((CsvList)teXObject).toKeyValList(teXParser);
        }
        if (teXParser.isStack(teXObject) && (teXObjectList = (TeXObjectList)teXObject).size() == 1) {
            TeXObject teXObject2 = (TeXObject)teXObjectList.firstElement();
            if (teXObject2 instanceof KeyValList) {
                return (KeyValList)teXObjectList.firstElement();
            }
            if (teXObject2 instanceof CsvList) {
                return ((CsvList)teXObject2).toKeyValList(teXParser);
            }
        }
        return KeyValList.getList(teXParser, teXObject);
    }

    public static KeyValList popKeyValList(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        return TeXParserUtils.toKeyValList(teXObject, teXParser);
    }

    public static KeyValList popOptKeyValList(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popOptArg(teXParser, teXObjectList);
        if (teXObject == null) {
            return null;
        }
        return TeXParserUtils.toKeyValList(teXObject, teXParser);
    }

    public static TeXObject popL3Arg(TeXParser teXParser, TeXObjectList teXObjectList, char c) throws IOException {
        switch (c) {
            case 'o': {
                return TeXParserUtils.popArgExpandOnce(teXParser, teXObjectList);
            }
            case 'e': 
            case 'x': {
                return TeXParserUtils.popArgExpandFully(teXParser, teXObjectList);
            }
            case 'N': {
                return teXObjectList == null ? teXParser.popToken() : teXObjectList.popToken();
            }
            case 'c': {
                String string = TeXParserUtils.popLabelString(teXParser, teXObjectList);
                ControlSequence controlSequence = teXParser.getControlSequence(string);
                return controlSequence == null ? new TeXCsRef(string) : controlSequence;
            }
        }
        if (c == 'v' || c == 'V') {
            ControlSequence controlSequence;
            Object object;
            if (c == 'v') {
                object = TeXParserUtils.popLabelString(teXParser, teXObjectList);
                controlSequence = teXParser.getListener().getControlSequence((String)object);
            } else {
                controlSequence = TeXParserUtils.popControlSequence(teXParser, teXObjectList);
            }
            object = TeXParserUtils.resolve(controlSequence, teXParser);
            if (object instanceof GenericCommand) {
                return (TeXObject)((GenericCommand)object).getDefinition().clone();
            }
            if (object instanceof InternalQuantity) {
                return ((InternalQuantity)object).getQuantity(teXParser, teXObjectList);
            }
            return TeXParserUtils.expandOnce((TeXObject)object, teXParser, teXObjectList);
        }
        return TeXParserUtils.popArg(teXParser, teXObjectList);
    }

    public static boolean isTrue(String string, TeXParser teXParser) {
        TeXBoolean teXBoolean = TeXParserUtils.toBoolean(string, teXParser);
        return teXBoolean != null && teXBoolean.booleanValue();
    }

    public static boolean isFalse(String string, TeXParser teXParser) {
        TeXBoolean teXBoolean = TeXParserUtils.toBoolean(string, teXParser);
        return teXBoolean != null && !teXBoolean.booleanValue();
    }

    public static TeXBoolean toBoolean(String string, TeXParser teXParser) {
        return TeXParserUtils.toBoolean(teXParser.getControlSequence(string), teXParser);
    }

    public static TeXBoolean toBoolean(TeXObject teXObject, TeXParser teXParser) {
        TeXObject teXObject2;
        if (teXObject == null) {
            return null;
        }
        if (teXObject instanceof TeXBoolean) {
            return (TeXBoolean)teXObject;
        }
        if (teXObject instanceof AssignedControlSequence && (teXObject2 = ((AssignedControlSequence)teXObject).getBaseUnderlying()) instanceof TeXBoolean) {
            return (TeXBoolean)teXObject2;
        }
        return null;
    }

    public static Numerical toNumerical(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser.isStack(teXObject)) {
            ((TeXObjectList)teXObject).trim();
            if (((TeXObjectList)teXObject).size() == 1) {
                teXObject = (TeXObject)((TeXObjectList)teXObject).firstElement();
            }
        }
        if (teXObject instanceof Numerical) {
            return (Numerical)teXObject;
        }
        String string = teXParser.expandToString(teXObject, teXObjectList).trim();
        return new UserNumber(teXParser, string);
    }

    public static TeXNumber toTeXNumber(boolean bl, TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXNumber teXNumber = null;
        if (teXParser.isStack(teXObject)) {
            ((TeXObjectList)teXObject).trim();
            if (((TeXObjectList)teXObject).size() == 1) {
                teXObject = (TeXObject)((TeXObjectList)teXObject).firstElement();
            }
        }
        if (teXObject instanceof TeXNumber) {
            teXNumber = (TeXNumber)teXObject;
        } else if (teXObject instanceof AssignedControlSequence) {
            TeXObject teXObject2 = ((AssignedControlSequence)teXObject).getBaseUnderlying();
            if (teXObject2 instanceof TeXNumber) {
                teXNumber = (TeXNumber)teXObject2;
            }
        } else {
            String string = teXParser.expandToString(teXObject, teXObjectList);
            try {
                if (bl) {
                    teXNumber = new UserNumber(Integer.parseInt(string));
                } else {
                    try {
                        teXNumber = new UserNumber(Integer.parseInt(string));
                    }
                    catch (NumberFormatException numberFormatException) {
                        teXNumber = new TeXFloatingPoint(Double.parseDouble(string));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new TeXSyntaxException((Throwable)numberFormatException, teXParser, "tex.error.number_expected", string);
            }
        }
        if (bl && teXNumber instanceof TeXFloatingPoint) {
            teXNumber = new UserNumber(teXNumber.getValue());
        }
        return teXNumber;
    }

    public static int toInt(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Object object;
        if (teXParser.isStack(teXObject)) {
            ((TeXObjectList)teXObject).trim();
            if (((TeXObjectList)teXObject).size() == 1) {
                teXObject = (TeXObject)((TeXObjectList)teXObject).firstElement();
            }
        }
        if (teXObject instanceof TeXNumber) {
            return ((TeXNumber)teXObject).getValue();
        }
        if (teXObject instanceof AssignedControlSequence && (object = ((AssignedControlSequence)teXObject).getBaseUnderlying()) instanceof TeXNumber) {
            return ((TeXNumber)object).getValue();
        }
        object = teXParser.expandToString(teXObject, teXObjectList);
        try {
            return Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeXSyntaxException((Throwable)numberFormatException, teXParser, "tex.error.number_expected", object);
        }
    }

    public static float toFloat(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Object object;
        if (teXParser.isStack(teXObject)) {
            ((TeXObjectList)teXObject).trim();
            if (((TeXObjectList)teXObject).size() == 1) {
                teXObject = (TeXObject)((TeXObjectList)teXObject).firstElement();
            }
        }
        if (teXObject instanceof TeXNumber) {
            return (float)((TeXNumber)teXObject).doubleValue();
        }
        if (teXObject instanceof AssignedControlSequence && (object = ((AssignedControlSequence)teXObject).getBaseUnderlying()) instanceof TeXNumber) {
            return ((TeXNumber)object).getValue();
        }
        object = teXParser.expandToString(teXObject, teXObjectList);
        try {
            return Float.parseFloat((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeXSyntaxException((Throwable)numberFormatException, teXParser, "tex.error.number_expected", object);
        }
    }

    public static double toDouble(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Object object;
        if (teXParser.isStack(teXObject)) {
            ((TeXObjectList)teXObject).trim();
            if (((TeXObjectList)teXObject).size() == 1) {
                teXObject = (TeXObject)((TeXObjectList)teXObject).firstElement();
            }
        }
        if (teXObject instanceof TeXNumber) {
            return ((TeXNumber)teXObject).doubleValue();
        }
        if (teXObject instanceof AssignedControlSequence && (object = ((AssignedControlSequence)teXObject).getBaseUnderlying()) instanceof TeXNumber) {
            return ((TeXNumber)object).getValue();
        }
        object = teXParser.expandToString(teXObject, teXObjectList);
        try {
            return Double.parseDouble((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeXSyntaxException((Throwable)numberFormatException, teXParser, "tex.error.number_expected", object);
        }
    }

    public static TeXObjectList createStack(TeXParser teXParser, TeXObject ... teXObjectArray) {
        return TeXParserUtils.createStack(teXParser.getListener(), teXObjectArray);
    }

    public static TeXObjectList createStack(TeXParserListener teXParserListener, TeXObject ... teXObjectArray) {
        TeXObjectList teXObjectList = teXParserListener.createStack();
        for (TeXObject teXObject : teXObjectArray) {
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    public static Group createGroup(TeXParser teXParser, TeXObject ... teXObjectArray) {
        return TeXParserUtils.createGroup(teXParser.getListener(), teXObjectArray);
    }

    public static Group createGroup(TeXParserListener teXParserListener, TeXObject ... teXObjectArray) {
        Group group = teXParserListener.createGroup();
        for (TeXObject teXObject : teXObjectArray) {
            group.add(teXObject);
        }
        return group;
    }

    public static TeXObjectList removeGroup(TeXObjectList teXObjectList) {
        TeXObject teXObject;
        if (teXObjectList instanceof Group && !(teXObjectList instanceof MathGroup)) {
            teXObjectList = ((Group)teXObjectList).toList();
        } else if (teXObjectList.size() == 1 && (teXObject = (TeXObject)teXObjectList.firstElement()) instanceof Group && !(teXObject instanceof MathGroup)) {
            teXObjectList = ((Group)teXObject).toList();
        }
        return teXObjectList;
    }

    public static void process(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
    }

    public static TeXObject resolve(TeXObject teXObject, TeXParser teXParser) {
        if (teXObject != null && teXObject instanceof Resolvable) {
            teXObject = ((Resolvable)((Object)teXObject)).resolve(teXParser);
        }
        return teXObject;
    }

    public static boolean isVoid(TeXObject teXObject, TeXParser teXParser) {
        if (teXObject == null || teXObject.isEmpty() || teXObject instanceof Relax) {
            return true;
        }
        return teXObject instanceof Resolvable && ((teXObject = ((Resolvable)((Object)teXObject)).resolve(teXParser)).isEmpty() || teXObject instanceof Relax);
    }

    public static boolean isString(TeXObject teXObject, TeXParser teXParser) {
        if (teXObject == null) {
            return false;
        }
        if (teXParser.isStack(teXObject)) {
            TeXObjectList teXObjectList = (TeXObjectList)teXObject;
            for (TeXObject teXObject2 : teXObjectList) {
                if (TeXParserUtils.isString(teXObject2, teXParser)) continue;
                return false;
            }
            return true;
        }
        if (teXObject instanceof WhiteSpace || teXObject instanceof Letter || teXObject instanceof Other) {
            return true;
        }
        if (teXObject.isSingleToken()) {
            int n = ((SingleToken)teXObject).getCatCode();
            return n == 11 || n == 12 || n == 10;
        }
        return false;
    }

    public static TeXObject purify(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (TeXParserUtils.isString(teXObject = TeXParserUtils.expandFully(teXObject, teXParser, teXObjectList), teXParser)) {
            return teXObject;
        }
        TeXObjectList teXObjectList2 = teXParser.getListener().createStack();
        if (teXObject instanceof TeXObjectList) {
            for (TeXObject teXObject2 : (TeXObjectList)teXObject) {
                if (!TeXParserUtils.isString(teXObject2, teXParser)) continue;
                teXObjectList2.add(teXObject2, true);
            }
        }
        return teXObjectList2;
    }

    public static boolean isBlank(int n) {
        return n == 32 || n == 13 || n == 10 || n == 12 || n == 9;
    }

    public static boolean isBlank(String string) {
        int n;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (TeXParserUtils.isBlank(n)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(StringBuilder stringBuilder) {
        int n;
        for (int i = 0; i < stringBuilder.length(); i += Character.charCount(n)) {
            n = stringBuilder.codePointAt(i);
            if (TeXParserUtils.isBlank(n)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(CharSequence charSequence, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (TeXParserUtils.isBlank(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (TeXParserUtils.isBlank(cArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(char[] cArray) {
        return TeXParserUtils.isBlank(cArray, 0, cArray.length);
    }
}

