/*
 * SOURCE:  dos.h
 * PROJECT: EasyTeX
 *
 * PURPOSE: function prototypes and defines
 *
 * UPDATES: 08/15/1991 - major rewrite
 *
 * (c)M.Schollmeyer
 */
#ifndef DOS_H
#define DOS_H


#define AllocStruct( name ) (struct name *)AllocMem( ( unsigned long )sizeof( struct name ) )
#define FreeStruct( ptr )   FreeMem( FP_SEG(ptr) )
#define FreeSeg( ptr )	    FreeMem( ptr )

	/* macros to convert clock values to seconds and vice versa */
#define TICKS_TO_MINS(n) ((n)/1092)
#define MINS_TO_TICKS(n) ((n)*1092)

#define RTC_RUNNING   0x00000001L
#define RTC_DAYLIGHT  0x00000002L

#define RTC_SUNDAY    0
#define RTC_MONDAY    1
#define RTC_TUESDAY   2
#define RTC_WEDNESDAY 3
#define RTC_THURSDAY  4
#define RTC_FRIDAY    5
#define RTC_SATURDAY  6

struct RealTimeClock {
unsigned char Hours;
unsigned char Minutes;
unsigned char Seconds;
unsigned char Hundrets;
unsigned char Day;
unsigned char Month;
unsigned int Year;
unsigned char DayOfWeek;
};

/* contents of AccessFlag */
#define ACCESS_READ   0x00
#define ACCESS_WRITE  0x01
#define ACCESS_RDWR   0x02
#define MODE_COMP     0x00 /* Compatibility Mode */
#define DENY_ALL      0x08
#define DENY_WRITE    0x10
#define DENY_READ     0x18
#define DENY_NONE     0x20
#define CHILD_NOINH   0x00   /* Child Process Does Not Inherit Handle */
#define CHILD_INHERIT 0x00  /* Child Process Inherits Handle */

/* Flags for Create */
#define FILE_READONY	0x0001
#define FILE_HIDDEN	0x0002
#define FILE_SYSTEM	0x0003
#define FILE_VOLLAB	0x0008	/* Volume Label */
#define FILE_ARCHIVE	0x0020

/* Flags for GetFileAttr, SetFileAttr */
#define ATTR_READONY	(1<<0)
#define ATTR_HIDDEN	(1<<1)
#define ATTR_SYSTEM	(1<<2)
#define ATTR_ARCHIVE	(1<<5)

/* Method Code for Seek */
#define SEEK_START 0
#define SEEK_CURRENT 1
#define SEEK_END 2

struct DiskTransferArea {
unsigned char Reserved[21];
unsigned char Attributes;
unsigned long Date;
unsigned long Size;
unsigned char Name[13];
};

#define DTA_READONY   0x0001
#define DTA_HIDDEN    0x0002
#define DTA_SYSTEM    0x0004
#define DTA_LABEL     0x0008
#define DTA_DIRECTORY 0x0010 /* This flag is an undocumented feature.
				DOS may not support it in future upgrades */
#define DTA_ARCHIVE   0x0020

#define DTA_ALL (DTA_READONY|DTA_HIDDEN|DTA_SYSTEM|DTA_DIRECTORY|DTA_ARCHIVE)


#define DOS_SECONDS(s)	( ( (s	  ) & 0x1f ) *	  2 )
#define DOS_MINUTES(s)	( ( (s	  ) >>	5 )  & 0x3f )
#define DOS_HOURS(s)	( ( (s	  ) >>	11 ) & 0x1f )
#define DOS_DAYS(s)	  ( (s>>16)	     & 0x1f )
#define DOS_MONTHS(s)	( ( (s>>16) >>	5 )  & 0x0f )
#define DOS_YEARS(s)  ( ( ( (s>>16) >>	9 )  & 0x7f ) + 1980 )

#define DTA_SECONDS(s)	DOS_SECONDS( (s)->Date )
#define DTA_MINUTES(s)	DOS_MINUTES( (s)->Date )
#define DTA_HOURS(s)	DOS_HOURS( (s)->Date )
#define DTA_DAYS(s)	DOS_DAYS( (s)->Date )
#define DTA_MONTHS(s)	DOS_MONTHS( (s)->Date )
#define DTA_YEARS(s)	DOS_YEARS( (s)->Date )


struct DOSError {
    unsigned int Code;
    char *Msg;
    unsigned int Flags;
};

struct DriveData {
    unsigned char MediaID;
    unsigned char SectorsPerCluster;
    unsigned int SectorSize;
    unsigned int NumClusters;
};

extern int errnum;

		/* function prototypes */
void IntPreamble( void );
void IntPostamble( void );

void SetHandler( void (__cdecl __interrupt __far *handler)() );

void  UnSetHandler( void );

unsigned long  GetClock( void );   /* returns tick count, 1.573.040 maximum */
int GetRTC( struct RealTimeClock * ); /* 1:read successful, 0:error */

int BreakFlag( int );
void ExitProc( int );
void _far *AllocMem( unsigned long );
unsigned int  AllocSeg( unsigned int );
int FreeMem( unsigned int );
void Sound( int, int ); /* frequency, duration */

unsigned int  LastErr( void );
void  DiskReset( void );
int  SelectDisk( int );
int  GetNumDrives( void );
int  GetCurrDisk( void );
struct DriveData *GetDriveData( unsigned char );
void  SetVerifyFlag( int );
struct DiskTransferArea  _far *GetDTAAddress( void );
void  GetDOSParmBlock( struct DOSParmBlock _far * );
unsigned int  CreateDir( char _far * );
unsigned int  DeleteDir( char _far * );
unsigned int  SetCurrDir( char _far * );
int  Create( char _far *, unsigned int );
int  Open( char *, int );
unsigned char _Access( char *, int );
int  Close( int );
unsigned int  _Read( int, char _far *, unsigned int );
unsigned int _ReadLine( int fptr, char _far *buf, unsigned int maxlen );
unsigned int  _Write( int, char _far *, unsigned int );
int  Delete( char _far * );
unsigned long  Seek( int, unsigned long, unsigned int );
unsigned int  GetFileAttr( char _far * );
unsigned int  SetFileAttr( unsigned int );
unsigned int  GetCurrDir( char _far * );
unsigned int  FindFirstFile( char _far *, unsigned int );
unsigned int  FindNextFile( void );
unsigned int Rename( char *, char * );
unsigned long GetFileDate( int );
int SetFileDate( unsigned long, int );
unsigned char GetBreakFlag( void );
void SetBreakFlag( unsigned char );

unsigned int  GetExtError( void );
struct DOSError *DOSError( int );

#endif
