typedef struct font_struct {
    unsigned font_number;
    unsigned font_checksum;
    double font_dsize;
    string font_name;
    string font_area;
    fix font_at;
    char *ovf_packet;
    unsigned ovf_packet_length;
    boolean font_at_defined;
    boolean font_dsize_defined;
    boolean font_checksum_defined;
} font;

typedef struct move_struct {
    fix wfix;
    fix xfix;
    fix yfix;
    fix zfix;
    unsigned h;
    unsigned v;
} move;

extern font *font_table;
extern unsigned no_fonts;
extern unsigned cur_font_index;
extern font *cur_font;
extern char *cur_packet;

extern string vtitle;

extern unsigned packet_table_size;
extern char *packet_table;
extern char *cur_packet;
extern unsigned packet_ptr;

extern void clear_map_font(unsigned);
extern void init_map_font(unsigned);
extern void set_font_name(string );
extern void set_font_area(string );
extern void set_font_check_sum(unsigned);
extern void set_font_at(fix);
extern void set_font_design_size(fix);

extern void set_vtitle(string );
extern void init_map(void);
extern void end_map(void);
extern void set_select_font(unsigned);
extern void set_set_char(unsigned);
extern void set_set_rule(fix, fix);
extern void set_move(unsigned, fix);
extern void set_push(void);
extern void set_pop(void);
extern void set_special(string );
extern void set_special_hex(string );
extern unsigned get_hex(unsigned char);

extern void append_command(unsigned, unsigned);
extern void append_command_2(unsigned, unsigned, unsigned, unsigned);
extern void append_to_packet_fix(unsigned, fix);
extern void move_table_init(void);
extern void font_table_init(void);

extern void packet_table_init(void);
extern void packet_table_end(void);
extern void out_ovf(unsigned);
